<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsm="http://www.schematron-quickfix.com/manipulator/process" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:es="http://www.escali.schematron-quickfix.com/" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" exclude-result-prefixes=" sch xsm svrl xsl es xs sqf xml xsl" version="2.0" xpath-default-namespace="http://www.w3.org/1999/xhtml">
    <xsl:include href="file:/D:/nico/Work/Java/net.sqf.escali/xml/xsl/01_compiler/escali_compiler_0_functions.xsl"/>
    <xsl:param name="xsm:xml-save-mode" select="'true'"/>
    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test="$xsm:xml-save-mode = 'true'">
                <xsm:manipulator document="">
                    <xsl:apply-templates select="node()">
                        <xsl:with-param name="xsm:xml-save-mode" select="true()" as="xs:boolean" tunnel="yes"/>
                    </xsl:apply-templates>
                </xsm:manipulator>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="node()">
                    <xsl:with-param name="xsm:xml-save-mode" select="false()" as="xs:boolean" tunnel="yes"/>
                </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:output method="xml"/>
    <xsl:key name="sqf:nodesById" match="node()" use="generate-id()"/>
    <xsl:template match="node()|@*" priority="-2" mode="addAtt addChild"/>
    <xsl:template match="node() | @*" priority="-3" mode="#all">
        <xsl:param name="xsm:xml-save-mode" tunnel="yes" select="false()" as="xs:boolean"/>
        <xsl:choose>
            <xsl:when test="$xsm:xml-save-mode">
                <xsl:apply-templates select="node() | @*"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="node() | @*"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="/*[namespace-uri()='http://www.w3.org/1999/xhtml'][local-name()='html'][1]/*[namespace-uri()='http://www.w3.org/1999/xhtml'][local-name()='body'][1]/*[namespace-uri()='http://www.w3.org/1999/xhtml'][local-name()='h2'][1]" priority="11">
        <xsl:param name="xsm:xml-save-mode" select="false()" as="xs:boolean" tunnel="yes"/>
        <xsl:variable name="ruleContext" select="/*[namespace-uri()='http://www.w3.org/1999/xhtml'][local-name()='html'][1]/*[namespace-uri()='http://www.w3.org/1999/xhtml'][local-name()='body'][1]"/>
        <xsl:variable name="activityContext" select="self::node()"/>
        <xsl:for-each select="$ruleContext">
            <xsl:variable name="firstDescendantHeading" select="descendant::node()[name()=('h1','h2','h3','h4','h5','h6')][1]"/>
            <xsl:for-each select="$activityContext">
                <xsl:choose>
                    <xsl:when test="$xsm:xml-save-mode">
                        <xsm:replace>
                            <xsl:attribute name="node" select="es:getNodePath(.)"/>
                            <xsm:content>
                                <xsl:processing-instruction name="sqfc-start">
                                    <xsl:text>replace-</xsl:text>
                                    <xsl:value-of select="generate-id()"/>
                                 </xsl:processing-instruction>
                                <xsl:element name="h1">
                                    <xsl:value-of select="."/>
                                </xsl:element>
                                <xsl:processing-instruction name="sqfc-end">
                                    <xsl:text>replace-</xsl:text>
                                    <xsl:value-of select="generate-id()"/>
                                 </xsl:processing-instruction>
                            </xsm:content>
                        </xsm:replace>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:processing-instruction name="sqfc-start">
                              <xsl:text>replace-</xsl:text>
                              <xsl:value-of select="generate-id()"/>
                           </xsl:processing-instruction>
                        <xsl:element name="h1">
                            <xsl:value-of select="."/>
                        </xsl:element>
                        <xsl:processing-instruction name="sqfc-end">
                              <xsl:text>replace-</xsl:text>
                              <xsl:value-of select="generate-id()"/>
                           </xsl:processing-instruction>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
