<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" queryBinding="xslt2" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <pattern>
        <rule context="para">
            <let name="words" value="tokenize(., '\s')"/>
            <let name="dict" value="doc('dict.xml')"/>
            <let name="missingWords" value="$words[not(replace(., '[^a-zA-Z]', '') = $dict/*/word/normalize-space(.))]"/>
            <report test="count($missingWords) gt 0" sqf:fix="addToDict">The words <value-of select="string-join($missingWords, ', ')"/> are not in the dictionary.</report>
            <sqf:fix id="addToDict">
                <sqf:description>
                    <sqf:title>Add the words <value-of select="string-join($missingWords, ', ')"/> to the dict.</sqf:title>
                </sqf:description>
                <sqf:add match="$dict/*" position="last-child">
                    <xsl:for-each select="$missingWords" xmlns="">
                        <word><sch:value-of select="."/></word>
                    </xsl:for-each>
                </sqf:add>
            </sqf:fix>
        </rule>
    </pattern>
</schema>
