/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritableDocument;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.Output;
import com.xmlcalabash.util.ParseArgs;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.UserArgs;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.xml.sax.InputSource;

public class Main {
    private static QName _code = new QName("code");
    private static int exitStatus = 0;
    private XProcRuntime runtime = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean debug = false;

    public static void main(String[] args) throws IOException {
        Main main = new Main();
        main.run(args);
        System.exit(exitStatus);
    }

    /*
     * Unable to fully structure code
     */
    public void run(String[] args) throws IOException {
        block13: {
            userArgs = null;
            try {
                userArgs = new ParseArgs().parse(args);
            }
            catch (XProcException xe) {
                System.err.println(xe.getMessage());
                this.usage();
            }
            try {
                config = userArgs.createConfiguration();
                if (this.run(userArgs, config)) {
                    System.out.println();
                }
                this.runtime.close();
            }
            catch (UnsupportedOperationException uoe) {
                this.usage();
            }
            catch (XProcException err) {
                Main.exitStatus = 1;
                if (err.getErrorCode() != null) {
                    this.error(this.logger, null, this.errorMessage(err.getErrorCode()), err.getErrorCode());
                } else {
                    this.error(this.logger, null, err.toString(), null);
                }
                cause = err.getCause();
                ** while (cause != null && cause instanceof XProcException)
            }
lbl-1000:
            // 1 sources

            {
                cause = cause.getCause();
                continue;
            }
lbl27:
            // 1 sources

            if (cause != null) {
                this.error(this.logger, null, "Underlying exception: " + cause, null);
            }
            if (this.debug) {
                err.printStackTrace();
            }
            break block13;
            catch (Exception err) {
                Main.exitStatus = 1;
                this.error(this.logger, null, "Pipeline failed: " + err.toString(), null);
                if (err.getCause() != null) {
                    cause = err.getCause();
                    this.error(this.logger, null, "Underlying exception: " + cause, null);
                }
                if (!this.debug) break block13;
                err.printStackTrace();
            }
        }
    }

    boolean run(UserArgs userArgs, XProcConfiguration config) throws SaxonApiException, IOException, URISyntaxException {
        RuntimeValue value;
        Output output;
        Map<QName, String> parameters;
        this.runtime = new XProcRuntime(config);
        this.debug = config.debug;
        if (userArgs.isShowVersion()) {
            this.showVersion();
        }
        XPipeline pipeline = null;
        if (userArgs.getPipeline() != null) {
            pipeline = this.runtime.load(userArgs.getPipeline());
        } else if (userArgs.hasImplicitPipeline()) {
            XdmNode implicitPipeline = userArgs.getImplicitPipeline(this.runtime);
            if (this.debug) {
                System.err.println("Implicit pipeline:");
                Iterator<String> serializer = new Serializer();
                ((Serializer)((Object)serializer)).setOutputProperty(Serializer.Property.INDENT, "yes");
                ((Serializer)((Object)serializer)).setOutputProperty(Serializer.Property.METHOD, "xml");
                ((Serializer)((Object)serializer)).setOutputStream(System.err);
                S9apiUtils.serialize(this.runtime, implicitPipeline, serializer);
            }
            pipeline = this.runtime.use(implicitPipeline);
        } else if (config.pipeline != null) {
            XdmNode doc = config.pipeline.read();
            pipeline = this.runtime.use(doc);
        } else {
            throw new UnsupportedOperationException("Either a pipeline or libraries and / or steps must be given");
        }
        for (String port : config.params.keySet()) {
            parameters = (Map<QName, String>)config.params.get(port);
            this.setParametersOnPipeline(pipeline, port, parameters);
        }
        for (String port : userArgs.getParameterPorts()) {
            parameters = userArgs.getParameters(port);
            this.setParametersOnPipeline(pipeline, port, parameters);
        }
        Set<String> ports = pipeline.getInputs();
        Set<String> userArgsInputPorts = userArgs.getInputPorts();
        Set<String> cfgInputPorts = config.inputs.keySet();
        HashSet<String> allPorts = new HashSet<String>();
        allPorts.addAll(userArgsInputPorts);
        allPorts.addAll(cfgInputPorts);
        for (String port : ports) {
            if (allPorts.contains(port) || !allPorts.contains(null) || !pipeline.getDeclareStep().getInput(port).getPrimary() || pipeline.getDeclareStep().getInput(port).getParameterInput()) continue;
            if (!userArgsInputPorts.contains(null)) break;
            userArgs.setDefaultInputPort(port);
            allPorts.remove(null);
            allPorts.add(port);
            break;
        }
        for (String port : allPorts) {
            if (!ports.contains(port)) {
                throw new XProcException("There is a binding for the port '" + port + "' but the pipeline declares no such port.");
            }
            pipeline.clearInputs(port);
            if (userArgsInputPorts.contains(port)) {
                XdmNode doc = null;
                for (Input input : userArgs.getInputs(port)) {
                    block0 : switch (input.getType()) {
                        case XML: {
                            InputStream inputStream;
                            switch (input.getKind()) {
                                case URI: {
                                    String uri = input.getUri();
                                    if ("-".equals(uri)) {
                                        doc = this.runtime.parse(new InputSource(System.in));
                                        break block0;
                                    }
                                    doc = this.runtime.parse(new InputSource(uri));
                                    break block0;
                                }
                                case INPUT_STREAM: {
                                    inputStream = input.getInputStream();
                                    doc = this.runtime.parse(new InputSource(inputStream));
                                    inputStream.close();
                                    break block0;
                                }
                            }
                            throw new UnsupportedOperationException(String.format("Unsupported input kind '%s'", new Object[]{input.getKind()}));
                        }
                        case DATA: {
                            InputStream inputStream;
                            switch (input.getKind()) {
                                case URI: {
                                    ReadableData rd = new ReadableData(this.runtime, XProcConstants.c_data, input.getUri(), input.getContentType());
                                    doc = rd.read();
                                    break block0;
                                }
                                case INPUT_STREAM: {
                                    inputStream = input.getInputStream();
                                    ReadableData rd = new ReadableData(this.runtime, XProcConstants.c_data, inputStream, input.getContentType());
                                    doc = rd.read();
                                    inputStream.close();
                                    break block0;
                                }
                            }
                            throw new UnsupportedOperationException(String.format("Unsupported input kind '%s'", new Object[]{input.getKind()}));
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("Unsupported input type '%s'", new Object[]{input.getType()}));
                        }
                    }
                    pipeline.writeTo(port, doc);
                }
                continue;
            }
            for (Object pipe : config.inputs.get(port)) {
                XdmNode doc = pipe.read();
                pipeline.writeTo(port, doc);
            }
        }
        String implicitPort = null;
        for (String port : ports) {
            if (allPorts.contains(port) || !pipeline.getDeclareStep().getInput(port).getPrimary() || pipeline.getDeclareStep().getInput(port).getParameterInput()) continue;
            implicitPort = port;
        }
        if (implicitPort != null && !pipeline.hasReadablePipes(implicitPort)) {
            XdmNode doc = this.runtime.parse(new InputSource(System.in));
            pipeline.writeTo(implicitPort, doc);
        }
        HashMap<String, Output> portOutputs = new HashMap<String, Output>();
        Map<String, Output> userArgsOutputs = userArgs.getOutputs();
        for (String string : pipeline.getOutputs()) {
            output = null;
            if (userArgsOutputs.containsKey(string)) {
                output = userArgsOutputs.get(string);
            } else if (config.outputs.containsKey(string)) {
                output = new Output(config.outputs.get(string));
            } else if (userArgsOutputs.containsKey(null) && pipeline.getDeclareStep().getOutput(string).getPrimary()) {
                output = userArgsOutputs.get(null);
            }
            if (output != null && output.getKind() == Output.Kind.URI && "-".equals(output.getUri())) {
                output = null;
            }
            portOutputs.put(string, output);
        }
        for (QName qName : config.options.keySet()) {
            value = new RuntimeValue(config.options.get(qName), null, null);
            pipeline.passOption(qName, value);
        }
        for (QName qName : userArgs.getOptionNames()) {
            value = new RuntimeValue(userArgs.getOption(qName), null, null);
            pipeline.passOption(qName, value);
        }
        pipeline.run();
        for (String string : pipeline.getOutputs()) {
            if (!portOutputs.containsKey(string)) continue;
            output = (Output)portOutputs.get(string);
            if (output == null || output.getKind() == Output.Kind.OUTPUT_STREAM && System.out.equals(output.getOutputStream())) {
                this.finest(this.logger, null, "Copy output from " + string + " to stdout");
            } else {
                switch (output.getKind()) {
                    case URI: {
                        this.finest(this.logger, null, "Copy output from " + string + " to " + output.getUri());
                        break;
                    }
                    case OUTPUT_STREAM: {
                        String outputStreamClassName = output.getOutputStream().getClass().getName();
                        this.finest(this.logger, null, "Copy output from " + string + " to " + outputStreamClassName + " stream");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported output kind '%s'", new Object[]{output.getKind()}));
                    }
                }
            }
            Serialization serial = pipeline.getSerialization(string);
            if (serial == null) {
                serial = new Serialization(this.runtime, pipeline.getNode());
                for (String name : config.serializationOptions.keySet()) {
                    String value2 = config.serializationOptions.get(name);
                    if ("byte-order-mark".equals(name)) {
                        serial.setByteOrderMark("true".equals(value2));
                    }
                    if ("escape-uri-attributes".equals(name)) {
                        serial.setEscapeURIAttributes("true".equals(value2));
                    }
                    if ("include-content-type".equals(name)) {
                        serial.setIncludeContentType("true".equals(value2));
                    }
                    if ("indent".equals(name)) {
                        serial.setIndent("true".equals(value2));
                    }
                    if ("omit-xml-declaration".equals(name)) {
                        serial.setOmitXMLDeclaration("true".equals(value2));
                    }
                    if ("undeclare-prefixes".equals(name)) {
                        serial.setUndeclarePrefixes("true".equals(value2));
                    }
                    if ("method".equals(name)) {
                        serial.setMethod(new QName("", value2));
                    }
                    if ("doctype-public".equals(name)) {
                        serial.setDoctypePublic(value2);
                    }
                    if ("doctype-system".equals(name)) {
                        serial.setDoctypeSystem(value2);
                    }
                    if ("encoding".equals(name)) {
                        serial.setEncoding(value2);
                    }
                    if ("media-type".equals(name)) {
                        serial.setMediaType(value2);
                    }
                    if ("normalization-form".equals(name)) {
                        serial.setNormalizationForm(value2);
                    }
                    if ("standalone".equals(name)) {
                        serial.setStandalone(value2);
                    }
                    if (!"version".equals(name)) continue;
                    serial.setVersion(value2);
                }
            }
            WritableDocument wd = null;
            if (output == null) {
                wd = new WritableDocument(this.runtime, null, serial);
            } else {
                switch (output.getKind()) {
                    case URI: {
                        URI furi = new URI(output.getUri());
                        String filename = furi.getPath();
                        FileOutputStream outfile = new FileOutputStream(filename);
                        wd = new WritableDocument(this.runtime, filename, serial, outfile);
                        break;
                    }
                    case OUTPUT_STREAM: {
                        OutputStream outputStream = output.getOutputStream();
                        wd = new WritableDocument(this.runtime, null, serial, outputStream);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported output kind '%s'", new Object[]{output.getKind()}));
                    }
                }
            }
            ReadablePipe rpipe = pipeline.readFrom(string);
            while (rpipe.moreDocuments()) {
                wd.write(rpipe.read());
            }
            if (output == null) continue;
            wd.close();
        }
        return portOutputs.containsValue(null);
    }

    private void setParametersOnPipeline(XPipeline pipeline, String port, Map<QName, String> parameters) {
        if ("*".equals(port)) {
            for (QName name : parameters.keySet()) {
                pipeline.setParameter(name, new RuntimeValue(parameters.get(name)));
            }
        } else {
            for (QName name : parameters.keySet()) {
                pipeline.setParameter(port, name, new RuntimeValue(parameters.get(name)));
            }
        }
    }

    private void showVersion() {
        System.out.println("XML Calabash version " + XProcConstants.XPROC_VERSION + ", an XProc processor.");
        if (this.runtime != null) {
            System.out.print("Running on Saxon version ");
            System.out.print(this.runtime.getConfiguration().getProcessor().getSaxonProductVersion());
            System.out.print(", ");
            System.out.print(this.runtime.getConfiguration().getProcessor().getUnderlyingConfiguration().getEditionCode());
            System.out.println(" edition.");
        }
        System.out.println("Copyright (c) 2007-2012 Norman Walsh");
        System.out.println("See docs/notices/NOTICES in the distribution for licensing");
        System.out.println("See also http://xmlcalabash.com/ for more information");
        System.out.println("");
    }

    private void usage() throws IOException {
        System.out.println();
        this.showVersion();
        InputStream instream = this.getClass().getResourceAsStream("/etc/usage.txt");
        if (instream == null) {
            throw new UnsupportedOperationException("Failed to load usage text from JAR file. This \"can't happen\".");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(instream));
        String line = null;
        while ((line = br.readLine()) != null) {
            System.err.println(line);
        }
        instream.close();
        br.close();
        System.exit(1);
    }

    private String errorMessage(QName code) {
        InputStream instream = this.getClass().getResourceAsStream("/etc/error-list.xml");
        if (instream != null) {
            XdmNode doc = this.runtime.parse(new InputSource(instream));
            XdmSequenceIterator iter = doc.axisIterator(Axis.DESCENDANT, new QName("http://www.w3.org/ns/xproc-error", "error"));
            while (iter.hasNext()) {
                XdmNode error = (XdmNode)iter.next();
                if (!code.getLocalName().equals(error.getAttributeValue(_code))) continue;
                return error.getStringValue();
            }
        }
        return "Unknown error";
    }

    private String message(XdmNode node, String message) {
        String baseURI = "(unknown URI)";
        int lineNumber = -1;
        if (node != null) {
            baseURI = node.getBaseURI().toASCIIString();
            lineNumber = node.getLineNumber();
            return String.valueOf(baseURI) + ":" + lineNumber + ": " + message;
        }
        return message;
    }

    public void error(Logger logger, XdmNode node, String message, QName code) {
        logger.severe(this.message(node, message));
    }

    public void warning(Logger logger, XdmNode node, String message) {
        logger.warning(this.message(node, message));
    }

    public void info(Logger logger, XdmNode node, String message) {
        logger.info(this.message(node, message));
    }

    public void fine(Logger logger, XdmNode node, String message) {
        logger.fine(this.message(node, message));
    }

    public void finer(Logger logger, XdmNode node, String message) {
        logger.finer(this.message(node, message));
    }

    public void finest(Logger logger, XdmNode node, String message) {
        logger.finest(this.message(node, message));
    }
}

