/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.S9apiUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class WritableDocument
implements WritablePipe {
    private Serializer serializer = null;
    private int writeCount = 0;
    private String uri = null;
    private URI journal = null;
    private XProcRuntime runtime = null;
    private Serialization serial = null;
    private boolean writeSeqOk = false;
    private Step writer = null;
    private OutputStream ostream = null;

    public WritableDocument(XProcRuntime xproc, String uri, Serialization serial) {
        this.runtime = xproc;
        this.uri = uri;
        if (serial == null) {
            this.serial = new Serialization(xproc, null);
            this.serial.setIndent(xproc.getDebug());
        } else {
            this.serial = serial;
        }
    }

    public WritableDocument(XProcRuntime xproc, String uri, Serialization serial, OutputStream out) {
        this.runtime = xproc;
        this.uri = uri;
        this.ostream = out;
        if (serial == null) {
            this.serial = new Serialization(xproc, null);
            this.serial.setIndent(xproc.getDebug());
        } else {
            this.serial = serial;
        }
    }

    @Override
    public void canWriteSequence(boolean sequence) {
        this.writeSeqOk = sequence;
    }

    @Override
    public boolean writeSequence() {
        return this.writeSeqOk;
    }

    @Override
    public void resetWriter() {
        throw new UnsupportedOperationException("You can't resetWriter a WritableDocument");
    }

    @Override
    public void close() {
        if (this.ostream != null) {
            try {
                this.ostream.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void setWriter(Step step) {
        this.writer = step;
    }

    @Override
    public void write(XdmNode doc) {
        try {
            this.serializer = new Serializer();
            this.serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, this.serial.getByteOrderMark() ? "yes" : "no");
            if (this.serial.getDoctypePublic() != null) {
                this.serializer.setOutputProperty(Serializer.Property.DOCTYPE_PUBLIC, this.serial.getDoctypePublic());
            }
            if (this.serial.getDoctypeSystem() != null) {
                this.serializer.setOutputProperty(Serializer.Property.DOCTYPE_SYSTEM, this.serial.getDoctypeSystem());
            }
            if (this.serial.getEncoding() != null) {
                this.serializer.setOutputProperty(Serializer.Property.ENCODING, this.serial.getEncoding());
            }
            this.serializer.setOutputProperty(Serializer.Property.ESCAPE_URI_ATTRIBUTES, this.serial.getEscapeURIAttributes() ? "yes" : "no");
            this.serializer.setOutputProperty(Serializer.Property.INCLUDE_CONTENT_TYPE, this.serial.getIncludeContentType() ? "yes" : "no");
            this.serializer.setOutputProperty(Serializer.Property.INDENT, this.serial.getIndent() ? "yes" : "no");
            if (this.serial.getMediaType() != null) {
                this.serializer.setOutputProperty(Serializer.Property.MEDIA_TYPE, this.serial.getMediaType());
            }
            if (this.serial.getMethod() != null) {
                this.serializer.setOutputProperty(Serializer.Property.METHOD, this.serial.getMethod().getLocalName());
            }
            if (this.serial.getNormalizationForm() != null) {
                this.serializer.setOutputProperty(Serializer.Property.NORMALIZATION_FORM, this.serial.getNormalizationForm());
            }
            this.serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, this.serial.getOmitXMLDeclaration() ? "yes" : "no");
            if (this.serial.getStandalone() != null) {
                String standalone = this.serial.getStandalone();
                if ("true".equals(standalone)) {
                    this.serializer.setOutputProperty(Serializer.Property.STANDALONE, "yes");
                } else if ("false".equals(standalone)) {
                    this.serializer.setOutputProperty(Serializer.Property.STANDALONE, "no");
                }
            }
            this.serializer.setOutputProperty(Serializer.Property.UNDECLARE_PREFIXES, this.serial.getUndeclarePrefixes() ? "yes" : "no");
            if (this.serial.getVersion() != null) {
                this.serializer.setOutputProperty(Serializer.Property.VERSION, this.serial.getVersion());
            }
            if (this.ostream != null) {
                this.serializer.setOutputStream(this.ostream);
            } else if (this.uri == null) {
                this.serializer.setOutputStream(System.out);
            } else {
                try {
                    URI ouri = new URI(this.uri);
                    if ("file".equals(ouri.getScheme())) {
                        this.runtime.finest(null, null, "Attempt to write file: " + this.uri);
                        File file = new File(this.decodeUTF8(ouri.toURL().getFile()));
                        this.serializer.setOutputFile(file);
                    } else {
                        this.runtime.finest(null, null, "Attempt to write: " + this.uri);
                        URL url = new URL(this.uri);
                        URLConnection conn = url.openConnection();
                        conn.setDoOutput(true);
                        this.ostream = conn.getOutputStream();
                        this.serializer.setOutputStream(this.ostream);
                    }
                }
                catch (IOException ex) {
                    this.runtime.error(ex);
                }
                catch (URISyntaxException use) {
                    this.runtime.error(use);
                }
            }
            S9apiUtils.serialize(this.runtime, doc, this.serializer);
            if ((this.ostream == null && this.uri == null || System.out.equals(this.ostream)) && this.runtime.getDebug()) {
                System.out.println("\n--<document boundary>--------------------------------------------------------------------------");
            }
        }
        catch (SaxonApiException sae) {
            if (this.runtime.getDebug()) {
                sae.printStackTrace();
            }
            throw new XProcException(sae);
        }
        if (this.writer != null) {
            this.runtime.finest(null, this.writer.getNode(), String.valueOf(this.writer.getName()) + " wrote '" + (doc == null ? "null" : doc.getBaseURI()));
        }
    }

    public int documentsWritten() {
        return this.writeCount;
    }

    public int documentsRead() {
        return 1;
    }

    private String decodeUTF8(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder sbuf = new StringBuilder();
        int l = s.length();
        int ch = -1;
        int b = 0;
        int sumb = 0;
        boolean applyUTF8dec = false;
        int i = 0;
        int more = -1;
        while (i < l) {
            char current = s.charAt(i);
            ch = current;
            switch (ch) {
                case 37: {
                    if (i + 2 >= s.length()) break;
                    int hb = (Character.isDigit((char)(ch = (int)s.charAt(++i))) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    applyUTF8dec = true;
                    break;
                }
                default: {
                    b = ch;
                    applyUTF8dec = false;
                }
            }
            if (applyUTF8dec) {
                if ((b & 0xC0) == 128) {
                    sumb = sumb << 6 | b & 0x3F;
                    if (--more == 0) {
                        sbuf.append((char)sumb);
                    }
                } else if ((b & 0x80) == 0) {
                    sbuf.append((char)b);
                } else if ((b & 0xE0) == 192) {
                    sumb = b & 0x1F;
                    more = 1;
                } else if ((b & 0xF0) == 224) {
                    sumb = b & 0xF;
                    more = 2;
                } else if ((b & 0xF8) == 240) {
                    sumb = b & 7;
                    more = 3;
                } else if ((b & 0xFC) == 248) {
                    sumb = b & 3;
                    more = 4;
                } else {
                    sumb = b & 1;
                    more = 5;
                }
            } else {
                sbuf.append(current);
                more = -1;
            }
            ++i;
        }
        return sbuf.toString();
    }
}

