/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.TreeWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceIterator;
import org.xml.sax.InputSource;

public class S9apiUtils {
    private static final QName vara = new QName("", "vara");
    private static final QName varb = new QName("", "varb");

    public static void writeXdmValue(XProcRuntime runtime, Vector<XdmValue> values, Destination destination, URI baseURI) throws SaxonApiException {
        S9apiUtils.writeXdmValue(runtime.getProcessor(), values, destination, baseURI);
    }

    public static void writeXdmValue(Processor proc, Vector<XdmValue> values, Destination destination, URI baseURI) throws SaxonApiException {
        try {
            Configuration config = proc.getUnderlyingConfiguration();
            PipelineConfiguration pipeConfig = config.makePipelineConfiguration();
            Receiver out = destination.getReceiver(config);
            out = new NamespaceReducer(out);
            TreeReceiver tree = new TreeReceiver(out);
            tree.setPipelineConfiguration(pipeConfig);
            if (baseURI != null) {
                tree.setSystemId(baseURI.toASCIIString());
            }
            tree.open();
            tree.startDocument(0);
            for (XdmValue value : values) {
                for (XdmItem item : value) {
                    tree.append((Item)item.getUnderlyingValue(), 0, 2);
                }
            }
            tree.endDocument();
            tree.close();
        }
        catch (XPathException err) {
            throw new SaxonApiException(err);
        }
    }

    public static void writeXdmValue(XProcRuntime runtime, XdmItem node, Destination destination, URI baseURI) throws SaxonApiException {
        try {
            Processor proc = runtime.getProcessor();
            Configuration config = proc.getUnderlyingConfiguration();
            PipelineConfiguration pipeConfig = config.makePipelineConfiguration();
            Receiver out = destination.getReceiver(config);
            out = new NamespaceReducer(out);
            TreeReceiver tree = new TreeReceiver(out);
            tree.setPipelineConfiguration(pipeConfig);
            if (baseURI != null) {
                tree.setSystemId(baseURI.toASCIIString());
            }
            tree.open();
            tree.startDocument(0);
            tree.append((Item)node.getUnderlyingValue(), 0, 2);
            tree.endDocument();
            tree.close();
        }
        catch (XPathException err) {
            throw new SaxonApiException(err);
        }
    }

    public static XdmNode getDocumentElement(XdmNode doc) {
        if (doc.getNodeKind() == XdmNodeKind.DOCUMENT) {
            for (XdmNode node : new RelevantNodes(doc, Axis.CHILD, true)) {
                if (node.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                return node;
            }
            return null;
        }
        return doc;
    }

    public static void serialize(XProcRuntime xproc, XdmNode node, Serializer serializer) throws SaxonApiException {
        Vector<XdmNode> nodes = new Vector<XdmNode>();
        nodes.add(node);
        S9apiUtils.serialize(xproc, nodes, serializer);
    }

    public static void serialize(XProcRuntime xproc, Vector<XdmNode> nodes, Serializer serializer) throws SaxonApiException {
        Processor qtproc = xproc.getProcessor();
        XQueryCompiler xqcomp = qtproc.newXQueryCompiler();
        xqcomp.setModuleURIResolver(xproc.getResolver());
        xqcomp.getUnderlyingStaticContext().setSchemaAware(xqcomp.getProcessor().getUnderlyingConfiguration().isLicensedFeature(4));
        XQueryExecutable xqexec = xqcomp.compile(".");
        XQueryEvaluator xqeval = xqexec.load();
        xqeval.setDestination(serializer);
        for (XdmNode node : nodes) {
            xqeval.setContextItem(node);
            xqeval.run();
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        }
    }

    public static boolean xpathEqual(Processor proc, XdmItem a, XdmItem b) {
        try {
            XPathCompiler c = proc.newXPathCompiler();
            c.declareVariable(vara);
            c.declareVariable(varb);
            XPathExecutable xexec = c.compile("$vara = $varb");
            XPathSelector selector = xexec.load();
            selector.setVariable(vara, a);
            selector.setVariable(varb, b);
            Iterator<XdmItem> values = selector.iterator();
            XdmAtomicValue item = (XdmAtomicValue)values.next();
            boolean same = item.getBooleanValue();
            return same;
        }
        catch (SaxonApiException sae) {
            return false;
        }
    }

    public static InputSource xdmToInputSource(XProcRuntime runtime, XdmNode node) throws SaxonApiException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Serializer serializer = new Serializer();
        serializer.setOutputStream(out);
        S9apiUtils.serialize(runtime, node, serializer);
        InputSource isource = new InputSource(new ByteArrayInputStream(out.toByteArray()));
        if (node.getBaseURI() != null) {
            isource.setSystemId(node.getBaseURI().toASCIIString());
        }
        return isource;
    }

    public static HashSet<String> excludeInlinePrefixes(XdmNode node, String prefixList) {
        HashSet<String> excludeURIs = new HashSet<String>();
        excludeURIs.add("http://www.w3.org/ns/xproc");
        if (prefixList != null) {
            NodeInfo inode = node.getUnderlyingNode();
            InscopeNamespaceResolver inscopeNS = new InscopeNamespaceResolver(inode);
            boolean all = false;
            String[] stringArray = prefixList.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pfx = stringArray[n2];
                boolean found = false;
                if ("#all".equals(pfx)) {
                    found = true;
                    all = true;
                } else if ("#default".equals(pfx)) {
                    boolean bl = found = inscopeNS.getURIForPrefix("", true) != null;
                    if (found) {
                        excludeURIs.add(inscopeNS.getURIForPrefix("", true));
                    }
                } else {
                    boolean bl = found = inscopeNS.getURIForPrefix(pfx, false) != null;
                    if (found) {
                        excludeURIs.add(inscopeNS.getURIForPrefix(pfx, false));
                    }
                }
                if (!found) {
                    throw new XProcException(XProcConstants.staticError(57), node, "No binding for '" + pfx + ":'");
                }
                ++n2;
            }
            if (all) {
                Iterator<String> pfxiter = inscopeNS.iteratePrefixes();
                while (pfxiter.hasNext()) {
                    String pfx = pfxiter.next();
                    boolean def = "".equals(pfx);
                    excludeURIs.add(inscopeNS.getURIForPrefix(pfx, def));
                }
            }
        }
        return excludeURIs;
    }

    public static XdmNode removeNamespaces(XProcRuntime runtime, XdmNode node, HashSet<String> excludeNS, boolean preserveUsed) {
        return S9apiUtils.removeNamespaces(runtime.getProcessor(), node, excludeNS, preserveUsed);
    }

    public static XdmNode removeNamespaces(Processor proc, XdmNode node, HashSet<String> excludeNS, boolean preserveUsed) {
        TreeWriter tree = new TreeWriter(proc);
        tree.startDocument(node.getBaseURI());
        S9apiUtils.removeNamespacesWriter(tree, node, excludeNS, preserveUsed);
        tree.endDocument();
        return tree.getResult();
    }

    private static void removeNamespacesWriter(TreeWriter tree, XdmNode node, HashSet<String> excludeNS, boolean preserveUsed) {
        if (node.getNodeKind() == XdmNodeKind.DOCUMENT) {
            XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode cnode = (XdmNode)iter.next();
                S9apiUtils.removeNamespacesWriter(tree, cnode, excludeNS, preserveUsed);
            }
        } else if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            NamespaceBinding binding;
            boolean usesDefaultNS = "".equals(node.getNodeName().getPrefix()) && !"".equals(node.getNodeName().getNamespaceURI());
            NodeInfo inode = node.getUnderlyingNode();
            int nscount = 0;
            Iterator<NamespaceBinding> nsiter = NamespaceIterator.iterateNamespaces(inode);
            while (nsiter.hasNext()) {
                ++nscount;
                nsiter.next();
            }
            boolean excludeDefault = false;
            boolean changed = false;
            NamespaceBinding[] newNS = null;
            if (nscount > 0) {
                newNS = new NamespaceBinding[nscount];
                int newpos = 0;
                nsiter = NamespaceIterator.iterateNamespaces(inode);
                while (nsiter.hasNext()) {
                    NamespaceBinding ns = nsiter.next();
                    String pfx = ns.getPrefix();
                    String uri = ns.getURI();
                    boolean delete = excludeNS.contains(uri);
                    boolean bl = excludeDefault = excludeDefault || "".equals(pfx) && delete;
                    if ("".equals(pfx) && usesDefaultNS && preserveUsed) {
                        delete = false;
                    }
                    boolean bl2 = changed = changed || delete;
                    if (delete) continue;
                    newNS[newpos++] = ns;
                }
                NamespaceBinding[] onlyNewNS = new NamespaceBinding[newpos];
                int pos = 0;
                while (pos < newpos) {
                    onlyNewNS[pos] = newNS[pos];
                    ++pos;
                }
                newNS = onlyNewNS;
            }
            NodeName newName = new NameOfNode(inode);
            if (!preserveUsed && excludeNS.contains((binding = newName.getNamespaceBinding()).getURI())) {
                newName = new FingerprintedQName("", "", newName.getLocalPart());
            }
            tree.addStartElement(newName, inode.getSchemaType(), newNS);
            if (!preserveUsed) {
                XdmSequenceIterator attriter = node.axisIterator(Axis.ATTRIBUTE);
                while (attriter.hasNext()) {
                    XdmNode attr = (XdmNode)attriter.next();
                    String attrns = attr.getNodeName().getNamespaceURI();
                    if (excludeNS.contains(attrns)) {
                        tree.addAttribute(new QName(attr.getNodeName().getLocalName()), attr.getStringValue());
                        continue;
                    }
                    tree.addAttribute(attr);
                }
            } else {
                tree.addAttributes(node);
            }
            XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode cnode = (XdmNode)iter.next();
                S9apiUtils.removeNamespacesWriter(tree, cnode, excludeNS, preserveUsed);
            }
            tree.addEndElement();
        } else {
            tree.addSubtree(node);
        }
    }

    public static void dumpTree(XdmNode tree, String message) {
        NodeInfo treeNode = tree.getUnderlyingNode();
        System.err.println(message);
        System.err.println("Dumping tree: " + treeNode.getSystemId() + ", " + tree.getBaseURI());
        XdmSequenceIterator iter = tree.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            S9apiUtils.dumpTreeNode(child, "  ");
        }
    }

    private static void dumpTreeNode(XdmNode node, String indent) {
        if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            System.err.println(String.valueOf(indent) + node.getNodeName() + ": " + node.getBaseURI());
            XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
            while (iter.hasNext()) {
                XdmNode child = (XdmNode)iter.next();
                S9apiUtils.dumpTreeNode(child, String.valueOf(indent) + "  ");
            }
        } else if (node.getNodeKind() == XdmNodeKind.TEXT) {
            System.err.println(String.valueOf(indent) + "text: ...");
        }
    }

    public static boolean xpathSyntaxError(SaxonApiException sae) {
        Throwable cause = sae.getCause();
        return cause != null && cause instanceof XPathException;
    }

    public static void assertDocument(XdmNode doc) {
        if (doc.getNodeKind() == XdmNodeKind.DOCUMENT) {
            S9apiUtils.assertDocumentContent(doc.axisIterator(Axis.CHILD));
        } else if (doc.getNodeKind() != XdmNodeKind.ELEMENT) {
            throw XProcException.dynamicError(1, "Document root cannot be " + (Object)((Object)doc.getNodeKind()));
        }
    }

    public static void assertDocumentContent(XdmSequenceIterator iter) {
        int elemCount = 0;
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (++elemCount <= 1) continue;
                throw XProcException.dynamicError(1, "Document must have exactly one top-level element");
            }
            if (child.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION || child.getNodeKind() == XdmNodeKind.COMMENT) continue;
            if (child.getNodeKind() == XdmNodeKind.TEXT) {
                if ("".equals(child.getStringValue().trim())) continue;
                throw XProcException.dynamicError(1, "Only whitespace text nodes can appear at the top level in a document");
            }
            throw XProcException.dynamicError(1, "Document cannot have top level " + (Object)((Object)child.getNodeKind()));
        }
    }

    public static XdmNode getParent(XdmNode node) {
        try {
            return node.getParent();
        }
        catch (ClassCastException cce) {
            return null;
        }
    }
}

