/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.Value;

public class ResolveQName
extends SystemFunction
implements CallableExpression {
    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(context);
        NodeInfo element = (NodeInfo)this.argument[1].evaluateItem(context);
        return this.resolveQName(arg0, element, context);
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        QNameValue result = this.resolveQName((AtomicValue)arguments[0].next(), (NodeInfo)arguments[1].next(), context);
        return Value.asIterator(result);
    }

    private QNameValue resolveQName(AtomicValue qname, NodeInfo element, XPathContext context) throws XPathException {
        StructuredQName qName;
        if (qname == null) {
            return null;
        }
        CharSequence lexicalQName = qname.getStringValueCS();
        NameChecker checker = context.getConfiguration().getNameChecker();
        InscopeNamespaceResolver resolver2 = new InscopeNamespaceResolver(element);
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, true, checker, resolver2);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            throw e;
        }
        return new QNameValue(qName, BuiltInAtomicType.QNAME);
    }
}

