/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.QueryLibrary;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticQueryContext {
    private Configuration config;
    private NamePool namePool;
    private String baseURI;
    private HashMap<String, String> userDeclaredNamespaces;
    private Set userDeclaredVariables;
    private boolean inheritNamespaces = true;
    private boolean preserveNamespaces = true;
    private int constructionMode = 3;
    private NamespaceResolver externalNamespaceResolver = null;
    private String defaultFunctionNamespace;
    private String defaultElementNamespace = "";
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private boolean preserveSpace = false;
    private boolean defaultEmptyLeast = true;
    private ModuleURIResolver moduleURIResolver;
    private ErrorListener errorListener;
    private CodeInjector codeInjector;
    private boolean generateCode = false;
    private boolean isUpdating = false;
    private DecimalValue languageVersion = DecimalValue.ONE;
    private CollationMap collationMap;
    private LocationMap locationMap;
    private boolean schemaAware;

    protected StaticQueryContext() {
    }

    public StaticQueryContext(Configuration config) {
        this(config.getDefaultStaticQueryContext());
        this.config = config;
        this.namePool = config.getNamePool();
        this.errorListener = config.getErrorListener();
        this.moduleURIResolver = config.getModuleURIResolver();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        this.collationMap = new CollationMap(config.getCollationMap());
        this.locationMap = new LocationMap();
        this.schemaAware = (Boolean)config.getConfigurationProperty("http://saxon.sf.net/feature/xquerySchemaAware");
        this.reset();
    }

    public StaticQueryContext(Configuration config, boolean initial) {
        if (initial) {
            this.config = config;
            this.namePool = config.getNamePool();
            this.errorListener = config.getErrorListener();
            this.moduleURIResolver = config.getModuleURIResolver();
            if (this.errorListener instanceof StandardErrorListener) {
                this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
                ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
            }
            this.collationMap = new CollationMap(config.getCollationMap());
            this.locationMap = new LocationMap();
            this.reset();
        } else {
            this.copyFrom(config.getDefaultStaticQueryContext());
        }
    }

    public StaticQueryContext(StaticQueryContext c) {
        this.copyFrom(c);
    }

    private void copyFrom(StaticQueryContext c) {
        this.config = c.config;
        this.namePool = c.namePool;
        this.baseURI = c.baseURI;
        this.moduleURIResolver = c.moduleURIResolver;
        if (c.userDeclaredNamespaces != null) {
            this.userDeclaredNamespaces = new HashMap<String, String>(c.userDeclaredNamespaces);
        }
        if (c.userDeclaredVariables != null) {
            this.userDeclaredVariables = new HashSet(c.userDeclaredVariables);
        }
        this.inheritNamespaces = c.inheritNamespaces;
        this.preserveNamespaces = c.preserveNamespaces;
        this.constructionMode = c.constructionMode;
        this.externalNamespaceResolver = c.externalNamespaceResolver;
        this.defaultElementNamespace = c.defaultElementNamespace;
        this.defaultFunctionNamespace = c.defaultFunctionNamespace;
        this.requiredContextItemType = c.requiredContextItemType;
        this.preserveSpace = c.preserveSpace;
        this.defaultEmptyLeast = c.defaultEmptyLeast;
        this.moduleURIResolver = c.moduleURIResolver;
        this.errorListener = c.errorListener;
        this.codeInjector = c.codeInjector;
        this.generateCode = c.generateCode;
        this.isUpdating = c.isUpdating;
        this.languageVersion = c.languageVersion;
        this.collationMap = new CollationMap(c.collationMap);
        this.locationMap = new LocationMap();
        this.schemaAware = c.schemaAware;
    }

    public void reset() {
        this.userDeclaredNamespaces = new HashMap(10);
        this.externalNamespaceResolver = null;
        this.errorListener = this.config.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
        this.constructionMode = this.getConfiguration().isLicensedFeature(4) ? 3 : 4;
        this.preserveSpace = false;
        this.defaultEmptyLeast = true;
        this.requiredContextItemType = AnyItemType.getInstance();
        this.defaultFunctionNamespace = "http://www.w3.org/2005/xpath-functions";
        this.defaultElementNamespace = "";
        this.moduleURIResolver = this.config.getModuleURIResolver();
        this.clearNamespaces();
        this.generateCode = false;
        this.isUpdating = false;
        this.languageVersion = DecimalValue.ONE;
    }

    public void setConfiguration(Configuration config) {
        if (this.config != null && this.config != config) {
            throw new IllegalArgumentException("Configuration cannot be changed dynamically");
        }
        this.config = config;
        this.namePool = config.getNamePool();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Executable getExecutable() {
        Executable executable = new Executable(this.config);
        executable.setCollationMap(this.collationMap);
        executable.setLocationMap(this.locationMap);
        executable.setSchemaAware(this.schemaAware);
        executable.setHostLanguage(51, this.getLanguageVersion().equals(DecimalValue.THREE));
        return executable;
    }

    public void setSchemaAware(boolean aware) {
        this.schemaAware = aware;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        return this.config.buildDocument(source);
    }

    public void setLanguageVersion(DecimalValue version) {
        if (DecimalValue.ONE.equals(version) || DecimalValue.THREE.equals(version)) {
            this.languageVersion = version;
        } else if (DecimalValue.ONE_POINT_ONE.equals(version)) {
            this.languageVersion = DecimalValue.THREE;
        } else {
            throw new IllegalArgumentException("languageVersion = " + version);
        }
    }

    public DecimalValue getLanguageVersion() {
        return this.languageVersion;
    }

    public FunctionLibrary getExtensionFunctionLibrary() {
        return null;
    }

    public boolean isCompileWithTracing() {
        return this.codeInjector instanceof TraceCodeInjector;
    }

    public void setCompileWithTracing(boolean trace) {
        this.codeInjector = trace ? new TraceCodeInjector() : null;
    }

    public void setCodeInjector(CodeInjector injector) {
        this.codeInjector = injector;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void setGeneratingJavaCode(boolean generateCode) {
        this.generateCode = generateCode;
    }

    public boolean isGeneratingJavaCode() {
        return this.generateCode;
    }

    public void setInheritNamespaces(boolean inherit) {
        this.inheritNamespaces = inherit;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setPreserveNamespaces(boolean inherit) {
        this.preserveNamespaces = inherit;
    }

    public boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void setConstructionMode(int mode) {
        this.constructionMode = mode;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public XQueryExpression compileQuery(String query) throws XPathException {
        QueryParser qp = (QueryParser)this.config.newExpressionParser("XQ", this.isUpdating, this.languageVersion);
        if (this.codeInjector != null) {
            qp.setCodeInjector(this.codeInjector);
        } else if (this.config.isCompileWithTracing()) {
            qp.setCodeInjector(new TraceCodeInjector());
        }
        QueryModule mainModule = new QueryModule(this);
        Executable executable = this.getExecutable();
        mainModule.setExecutable(executable);
        return qp.makeXQueryExpression(query, mainModule, this.config);
    }

    public XQueryExpression compileQuery(Reader source) throws XPathException, IOException {
        int n;
        char[] buffer = new char[4096];
        StringBuffer sb = new StringBuffer(4096);
        while ((n = source.read(buffer)) > 0) {
            sb.append(buffer, 0, n);
        }
        return this.compileQuery(sb.toString());
    }

    public XQueryExpression compileQuery(InputStream source, String encoding) throws XPathException, IOException {
        String query = QueryReader.readInputStream(source, encoding, this.config.getNameChecker());
        return this.compileQuery(query);
    }

    public void compileLibrary(String query) throws XPathException {
        throw new UnsupportedOperationException("Separate compilation of query libraries requires Saxon-EE");
    }

    public void compileLibrary(Reader source) throws XPathException, IOException {
        throw new UnsupportedOperationException("Separate compilation of query libraries requires Saxon-EE");
    }

    public void compileLibrary(InputStream source, String encoding) throws XPathException, IOException {
        throw new UnsupportedOperationException("Separate compilation of query libraries requires Saxon-EE");
    }

    public QueryLibrary getCompiledLibrary(String namespace) {
        return null;
    }

    public void declareNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        if (prefix.equals("xml") != uri.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new IllegalArgumentException("Misdeclaration of XML namespace");
        }
        if (prefix.equals("xmlns") || uri.equals("http://www.w3.org/2000/xmlns/")) {
            throw new IllegalArgumentException("Misdeclaration of xmlns namespace");
        }
        if (prefix.length() == 0) {
            this.defaultElementNamespace = uri;
        }
        if (uri.length() == 0) {
            this.userDeclaredNamespaces.remove(prefix);
        } else {
            this.userDeclaredNamespaces.put(prefix, uri);
        }
    }

    public void declarePassiveNamespace(String prefix, String uri, boolean explicit) throws XPathException {
        if (explicit) {
            throw new IllegalArgumentException("explicit must be false");
        }
        this.declareNamespace(prefix, uri);
    }

    public void clearNamespaces() {
        this.userDeclaredNamespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
        this.declareNamespace("local", "http://www.w3.org/2005/xquery-local-functions");
        this.declareNamespace("err", "http://www.w3.org/2005/xqt-errors");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("", "");
    }

    protected HashMap<String, String> getUserDeclaredNamespaces() {
        return this.userDeclaredNamespaces;
    }

    public void clearPassiveNamespaces() {
        this.clearNamespaces();
    }

    public Iterator<String> iterateDeclaredPrefixes() {
        return this.userDeclaredNamespaces.keySet().iterator();
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.userDeclaredNamespaces.get(prefix);
    }

    public void setExternalNamespaceResolver(NamespaceResolver resolver2) {
        this.externalNamespaceResolver = resolver2;
    }

    public NamespaceResolver getExternalNamespaceResolver() {
        return this.externalNamespaceResolver;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String defaultFunctionNamespace) {
        this.defaultFunctionNamespace = defaultFunctionNamespace;
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
        this.declareNamespace("", uri);
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void declareGlobalVariable(StructuredQName qName, SequenceType type, ValueRepresentation value, boolean external) throws XPathException {
        if (value == null && !external) {
            throw new NullPointerException("No initial value for declared variable");
        }
        Value val = Value.asValue(value);
        if (!type.matches(val, this.getConfiguration())) {
            throw new XPathException("Value of declared variable does not match its type");
        }
        GlobalVariableDefinition var = new GlobalVariableDefinition();
        var.setVariableQName(qName);
        var.setRequiredType(type);
        var.setValueExpression(Literal.makeLiteral(val));
        var.setIsParameter(external);
        if (this.userDeclaredVariables == null) {
            this.userDeclaredVariables = new HashSet();
        }
        this.userDeclaredVariables.add(var);
    }

    public Iterator iterateDeclaredGlobalVariables() {
        if (this.userDeclaredVariables == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.userDeclaredVariables.iterator();
    }

    public void clearDeclaredGlobalVariables() {
        this.userDeclaredVariables = null;
    }

    public void setModuleURIResolver(ModuleURIResolver resolver2) {
        this.moduleURIResolver = resolver2;
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void declareCollation(String name, Comparator comparator) {
        this.declareCollation(name, new SimpleCollation(comparator));
    }

    public void declareCollation(String name, StringCollator comparator) {
        this.collationMap.setNamedCollation(name, comparator);
    }

    public void declareDefaultCollation(String name) {
        this.collationMap.setDefaultCollationName(name);
    }

    public StringCollator getCollation(String name) {
        if (name == null) {
            throw new NullPointerException("collationName");
        }
        return this.collationMap.getNamedCollation(name);
    }

    public CollationMap getCollationMap() {
        return this.collationMap;
    }

    public String getDefaultCollationName() {
        return this.collationMap.getDefaultCollationName();
    }

    public CollationMap getAllCollations() {
        return new CollationMap(this.collationMap);
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setPreserveBoundarySpace(boolean preserve) {
        this.preserveSpace = preserve;
    }

    public boolean isPreserveBoundarySpace() {
        return this.preserveSpace;
    }

    public void setEmptyLeast(boolean least) {
        this.defaultEmptyLeast = least;
    }

    public boolean isEmptyLeast() {
        return this.defaultEmptyLeast;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
        if (this.errorListener instanceof StandardErrorListener) {
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(51);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
    }

    public ErrorListener getErrorListener() {
        if (this.errorListener == null) {
            this.errorListener = this.config.getErrorListener();
        }
        return this.errorListener;
    }

    public void setUpdatingEnabled(boolean updating) {
        this.isUpdating = updating;
    }

    public boolean isUpdatingEnabled() {
        return this.isUpdating;
    }
}

