/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.value.Whitespace;

public abstract class XSLGeneralIncorporate
extends StyleElement {
    private String href;

    public boolean isDeclaration() {
        return true;
    }

    public abstract boolean isImport();

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("href")) {
                this.href = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.validateInstruction();
    }

    public void validateInstruction() throws XPathException {
        this.checkEmpty();
        this.checkTopLevel(this.isImport() ? "XTSE0190" : "XTSE0170");
    }

    public StylesheetModule getIncludedStylesheet(StylesheetModule importer, int precedence) throws XPathException {
        if (this.href == null) {
            return null;
        }
        try {
            StylesheetModule incModule;
            PrincipalStylesheetModule psm = importer.getPrincipalStylesheetModule();
            PreparedStylesheet pss = psm.getPreparedStylesheet();
            URIResolver resolver2 = pss.getCompilerInfo().getURIResolver();
            Configuration config = pss.getConfiguration();
            DocumentURI key = DocumentFn.computeDocumentKey(this.href, this.getBaseURI(), resolver2);
            XSLStylesheet includedSheet = psm.getStylesheetDocument(key);
            if (includedSheet != null) {
                incModule = new StylesheetModule(includedSheet, precedence);
                incModule.setImporter(importer);
            } else {
                DocumentImpl includedDoc;
                ElementImpl outermost;
                Source source;
                String relative = this.href;
                String fragment = null;
                int hash = relative.indexOf(35);
                if (hash == 0 || relative.length() == 0) {
                    this.compileError("A stylesheet cannot " + this.getLocalPart() + " itself", this instanceof XSLInclude ? "XTSE0180" : "XTSE0210");
                    return null;
                }
                if (hash == relative.length() - 1) {
                    relative = relative.substring(0, hash);
                } else if (hash > 0) {
                    if (hash + 1 < relative.length()) {
                        fragment = relative.substring(hash + 1);
                    }
                    relative = relative.substring(0, hash);
                }
                try {
                    source = resolver2.resolve(relative, this.getBaseURI());
                }
                catch (TransformerException e) {
                    throw XPathException.makeXPathException(e);
                }
                if (source == null) {
                    source = config.getSystemURIResolver().resolve(relative, this.getBaseURI());
                }
                if (fragment != null) {
                    final String fragmentFinal = fragment;
                    FilterFactory factory = new FilterFactory(){

                        public ProxyReceiver makeFilter(Receiver next) {
                            return new IDFilter(next, fragmentFinal);
                        }
                    };
                    source = AugmentedSource.makeAugmentedSource(source);
                    ((AugmentedSource)source).addFilter(factory);
                }
                if (source.getSystemId() != null) {
                    for (StylesheetModule anc = importer; anc != null; anc = anc.getImporter()) {
                        if (!DocumentURI.normalizeURI(source.getSystemId()).equals(DocumentURI.normalizeURI(anc.getSourceElement().getSystemId()))) continue;
                        this.compileError("A stylesheet cannot " + this.getLocalPart() + " itself", this instanceof XSLInclude ? "XTSE0180" : "XTSE0210");
                        return null;
                    }
                }
                if ((outermost = (includedDoc = pss.loadStylesheetModule(source)).getDocumentElement()) instanceof LiteralResultElement) {
                    includedDoc = ((LiteralResultElement)outermost).makeStylesheet(this.getPreparedStylesheet());
                    outermost = includedDoc.getDocumentElement();
                }
                if (!(outermost instanceof XSLStylesheet)) {
                    this.compileError("Included document " + this.href + " is not a stylesheet", "XTSE0165");
                    return null;
                }
                includedSheet = (XSLStylesheet)outermost;
                includedSheet.setPrincipalStylesheetModule(psm);
                psm.putStylesheetDocument(key, includedSheet);
                incModule = new StylesheetModule(includedSheet, precedence);
                incModule.setImporter(importer);
                Declaration decl = new Declaration(incModule, includedSheet);
                includedSheet.validate(decl);
                if (includedSheet.validationError != null) {
                    if (this.reportingCircumstances == 1) {
                        includedSheet.compileError(includedSheet.validationError);
                    } else if (includedSheet.reportingCircumstances == 2) {
                        includedSheet.compileError(includedSheet.validationError);
                    }
                }
            }
            incModule.spliceIncludes();
            importer.setInputTypeAnnotations(includedSheet.getInputTypeAnnotationsAttribute() | incModule.getInputTypeAnnotations());
            return incModule;
        }
        catch (XPathException err) {
            err.setErrorCode("XTSE0165");
            err.setIsStaticError(true);
            this.compileError(err);
            return null;
        }
    }

    public void compileDeclaration(Executable exec, Declaration decl) throws XPathException {
    }
}

