/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xsm;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.sqf.stringUtils.TextSource;
import net.sqf.xsm.ManipulatorMain;
import net.sqf.xsm.operations.PositionalReplace;

public class CmdProps {
    private static final File HELP_MENU = new File(ManipulatorMain.baseFolder, "data/config/helpXSM.txt");
    private File sheet = null;
    private File input = null;
    private File output = null;

    public static String getHelpText() throws IOException {
        return TextSource.readTextFile(HELP_MENU).toString();
    }

    public CmdProps(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                if (this.sheet != null) {
                    throw new Exception("Unkown command line parameter \"" + arg + "\"!");
                }
                this.sheet = CmdProps.convertUri(args[i]);
            } else {
                String function = args[i];
                if (function.equals("-i") || function.equals("-input")) {
                    this.input = this.getValue(++i, args);
                } else if (function.equals("-o") || function.equals("-output")) {
                    this.output = this.getValue(++i, args);
                } else if (function.equals("-f")) {
                    PositionalReplace.fastMode = true;
                }
            }
            ++i;
        }
    }

    public static File convertUri(String systemId) {
        try {
            URI uri = new URI(systemId);
            return new File(uri);
        }
        catch (URISyntaxException e) {
            return new File(systemId);
        }
    }

    private File getValue(int i, String[] args) throws Exception {
        if (i >= args.length || args[i].startsWith("-")) {
            throw new Exception("Missing file for command line parameter " + args[i - 1] + "\"!");
        }
        String value = args[i];
        return CmdProps.convertUri(value);
    }

    public boolean isFunctionSetted(char function) {
        switch (function) {
            case 'i': {
                return this.input != null;
            }
            case 'o': {
                return this.output != null;
            }
            case 's': {
                return this.sheet != null;
            }
        }
        return false;
    }

    public File getSheet() {
        return this.sheet;
    }

    public File getInput() {
        return this.input;
    }

    public File getOutput() {
        return this.output;
    }
}

