/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xsm.operations;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import net.sqf.stringUtils.TextSource;
import net.sqf.utils.process.log.DefaultProcessLoger;
import net.sqf.utils.process.log.ProcessLoger;
import net.sqf.xmlUtils.staxParser.PositionalXMLReader;
import net.sqf.xmlUtils.staxParser.StringNode;
import net.sqf.xmlUtils.xpath.XPathReader;
import net.sqf.xmlUtils.xsd.Xerces;
import net.sqf.xsm.CmdProps;
import net.sqf.xsm.operations.DeleteOp;
import net.sqf.xsm.operations.OperationsSet;
import net.sqf.xsm.operations._Operation;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PositionalReplace {
    private StringNode sourceStringNode;
    private StringNode sheetStringNode;
    private static XPathReader xpr = new XPathReader();
    static PositionalXMLReader pxr = new PositionalXMLReader();
    private static File baseFolder = new File(PositionalReplace.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile();
    public static final File XSM_SCHEMA = new File(baseFolder, "xml/schema/XSM/xpath-based-string-manipulator.xsd").getAbsoluteFile();
    private Xerces xerces;
    public static boolean debugMode = false;
    public static boolean fastMode = false;
    private static ProcessLoger logger = new DefaultProcessLoger(){

        @Override
        public void log(String message) {
            if (debugMode) {
                System.out.println(String.valueOf(new Date().toString()) + ": " + message);
            }
        }
    };

    public PositionalReplace(File document, boolean isSheet) throws IOException, SAXException, XPathExpressionException, XMLStreamException {
        logger.log("Parse XSM-Sheet");
        StringNode doc = new StringNode(document, logger);
        logger.log("Finished parsing XSM-Sheet");
        if (isSheet) {
            if (!fastMode && XSM_SCHEMA.exists()) {
                System.out.println(XSM_SCHEMA.toURI().toURL().toString());
                this.xerces = new Xerces("http://www.schematron-quickfix.com/manipulator/process", XSM_SCHEMA);
                this.xerces.validateSource(document);
            }
            File documentAtrFile = CmdProps.convertUri(xpr.getNode("/xsm:manipulator/@document", doc.getDocument()).getNodeValue());
            this.sheetStringNode = doc;
            File sourceFile = documentAtrFile.isAbsolute() ? documentAtrFile : new File(document.getParentFile(), documentAtrFile.getPath());
            logger.log("Parse Instance");
            this.sourceStringNode = new StringNode(sourceFile, logger);
            logger.log("Start operation");
            this.operate();
            logger.log("End operation");
        } else {
            this.sourceStringNode = doc;
        }
    }

    public PositionalReplace(File sheet, File source) throws IOException, SAXException, XPathExpressionException, XMLStreamException {
        if (!fastMode) {
            this.xerces = new Xerces("http://www.schematron-quickfix.com/manipulator/process", XSM_SCHEMA);
            this.xerces.validateSource(sheet);
        }
        this.sheetStringNode = new StringNode(sheet, logger);
        this.sourceStringNode = new StringNode(source, logger);
        this.operate();
    }

    public PositionalReplace(TextSource sheet, TextSource source) throws IOException, SAXException, XMLStreamException, XPathExpressionException {
        if (!fastMode) {
            this.xerces = new Xerces("http://www.schematron-quickfix.com/manipulator/process", XSM_SCHEMA);
        }
        this.sheetStringNode = new StringNode(sheet);
        this.sourceStringNode = new StringNode(source);
        this.operate();
    }

    public PositionalReplace(TextSource source) throws IOException, SAXException, XMLStreamException {
        if (!fastMode) {
            this.xerces = new Xerces("http://www.schematron-quickfix.com/manipulator/process", XSM_SCHEMA);
        }
        this.sourceStringNode = new StringNode(source);
    }

    public void deleteNode(String xpath) throws XPathExpressionException, IOException, SAXException, XMLStreamException {
        NodeList nodes = xpr.getNodeSet(xpath, this.sourceStringNode.getDocument());
        OperationsSet ops = new OperationsSet();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            ops.add(new DeleteOp(node, 0));
            ++i;
        }
        this.operate(ops);
    }

    private void operate() throws XPathExpressionException, IOException, SAXException, XMLStreamException {
        OperationsSet operations = OperationsSet.createOperations(this.sourceStringNode.getDocument(), this.sheetStringNode.getTextSource().toString(), xpr.getNodeSet("/*/*", this.sheetStringNode.getDocument()));
        this.operate(operations);
    }

    private void operate(OperationsSet operations) throws IOException, SAXException, XMLStreamException {
        if (operations.size() > 0) {
            String[] docStrings = new String[operations.size()];
            int marker = 0;
            int idx = 0;
            Iterator iterator = operations.iterator();
            while (iterator.hasNext()) {
                _Operation op = (_Operation)iterator.next();
                docStrings[idx] = String.valueOf(this.sourceStringNode.getTextSource().toString().substring(marker, op.getStart())) + op.getReplace();
                if (!iterator.hasNext()) {
                    docStrings[idx] = String.valueOf(docStrings[idx]) + this.sourceStringNode.getTextSource().toString().substring(op.getEnd());
                } else {
                    marker = op.getEnd();
                }
                ++idx;
            }
            String docString = "";
            int i = 0;
            while (i < docStrings.length) {
                docString = String.valueOf(docString) + docStrings[i];
                ++i;
            }
            this.sourceStringNode.setString(docString, !fastMode);
        }
    }

    public TextSource getSource() {
        return this.sourceStringNode.getTextSource();
    }
}

