/*
 * Decompiled with CFR 0.152.
 */
package org.apache.env;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.env.WhichConstant;
import org.apache.env.WhichFactory;
import org.apache.env.WhichJar;
import org.apache.env.WhichProject;

public class Which {
    public static final String SEPARATOR = ";";
    public static final String DEFAULT_PROJECTS = "XmlCommons;Xerces;Xalan;Crimson;Ant";
    protected StringBuffer optionsBuf = new StringBuffer();
    protected StringBuffer projectsBuf = new StringBuffer();
    protected PrintWriter outWriter = new PrintWriter(System.out, true);

    public static void main(String[] args) {
        Which app = new Which();
        app.doMain(args);
    }

    public void doMain(String[] args) {
        if (!this.parseArgs(args)) {
            this.outWriter.println(this.usage());
            this.outWriter.println("Bad argument or help (?) asked for, aborting");
            return;
        }
        Hashtable hash = new Hashtable();
        int status = Which.which(hash, this.projectsBuf.toString(), this.optionsBuf.toString());
        this.reportProjectsInfo(hash, this.optionsBuf.toString(), status, this.outWriter);
    }

    public static int which(Hashtable hash, String projects, String options) {
        if (hash == null) {
            hash = new Hashtable<String, String>();
        }
        Which.getGeneralInfo(hash, options);
        int status = Which.getProjectsInfo(hash, projects, options);
        hash.put("Which.status", WhichConstant.ITEM_DESC[status]);
        return status;
    }

    public static void getGeneralInfo(Hashtable hash, String options) {
        hash.put("Which.version", Which.getVersion());
        WhichJar.getClasspathInfo(hash, options);
        try {
            hash.put("java.version", System.getProperty("java.version"));
            hash.put("file.encoding", System.getProperty("file.encoding"));
            hash.put("java.vendor", System.getProperty("java.vendor"));
            hash.put("os.name", System.getProperty("os.name"));
        }
        catch (Exception e) {
            hash.put("Which.error", "Accessing System.getProperty(...) threw: " + e.toString());
        }
        try {
            hash.put("java.runtime.name", System.getProperty("java.runtime.name"));
        }
        catch (Exception e) {
            hash.put("Which.error11x", "Accessing System.getProperty(java.runtime.name) threw: " + e.toString());
        }
    }

    public static int getProjectsInfo(Hashtable hash, String projects, String options) {
        if (hash == null) {
            hash = new Hashtable<String, Object>();
        }
        if (projects == null || projects.length() < 1) {
            projects = DEFAULT_PROJECTS;
            hash.put("Which.special-note", "No -projects provided, using DEFAULT_PROJECTS");
        }
        int retVal = 0;
        StringTokenizer st = new StringTokenizer(projects, SEPARATOR);
        while (st.hasMoreTokens()) {
            String projName = st.nextToken();
            try {
                Hashtable<String, String> subHash = new Hashtable<String, String>();
                WhichProject proj = WhichFactory.newWhichProject(projName, options);
                int subStatus = proj.getInfo(subHash, options);
                subHash.put(String.valueOf(projName) + ".status", WhichConstant.ITEM_DESC[subStatus]);
                hash.put(String.valueOf(projName) + ".hashinfo", subHash);
                retVal = Math.max(subStatus, retVal);
            }
            catch (Exception e) {
                hash.put(String.valueOf(projName) + WhichConstant.ITEM_DESC[5], "newWhichProject threw: " + e.toString());
                e.printStackTrace();
                retVal = Math.max(5, retVal);
            }
        }
        return retVal;
    }

    public void reportProjectsInfo(Hashtable hash, String options, int status, PrintWriter out) {
        this.reportHashtable(hash, "Which report", out);
    }

    protected void reportHashtable(Hashtable hash, String name, PrintWriter out) {
        out.println("#---- BEGIN: " + name);
        if (hash == null) {
            return;
        }
        Enumeration<Object> keysEnum = hash.keys();
        Vector<Object> v = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            Object key = keysEnum.nextElement();
            String keyStr = key.toString();
            Object item = hash.get(key);
            if (item instanceof Hashtable) {
                v.addElement(keyStr);
                v.addElement((Hashtable)item);
                continue;
            }
            out.println(String.valueOf(keyStr) + "=" + item);
        }
        keysEnum = v.elements();
        while (keysEnum.hasMoreElements()) {
            String n = (String)keysEnum.nextElement();
            Hashtable h = (Hashtable)keysEnum.nextElement();
            this.reportHashtable(h, n, out);
        }
        out.println("#----   END: " + name);
    }

    protected String usage() {
        return "Which: find classes and jars in your environment\nusage: java org.apache.env.Which [-options] [project;org.MyWhichProject]\n";
    }

    protected boolean parseArgs(String[] args) {
        String OPTION_PREFIX = "-";
        String OPTION_HELP = "?";
        int numArgs = args.length;
        int k = 0;
        while (k < numArgs) {
            if (args[k].indexOf("?") > -1) {
                return false;
            }
            if (args[k].startsWith("-")) {
                this.optionsBuf.append(args[k]);
                this.optionsBuf.append(SEPARATOR);
            } else {
                this.projectsBuf.append(args[k]);
                this.projectsBuf.append(SEPARATOR);
            }
            ++k;
        }
        return true;
    }

    public static String getVersion() {
        return "Which.java:($Revision: 226174 $) " + WhichJar.getVersion();
    }
}

