/*
 * Decompiled with CFR 0.152.
 */
package org.apache.env;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.env.WhichClass;
import org.apache.env.WhichJar;
import org.apache.env.WhichProject;

public abstract class WhichFactory {
    public static final String DEFAULT_WHICHCLASS = "org.apache.env.Which";
    public static final String SERVICE_NAME = "WhichFactory";
    private static final String WHICHFACTORY_PROPS = "org/apache/env/WhichFactory.properties";
    protected static Properties installedWhichers = new Properties();

    static {
        WhichFactory.loadWhichInstall(installedWhichers, WHICHFACTORY_PROPS);
    }

    public static WhichProject newWhichProject(String name, String options) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz;
        try {
            clazz = WhichClass.findClass(name, options);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                String implName = installedWhichers.getProperty(name);
                if (implName == null) {
                    throw new ClassNotFoundException();
                }
                clazz = WhichClass.findClass(implName, options);
            }
            catch (ClassNotFoundException cnfe2) {
                clazz = WhichClass.findClass(DEFAULT_WHICHCLASS + name, options);
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return (WhichProject)clazz.newInstance();
    }

    private static void loadWhichInstall(Properties table, String tableURL) {
        if (table == null) {
            table = new Properties();
        }
        try {
            InputStream is = null;
            try {
                Class[] NO_CLASSES = new Class[]{};
                Object[] NO_OBJS = new Object[]{};
                Method getCCL = Thread.class.getMethod("getContextClassLoader", NO_CLASSES);
                if (getCCL != null) {
                    ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), NO_OBJS);
                    is = contextClassLoader.getResourceAsStream(tableURL);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (is == null) {
                is = WhichJar.class.getResourceAsStream("/" + tableURL);
            }
            table.load(is);
            is.close();
        }
        catch (Exception e) {
            System.err.println("WhichFactory loadJarTable threw: " + e.toString());
            e.printStackTrace();
        }
    }
}

