/*
 * Decompiled with CFR 0.152.
 */
package org.apache.env;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.env.WhichConstant;

public abstract class WhichJar {
    public static final String SERVICE_NAME = "WhichJar";
    private static final String WHICHJAR_PROPS = "org/apache/env/WhichJar.properties";
    protected static Properties jarSizeTable = new Properties();

    static {
        WhichJar.loadJarTable(jarSizeTable, WHICHJAR_PROPS);
    }

    public static void getClasspathInfo(Hashtable hash, String options) {
        WhichJar.logProperty(hash, "java.class.path");
        WhichJar.logProperty(hash, "sun.boot.class.path");
        WhichJar.logProperty(hash, "java.ext.dirs");
    }

    private static void logProperty(Hashtable hash, String propertyName) {
        try {
            hash.put(propertyName, System.getProperty(propertyName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int searchClasspaths(Hashtable hash, String jarName, String options) {
        int retVal1 = WhichJar.searchPath(hash, "java.class.path", jarName, options);
        int retVal2 = WhichJar.searchPath(hash, "sun.boot.class.path", jarName, options);
        int retVal3 = WhichJar.searchDirs(hash, "java.ext.dirs", jarName, options);
        if (WhichConstant.isStrict(options)) {
            return Math.max(retVal1, Math.max(retVal2, retVal3));
        }
        return 2;
    }

    public static int searchPath(Hashtable hash, String pathName, String jarName, String options) {
        String path = System.getProperty(pathName);
        if (path == null) {
            hash.put(String.valueOf(jarName) + WhichConstant.ITEM_DESC[4], "searchPath [" + pathName + "] not found!");
            return WhichConstant.isStrict(options) ? 4 : 3;
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        int retVal = 0;
        boolean jarFound = false;
        while (st.hasMoreTokens()) {
            String jarURI = st.nextToken();
            if (jarURI.indexOf(jarName) <= -1) continue;
            File jarFile = new File(jarURI);
            if (jarFile.exists()) {
                if (jarFound) {
                    Hashtable<String, String> h = new Hashtable<String, String>();
                    int multipleStatus = WhichConstant.isStrict(options) ? 5 : 0;
                    h.put(String.valueOf(jarName) + WhichConstant.ITEM_DESC[multipleStatus], "jar on classpath multiple times!");
                    retVal = Math.max(retVal, WhichJar.getInfo(h, jarFile, options));
                    retVal = Math.max(retVal, multipleStatus);
                    hash.put(String.valueOf(pathName) + "." + jarName + ".hashinfo", h);
                    continue;
                }
                retVal = Math.max(retVal, WhichJar.getInfo(hash, jarFile, options));
                jarFound = true;
                continue;
            }
            hash.put(String.valueOf(jarName) + WhichConstant.ITEM_DESC[4], "classpath entry [" + jarURI + "] does not exist on disk!");
            retVal = Math.max(retVal, WhichConstant.isStrict(options) ? 4 : 3);
        }
        return retVal;
    }

    public static int searchDirs(Hashtable hash, String pathName, String jarName, String options) {
        String path = System.getProperty(pathName);
        if (path == null) {
            hash.put(String.valueOf(jarName) + WhichConstant.ITEM_DESC[4], " searchDirs [" + pathName + "] not found!");
            return WhichConstant.isStrict(options) ? 4 : 3;
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        int retVal = 0;
        while (st.hasMoreTokens()) {
            String dir = st.nextToken();
            retVal = Math.max(retVal, WhichJar.searchDir(hash, dir, jarName, options));
        }
        return retVal;
    }

    public static int searchDir(Hashtable hash, String dir, String jarName, String options) {
        File searchDir = new File(dir);
        if (!searchDir.exists()) {
            int retVal = WhichConstant.isStrict(options) ? 5 : 0;
            hash.put("WhichJarsearchDir" + WhichConstant.ITEM_DESC[retVal], "searchDir does not exist: " + dir);
            return retVal;
        }
        File jarFile = new File(searchDir, jarName);
        return WhichJar.getInfo(hash, jarFile, options);
    }

    public static int getInfo(Hashtable hash, File jarFile, String options) {
        if (hash == null) {
            hash = new Hashtable<String, String>();
        }
        if (jarFile == null) {
            hash.put(SERVICE_NAME + WhichConstant.ITEM_DESC[5], "getInfo() called on null jarFile");
            return 5;
        }
        String jarName = jarFile.getName();
        if (jarFile.exists()) {
            String tmpInfo;
            block6: {
                try {
                    hash.put(String.valueOf(jarName) + ".path", jarFile.getAbsolutePath());
                    tmpInfo = WhichJar.getJarInfo(jarName, jarFile.length());
                    if (tmpInfo != null) break block6;
                    hash.put(String.valueOf(jarName) + WhichConstant.ITEM_DESC[2], "not from an official release, size:" + jarFile.length());
                    return 2;
                }
                catch (Exception e) {
                    hash.put(String.valueOf(jarName) + WhichConstant.ITEM_DESC[5], String.valueOf(jarFile.getAbsolutePath()) + " threw: " + e.toString());
                    return 5;
                }
            }
            hash.put(String.valueOf(jarName) + WhichConstant.ITEM_DESC[1], tmpInfo);
            return 1;
        }
        int retVal = WhichConstant.isStrict(options) ? 5 : 0;
        hash.put(String.valueOf(jarName) + WhichConstant.ITEM_DESC[retVal], String.valueOf(jarFile.getAbsolutePath()) + " does not exist");
        return retVal;
    }

    private static String getJarInfo(String jarName, long jarSize) {
        if (jarSizeTable == null) {
            return null;
        }
        String SIZE_SEPARATOR = ".";
        return jarSizeTable.getProperty(String.valueOf(String.valueOf(jarSize)) + "." + jarName);
    }

    private static String getFilename(String URI2) {
        if (URI2 == null) {
            return null;
        }
        String URL_SEPARATOR = "/";
        return URI2.substring(URI2.lastIndexOf("/"));
    }

    private static void loadJarTable(Properties table, String tableURL) {
        if (table == null) {
            table = new Properties();
        }
        try {
            InputStream is = null;
            try {
                Class[] NO_CLASSES = new Class[]{};
                Object[] NO_OBJS = new Object[]{};
                Method getCCL = Thread.class.getMethod("getContextClassLoader", NO_CLASSES);
                if (getCCL != null) {
                    ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), NO_OBJS);
                    is = contextClassLoader.getResourceAsStream(tableURL);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (is == null) {
                is = WhichJar.class.getResourceAsStream("/" + tableURL);
            }
            table.load(is);
            is.close();
        }
        catch (Exception e) {
            System.err.println("WhichJar loadJarTable threw: " + e.toString());
            e.printStackTrace();
        }
    }

    public static String getVersion() {
        return "WhichJar.java:($Revision: 225992 $)";
    }
}

