/*
 * Decompiled with CFR 0.152.
 */
package org.apache.env;

import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.env.WhichClass;
import org.apache.env.WhichConstant;
import org.apache.env.WhichJar;
import org.apache.env.WhichProject;

public class WhichXmlCommons
implements WhichProject {
    public static final String SERVICE_NAME = "XmlCommons";
    private static final String XMLCOMMONS_JARNAME = "xml-apis.jar";
    private static final String XMLCOMMONS_VERSION_CLASS = "org.apache.xmlcommons.Version";
    private static final String XMLCOMMONS_VERSION_METHOD = "getVersion";

    @Override
    public int getInfo(Hashtable hash, String options) {
        if (hash == null) {
            hash = new Hashtable();
        }
        int status = this.getXmlCommonsInfo(hash, options);
        status = Math.max(status, this.getJAXPInfo(hash, options));
        status = Math.max(status, this.getSAXInfo(hash, options));
        status = Math.max(status, this.getDOMInfo(hash, options));
        return status;
    }

    public int getXmlCommonsInfo(Hashtable hash, String options) {
        int status = 0;
        try {
            Class[] noArgs = new Class[]{};
            Class clazz = WhichClass.findClass(XMLCOMMONS_VERSION_CLASS, options);
            Method method = clazz.getMethod(XMLCOMMONS_VERSION_METHOD, noArgs);
            Object returnValue = method.invoke(null, new Object[0]);
            hash.put("XmlCommons.version", (String)returnValue);
            status = 2;
        }
        catch (Exception e) {
            hash.put("XmlCommons.version", WhichConstant.ITEM_DESC[3]);
            status = 3;
        }
        int jarStatus = WhichJar.searchClasspaths(hash, XMLCOMMONS_JARNAME, options);
        return Math.max(jarStatus, status);
    }

    public int getJAXPInfo(Hashtable hash, String options) {
        String INFONAME = "XmlCommons.jaxp";
        int status = 0;
        Class jaxpClazz = null;
        try {
            Class[] noArgs = new Class[]{};
            jaxpClazz = WhichClass.findClass("javax.xml.parsers.DocumentBuilder", options);
            Method method = jaxpClazz.getMethod("getDOMImplementation", noArgs);
            hash.put("XmlCommons.jaxp.version", "1.1");
            status = 1;
        }
        catch (Exception e) {
            if (jaxpClazz != null) {
                hash.put("XmlCommons.jaxp.version", "apparently-JAXP-1.0.1" + WhichConstant.ITEM_DESC[5]);
                status = 5;
            }
            hash.put("XmlCommons.jaxp.version", "JAXP-nowhere" + WhichConstant.ITEM_DESC[5]);
            status = 5;
        }
        int ignored = WhichJar.searchClasspaths(hash, "jaxp.jar", options);
        ignored = WhichJar.searchClasspaths(hash, "dom.jar", options);
        ignored = WhichJar.searchClasspaths(hash, "sax.jar", options);
        ignored = WhichJar.searchClasspaths(hash, "jaxp-api.jar", options);
        return status;
    }

    public int getSAXInfo(Hashtable hash, String options) {
        String INFONAME = "XmlCommons.sax";
        int status = 0;
        Class saxClazz = null;
        String SAX_VERSION1_CLASS = "org.xml.sax.Parser";
        String SAX_VERSION1_METHOD = "parse";
        String SAX_VERSION2BETA_CLASS = "org.xml.sax.XMLReader";
        String SAX_VERSION2BETA_METHOD = "parse";
        String SAX_VERSION2_CLASS = "org.xml.sax.helpers.AttributesImpl";
        String SAX_VERSION2_METHOD = "setAttributes";
        Class[] oneStringArg = new Class[]{String.class};
        try {
            Class[] attributesArg = new Class[]{WhichClass.findClass("org.xml.sax.Attributes", options)};
            saxClazz = WhichClass.findClass("org.xml.sax.helpers.AttributesImpl", options);
            Method method = saxClazz.getMethod("setAttributes", attributesArg);
            hash.put("XmlCommons.sax.version", "2.0");
            status = 1;
        }
        catch (Exception e) {
            try {
                saxClazz = WhichClass.findClass("org.xml.sax.XMLReader", options);
                Method method = saxClazz.getMethod("parse", oneStringArg);
                hash.put("XmlCommons.sax.version", "2.0beta2" + WhichConstant.ITEM_DESC[4]);
                status = 2;
            }
            catch (Exception e2) {
                try {
                    saxClazz = WhichClass.findClass("org.xml.sax.Parser", options);
                    Method method = saxClazz.getMethod("parse", oneStringArg);
                    hash.put("XmlCommons.sax.version", "1.x" + WhichConstant.ITEM_DESC[5]);
                    status = 5;
                }
                catch (Exception e3) {
                    hash.put("XmlCommons.sax.version", String.valueOf(WhichConstant.ITEM_DESC[3]) + WhichConstant.ITEM_DESC[5]);
                    status = 5;
                }
            }
        }
        int ignored = WhichJar.searchClasspaths(hash, "sax.jar", options);
        return status;
    }

    public int getDOMInfo(Hashtable hash, String options) {
        String INFONAME = "XmlCommons.dom";
        int status = 0;
        Class domClazz = null;
        String DOM_LEVEL2_CLASS = "org.w3c.dom.Document";
        String DOM_LEVEL2_METHOD = "createElementNS";
        String DOM_LEVEL2WD_CLASS = "org.w3c.dom.Node";
        String DOM_LEVEL2WD_METHOD = "supported";
        String DOM_LEVEL2FD_CLASS = "org.w3c.dom.Node";
        String DOM_LEVEL2FD_METHOD = "isSupported";
        Class[] twoStringArgs = new Class[]{String.class, String.class};
        try {
            domClazz = WhichClass.findClass("org.w3c.dom.Document", options);
            Method method = domClazz.getMethod("createElementNS", twoStringArgs);
            hash.put("XmlCommons.dom.version", "2.0");
            status = 1;
        }
        catch (Exception e) {
            try {
                domClazz = WhichClass.findClass("org.w3c.dom.Node", options);
                Method method = domClazz.getMethod("supported", twoStringArgs);
                hash.put("XmlCommons.dom.version", "2.0wd" + WhichConstant.ITEM_DESC[5]);
                status = 5;
            }
            catch (Exception e2) {
                try {
                    domClazz = WhichClass.findClass("org.w3c.dom.Node", options);
                    Method method = domClazz.getMethod("isSupported", twoStringArgs);
                    hash.put("XmlCommons.dom.version", "2.0fd" + WhichConstant.ITEM_DESC[5]);
                    status = 5;
                }
                catch (Exception e3) {
                    hash.put("XmlCommons.dom.version", String.valueOf(WhichConstant.ITEM_DESC[3]) + WhichConstant.ITEM_DESC[5]);
                    status = 5;
                }
            }
        }
        int ignored = WhichJar.searchClasspaths(hash, "dom.jar", options);
        return status;
    }
}

