/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.lang.ref.SoftReference;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DOMOutputImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ObjectFactory;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.dtd.XMLDTDLoader;
import org.apache.xerces.parsers.DOMParserImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.DOMSerializerImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class CoreDOMImplementationImpl
implements DOMImplementation,
DOMImplementationLS {
    private static final int SIZE = 2;
    private SoftReference[] schemaValidators = new SoftReference[2];
    private SoftReference[] xml10DTDValidators = new SoftReference[2];
    private SoftReference[] xml11DTDValidators = new SoftReference[2];
    private int freeSchemaValidatorIndex = -1;
    private int freeXML10DTDValidatorIndex = -1;
    private int freeXML11DTDValidatorIndex = -1;
    private int schemaValidatorsCurrentSize = 2;
    private int xml10DTDValidatorsCurrentSize = 2;
    private int xml11DTDValidatorsCurrentSize = 2;
    private SoftReference[] xml10DTDLoaders = new SoftReference[2];
    private SoftReference[] xml11DTDLoaders = new SoftReference[2];
    private int freeXML10DTDLoaderIndex = -1;
    private int freeXML11DTDLoaderIndex = -1;
    private int xml10DTDLoaderCurrentSize = 2;
    private int xml11DTDLoaderCurrentSize = 2;
    private int docAndDoctypeCounter = 0;
    static final CoreDOMImplementationImpl singleton = new CoreDOMImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasFeature(String feature, String version) {
        boolean anyVersion;
        boolean bl = anyVersion = version == null || version.length() == 0;
        if (feature.equalsIgnoreCase("+XPath") && (anyVersion || version.equals("3.0"))) {
            try {
                Class xpathClass = ObjectFactory.findProviderClass("org.apache.xpath.domapi.XPathEvaluatorImpl", ObjectFactory.findClassLoader(), true);
                Class<?>[] interfaces = xpathClass.getInterfaces();
                int i = 0;
                while (true) {
                    if (i >= interfaces.length) {
                        return true;
                    }
                    if (interfaces[i].getName().equals("org.w3c.dom.xpath.XPathEvaluator")) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        if (feature.startsWith("+")) {
            feature = feature.substring(1);
        }
        if (feature.equalsIgnoreCase("Core")) {
            if (anyVersion) return true;
            if (version.equals("1.0")) return true;
            if (version.equals("2.0")) return true;
            if (version.equals("3.0")) return true;
        }
        if (feature.equalsIgnoreCase("XML")) {
            if (anyVersion) return true;
            if (version.equals("1.0")) return true;
            if (version.equals("2.0")) return true;
            if (version.equals("3.0")) return true;
        }
        if (feature.equalsIgnoreCase("XMLVersion")) {
            if (anyVersion) return true;
            if (version.equals("1.0")) return true;
            if (version.equals("1.1")) return true;
        }
        if (feature.equalsIgnoreCase("LS")) {
            if (anyVersion) return true;
            if (version.equals("3.0")) return true;
        }
        if (!feature.equalsIgnoreCase("ElementTraversal")) return false;
        if (anyVersion) return true;
        if (version.equals("1.0")) return true;
        return false;
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicID, String systemID) {
        this.checkQName(qualifiedName);
        return new DocumentTypeImpl(null, qualifiedName, publicID, systemID);
    }

    final void checkQName(String qname) {
        int i;
        int index = qname.indexOf(58);
        int lastIndex = qname.lastIndexOf(58);
        int length = qname.length();
        if (index == 0 || index == length - 1 || lastIndex != index) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, msg);
        }
        int start = 0;
        if (index > 0) {
            if (!XMLChar.isNCNameStart(qname.charAt(start))) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, msg);
            }
            i = 1;
            while (i < index) {
                if (!XMLChar.isNCName(qname.charAt(i))) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                    throw new DOMException(5, msg);
                }
                ++i;
            }
            start = index + 1;
        }
        if (!XMLChar.isNCNameStart(qname.charAt(start))) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, msg);
        }
        i = start + 1;
        while (i < length) {
            if (!XMLChar.isNCName(qname.charAt(i))) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, msg);
            }
            ++i;
        }
    }

    @Override
    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        if (doctype != null && doctype.getOwnerDocument() != null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        CoreDocumentImpl doc = this.createDocument(doctype);
        if (qualifiedName != null || namespaceURI != null) {
            Element e = doc.createElementNS(namespaceURI, qualifiedName);
            doc.appendChild(e);
        }
        return doc;
    }

    protected CoreDocumentImpl createDocument(DocumentType doctype) {
        return new CoreDocumentImpl(doctype);
    }

    @Override
    public Object getFeature(String feature, String version) {
        if (singleton.hasFeature(feature, version)) {
            if (feature.equalsIgnoreCase("+XPath")) {
                try {
                    Class xpathClass = ObjectFactory.findProviderClass("org.apache.xpath.domapi.XPathEvaluatorImpl", ObjectFactory.findClassLoader(), true);
                    Class<?>[] interfaces = xpathClass.getInterfaces();
                    int i = 0;
                    while (i < interfaces.length) {
                        if (interfaces[i].getName().equals("org.w3c.dom.xpath.XPathEvaluator")) {
                            return xpathClass.newInstance();
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    return null;
                }
            } else {
                return singleton;
            }
        }
        return null;
    }

    @Override
    public LSParser createLSParser(short mode, String schemaType) throws DOMException {
        if (mode != 1 || schemaType != null && !"http://www.w3.org/2001/XMLSchema".equals(schemaType) && !"http://www.w3.org/TR/REC-xml".equals(schemaType)) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, msg);
        }
        if (schemaType != null && schemaType.equals("http://www.w3.org/TR/REC-xml")) {
            return new DOMParserImpl("org.apache.xerces.parsers.DTDConfiguration", schemaType);
        }
        return new DOMParserImpl("org.apache.xerces.parsers.XIncludeAwareParserConfiguration", schemaType);
    }

    @Override
    public LSSerializer createLSSerializer() {
        try {
            Class serializerClass = ObjectFactory.findProviderClass("org.apache.xml.serializer.dom3.LSSerializerImpl", ObjectFactory.findClassLoader(), true);
            return (LSSerializer)serializerClass.newInstance();
        }
        catch (Exception exception) {
            return new DOMSerializerImpl();
        }
    }

    @Override
    public LSInput createLSInput() {
        return new DOMInputImpl();
    }

    /*
     * Unable to fully structure code
     */
    synchronized RevalidationHandler getValidator(String schemaType, String xmlVersion) {
        block7: {
            if (schemaType == "http://www.w3.org/2001/XMLSchema") {
                while (this.freeSchemaValidatorIndex >= 0) {
                    ref = this.schemaValidators[this.freeSchemaValidatorIndex];
                    holder = (RevalidationHandlerHolder)ref.get();
                    if (holder != null && holder.handler != null) {
                        val = holder.handler;
                        holder.handler = null;
                        --this.freeSchemaValidatorIndex;
                        return val;
                    }
                    this.schemaValidators[this.freeSchemaValidatorIndex--] = null;
                }
                return (RevalidationHandler)ObjectFactory.newInstance("org.apache.xerces.impl.xs.XMLSchemaValidator", ObjectFactory.findClassLoader(), true);
            }
            if (schemaType != "http://www.w3.org/TR/REC-xml") break block7;
            if (!"1.1".equals(xmlVersion)) ** GOTO lbl34
            while (this.freeXML11DTDValidatorIndex >= 0) {
                ref = this.xml11DTDValidators[this.freeXML11DTDValidatorIndex];
                holder = (RevalidationHandlerHolder)ref.get();
                if (holder != null && holder.handler != null) {
                    val = holder.handler;
                    holder.handler = null;
                    --this.freeXML11DTDValidatorIndex;
                    return val;
                }
                this.xml11DTDValidators[this.freeXML11DTDValidatorIndex--] = null;
            }
            return (RevalidationHandler)ObjectFactory.newInstance("org.apache.xerces.impl.dtd.XML11DTDValidator", ObjectFactory.findClassLoader(), true);
lbl-1000:
            // 1 sources

            {
                ref = this.xml10DTDValidators[this.freeXML10DTDValidatorIndex];
                holder = (RevalidationHandlerHolder)ref.get();
                if (holder != null && holder.handler != null) {
                    val = holder.handler;
                    holder.handler = null;
                    --this.freeXML10DTDValidatorIndex;
                    return val;
                }
                this.xml10DTDValidators[this.freeXML10DTDValidatorIndex--] = null;
lbl34:
                // 2 sources

                ** while (this.freeXML10DTDValidatorIndex >= 0)
            }
lbl35:
            // 1 sources

            return (RevalidationHandler)ObjectFactory.newInstance("org.apache.xerces.impl.dtd.XMLDTDValidator", ObjectFactory.findClassLoader(), true);
        }
        return null;
    }

    synchronized void releaseValidator(String schemaType, String xmlVersion, RevalidationHandler validator) {
        if (schemaType == "http://www.w3.org/2001/XMLSchema") {
            RevalidationHandlerHolder holder;
            SoftReference ref;
            ++this.freeSchemaValidatorIndex;
            if (this.schemaValidators.length == this.freeSchemaValidatorIndex) {
                this.schemaValidatorsCurrentSize += 2;
                SoftReference[] newarray = new SoftReference[this.schemaValidatorsCurrentSize];
                System.arraycopy(this.schemaValidators, 0, newarray, 0, this.schemaValidators.length);
                this.schemaValidators = newarray;
            }
            if ((ref = this.schemaValidators[this.freeSchemaValidatorIndex]) != null && (holder = (RevalidationHandlerHolder)ref.get()) != null) {
                holder.handler = validator;
                return;
            }
            this.schemaValidators[this.freeSchemaValidatorIndex] = new SoftReference<RevalidationHandlerHolder>(new RevalidationHandlerHolder(validator));
        } else if (schemaType == "http://www.w3.org/TR/REC-xml") {
            if ("1.1".equals(xmlVersion)) {
                RevalidationHandlerHolder holder;
                SoftReference ref;
                ++this.freeXML11DTDValidatorIndex;
                if (this.xml11DTDValidators.length == this.freeXML11DTDValidatorIndex) {
                    this.xml11DTDValidatorsCurrentSize += 2;
                    SoftReference[] newarray = new SoftReference[this.xml11DTDValidatorsCurrentSize];
                    System.arraycopy(this.xml11DTDValidators, 0, newarray, 0, this.xml11DTDValidators.length);
                    this.xml11DTDValidators = newarray;
                }
                if ((ref = this.xml11DTDValidators[this.freeXML11DTDValidatorIndex]) != null && (holder = (RevalidationHandlerHolder)ref.get()) != null) {
                    holder.handler = validator;
                    return;
                }
                this.xml11DTDValidators[this.freeXML11DTDValidatorIndex] = new SoftReference<RevalidationHandlerHolder>(new RevalidationHandlerHolder(validator));
            } else {
                RevalidationHandlerHolder holder;
                SoftReference ref;
                ++this.freeXML10DTDValidatorIndex;
                if (this.xml10DTDValidators.length == this.freeXML10DTDValidatorIndex) {
                    this.xml10DTDValidatorsCurrentSize += 2;
                    SoftReference[] newarray = new SoftReference[this.xml10DTDValidatorsCurrentSize];
                    System.arraycopy(this.xml10DTDValidators, 0, newarray, 0, this.xml10DTDValidators.length);
                    this.xml10DTDValidators = newarray;
                }
                if ((ref = this.xml10DTDValidators[this.freeXML10DTDValidatorIndex]) != null && (holder = (RevalidationHandlerHolder)ref.get()) != null) {
                    holder.handler = validator;
                    return;
                }
                this.xml10DTDValidators[this.freeXML10DTDValidatorIndex] = new SoftReference<RevalidationHandlerHolder>(new RevalidationHandlerHolder(validator));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    final synchronized XMLDTDLoader getDTDLoader(String xmlVersion) {
        if (!"1.1".equals(xmlVersion)) ** GOTO lbl21
        while (this.freeXML11DTDLoaderIndex >= 0) {
            ref = this.xml11DTDLoaders[this.freeXML11DTDLoaderIndex];
            holder = (XMLDTDLoaderHolder)ref.get();
            if (holder != null && holder.loader != null) {
                val = holder.loader;
                holder.loader = null;
                --this.freeXML11DTDLoaderIndex;
                return val;
            }
            this.xml11DTDLoaders[this.freeXML11DTDLoaderIndex--] = null;
        }
        return (XMLDTDLoader)ObjectFactory.newInstance("org.apache.xerces.impl.dtd.XML11DTDProcessor", ObjectFactory.findClassLoader(), true);
lbl-1000:
        // 1 sources

        {
            ref = this.xml10DTDLoaders[this.freeXML10DTDLoaderIndex];
            holder = (XMLDTDLoaderHolder)ref.get();
            if (holder != null && holder.loader != null) {
                val = holder.loader;
                holder.loader = null;
                --this.freeXML10DTDLoaderIndex;
                return val;
            }
            this.xml10DTDLoaders[this.freeXML10DTDLoaderIndex--] = null;
lbl21:
            // 2 sources

            ** while (this.freeXML10DTDLoaderIndex >= 0)
        }
lbl22:
        // 1 sources

        return new XMLDTDLoader();
    }

    final synchronized void releaseDTDLoader(String xmlVersion, XMLDTDLoader loader) {
        if ("1.1".equals(xmlVersion)) {
            XMLDTDLoaderHolder holder;
            SoftReference ref;
            ++this.freeXML11DTDLoaderIndex;
            if (this.xml11DTDLoaders.length == this.freeXML11DTDLoaderIndex) {
                this.xml11DTDLoaderCurrentSize += 2;
                SoftReference[] newarray = new SoftReference[this.xml11DTDLoaderCurrentSize];
                System.arraycopy(this.xml11DTDLoaders, 0, newarray, 0, this.xml11DTDLoaders.length);
                this.xml11DTDLoaders = newarray;
            }
            if ((ref = this.xml11DTDLoaders[this.freeXML11DTDLoaderIndex]) != null && (holder = (XMLDTDLoaderHolder)ref.get()) != null) {
                holder.loader = loader;
                return;
            }
            this.xml11DTDLoaders[this.freeXML11DTDLoaderIndex] = new SoftReference<XMLDTDLoaderHolder>(new XMLDTDLoaderHolder(loader));
        } else {
            XMLDTDLoaderHolder holder;
            SoftReference ref;
            ++this.freeXML10DTDLoaderIndex;
            if (this.xml10DTDLoaders.length == this.freeXML10DTDLoaderIndex) {
                this.xml10DTDLoaderCurrentSize += 2;
                SoftReference[] newarray = new SoftReference[this.xml10DTDLoaderCurrentSize];
                System.arraycopy(this.xml10DTDLoaders, 0, newarray, 0, this.xml10DTDLoaders.length);
                this.xml10DTDLoaders = newarray;
            }
            if ((ref = this.xml10DTDLoaders[this.freeXML10DTDLoaderIndex]) != null && (holder = (XMLDTDLoaderHolder)ref.get()) != null) {
                holder.loader = loader;
                return;
            }
            this.xml10DTDLoaders[this.freeXML10DTDLoaderIndex] = new SoftReference<XMLDTDLoaderHolder>(new XMLDTDLoaderHolder(loader));
        }
    }

    protected synchronized int assignDocumentNumber() {
        return ++this.docAndDoctypeCounter;
    }

    protected synchronized int assignDocTypeNumber() {
        return ++this.docAndDoctypeCounter;
    }

    @Override
    public LSOutput createLSOutput() {
        return new DOMOutputImpl();
    }

    static final class RevalidationHandlerHolder {
        RevalidationHandler handler;

        RevalidationHandlerHolder(RevalidationHandler handler) {
            this.handler = handler;
        }
    }

    static final class XMLDTDLoaderHolder {
        XMLDTDLoader loader;

        XMLDTDLoaderHolder(XMLDTDLoader loader) {
            this.loader = loader;
        }
    }
}

