/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.dom.DOMMessageFormatter;

public final class HTMLdtd {
    public static final String HTMLPublicId = "-//W3C//DTD HTML 4.01//EN";
    public static final String HTMLSystemId = "http://www.w3.org/TR/html4/strict.dtd";
    public static final String XHTMLPublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
    public static final String XHTMLSystemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
    private static Hashtable _byChar;
    private static Hashtable _byName;
    private static Hashtable _boolAttrs;
    private static Hashtable _elemDefs;
    private static final String ENTITIES_RESOURCE = "HTMLEntities.res";
    private static final int ONLY_OPENING = 1;
    private static final int ELEM_CONTENT = 2;
    private static final int PRESERVE = 4;
    private static final int OPT_CLOSING = 8;
    private static final int EMPTY = 17;
    private static final int ALLOWED_HEAD = 32;
    private static final int CLOSE_P = 64;
    private static final int CLOSE_DD_DT = 128;
    private static final int CLOSE_SELF = 256;
    private static final int CLOSE_TABLE = 512;
    private static final int CLOSE_TH_TD = 16384;

    static {
        _elemDefs = new Hashtable();
        HTMLdtd.defineElement("ADDRESS", 64);
        HTMLdtd.defineElement("AREA", 17);
        HTMLdtd.defineElement("BASE", 49);
        HTMLdtd.defineElement("BASEFONT", 17);
        HTMLdtd.defineElement("BLOCKQUOTE", 64);
        HTMLdtd.defineElement("BODY", 8);
        HTMLdtd.defineElement("BR", 17);
        HTMLdtd.defineElement("COL", 17);
        HTMLdtd.defineElement("COLGROUP", 522);
        HTMLdtd.defineElement("DD", 137);
        HTMLdtd.defineElement("DIV", 64);
        HTMLdtd.defineElement("DL", 66);
        HTMLdtd.defineElement("DT", 137);
        HTMLdtd.defineElement("FIELDSET", 64);
        HTMLdtd.defineElement("FORM", 64);
        HTMLdtd.defineElement("FRAME", 25);
        HTMLdtd.defineElement("H1", 64);
        HTMLdtd.defineElement("H2", 64);
        HTMLdtd.defineElement("H3", 64);
        HTMLdtd.defineElement("H4", 64);
        HTMLdtd.defineElement("H5", 64);
        HTMLdtd.defineElement("H6", 64);
        HTMLdtd.defineElement("HEAD", 10);
        HTMLdtd.defineElement("HR", 81);
        HTMLdtd.defineElement("HTML", 10);
        HTMLdtd.defineElement("IMG", 17);
        HTMLdtd.defineElement("INPUT", 17);
        HTMLdtd.defineElement("ISINDEX", 49);
        HTMLdtd.defineElement("LI", 265);
        HTMLdtd.defineElement("LINK", 49);
        HTMLdtd.defineElement("MAP", 32);
        HTMLdtd.defineElement("META", 49);
        HTMLdtd.defineElement("OL", 66);
        HTMLdtd.defineElement("OPTGROUP", 2);
        HTMLdtd.defineElement("OPTION", 265);
        HTMLdtd.defineElement("P", 328);
        HTMLdtd.defineElement("PARAM", 17);
        HTMLdtd.defineElement("PRE", 68);
        HTMLdtd.defineElement("SCRIPT", 36);
        HTMLdtd.defineElement("NOSCRIPT", 36);
        HTMLdtd.defineElement("SELECT", 2);
        HTMLdtd.defineElement("STYLE", 36);
        HTMLdtd.defineElement("TABLE", 66);
        HTMLdtd.defineElement("TBODY", 522);
        HTMLdtd.defineElement("TD", 16392);
        HTMLdtd.defineElement("TEXTAREA", 4);
        HTMLdtd.defineElement("TFOOT", 522);
        HTMLdtd.defineElement("TH", 16392);
        HTMLdtd.defineElement("THEAD", 522);
        HTMLdtd.defineElement("TITLE", 32);
        HTMLdtd.defineElement("TR", 522);
        HTMLdtd.defineElement("UL", 66);
        _boolAttrs = new Hashtable();
        HTMLdtd.defineBoolean("AREA", "href");
        HTMLdtd.defineBoolean("BUTTON", "disabled");
        HTMLdtd.defineBoolean("DIR", "compact");
        HTMLdtd.defineBoolean("DL", "compact");
        HTMLdtd.defineBoolean("FRAME", "noresize");
        HTMLdtd.defineBoolean("HR", "noshade");
        HTMLdtd.defineBoolean("IMAGE", "ismap");
        HTMLdtd.defineBoolean("INPUT", new String[]{"defaultchecked", "checked", "readonly", "disabled"});
        HTMLdtd.defineBoolean("LINK", "link");
        HTMLdtd.defineBoolean("MENU", "compact");
        HTMLdtd.defineBoolean("OBJECT", "declare");
        HTMLdtd.defineBoolean("OL", "compact");
        HTMLdtd.defineBoolean("OPTGROUP", "disabled");
        HTMLdtd.defineBoolean("OPTION", new String[]{"default-selected", "selected", "disabled"});
        HTMLdtd.defineBoolean("SCRIPT", "defer");
        HTMLdtd.defineBoolean("SELECT", new String[]{"multiple", "disabled"});
        HTMLdtd.defineBoolean("STYLE", "disabled");
        HTMLdtd.defineBoolean("TD", "nowrap");
        HTMLdtd.defineBoolean("TH", "nowrap");
        HTMLdtd.defineBoolean("TEXTAREA", new String[]{"disabled", "readonly"});
        HTMLdtd.defineBoolean("UL", "compact");
        HTMLdtd.initialize();
    }

    public static boolean isEmptyTag(String tagName) {
        return HTMLdtd.isElement(tagName, 17);
    }

    public static boolean isElementContent(String tagName) {
        return HTMLdtd.isElement(tagName, 2);
    }

    public static boolean isPreserveSpace(String tagName) {
        return HTMLdtd.isElement(tagName, 4);
    }

    public static boolean isOptionalClosing(String tagName) {
        return HTMLdtd.isElement(tagName, 8);
    }

    public static boolean isOnlyOpening(String tagName) {
        return HTMLdtd.isElement(tagName, 1);
    }

    public static boolean isClosing(String tagName, String openTag) {
        if (openTag.equalsIgnoreCase("HEAD")) {
            return !HTMLdtd.isElement(tagName, 32);
        }
        if (openTag.equalsIgnoreCase("P")) {
            return HTMLdtd.isElement(tagName, 64);
        }
        if (openTag.equalsIgnoreCase("DT") || openTag.equalsIgnoreCase("DD")) {
            return HTMLdtd.isElement(tagName, 128);
        }
        if (openTag.equalsIgnoreCase("LI") || openTag.equalsIgnoreCase("OPTION")) {
            return HTMLdtd.isElement(tagName, 256);
        }
        if (openTag.equalsIgnoreCase("THEAD") || openTag.equalsIgnoreCase("TFOOT") || openTag.equalsIgnoreCase("TBODY") || openTag.equalsIgnoreCase("TR") || openTag.equalsIgnoreCase("COLGROUP")) {
            return HTMLdtd.isElement(tagName, 512);
        }
        if (openTag.equalsIgnoreCase("TH") || openTag.equalsIgnoreCase("TD")) {
            return HTMLdtd.isElement(tagName, 16384);
        }
        return false;
    }

    public static boolean isURI(String tagName, String attrName) {
        return attrName.equalsIgnoreCase("href") || attrName.equalsIgnoreCase("src");
    }

    public static boolean isBoolean(String tagName, String attrName) {
        String[] attrNames = (String[])_boolAttrs.get(tagName.toUpperCase(Locale.ENGLISH));
        if (attrNames == null) {
            return false;
        }
        int i = 0;
        while (i < attrNames.length) {
            if (attrNames[i].equalsIgnoreCase(attrName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int charFromName(String name) {
        HTMLdtd.initialize();
        Object value = _byName.get(name);
        if (value != null && value instanceof Integer) {
            return (Integer)value;
        }
        return -1;
    }

    public static String fromChar(int value) {
        if (value > 65535) {
            return null;
        }
        HTMLdtd.initialize();
        String name = (String)_byChar.get(new Integer(value));
        return name;
    }

    private static void initialize() {
        InputStream is = null;
        BufferedReader reader = null;
        if (_byName != null) {
            return;
        }
        try {
            try {
                _byName = new Hashtable();
                _byChar = new Hashtable();
                is = HTMLdtd.class.getResourceAsStream(ENTITIES_RESOURCE);
                if (is == null) {
                    throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ResourceNotFound", new Object[]{ENTITIES_RESOURCE}));
                }
                reader = new BufferedReader(new InputStreamReader(is, "ASCII"));
                String line = reader.readLine();
                while (line != null) {
                    if (line.length() == 0 || line.charAt(0) == '#') {
                        line = reader.readLine();
                        continue;
                    }
                    int index = line.indexOf(32);
                    if (index > 1) {
                        String name = line.substring(0, index);
                        if (++index < line.length()) {
                            String value = line.substring(index);
                            if ((index = value.indexOf(32)) > 0) {
                                value = value.substring(0, index);
                            }
                            int code = Integer.parseInt(value);
                            HTMLdtd.defineEntity(name, (char)code);
                        }
                    }
                    line = reader.readLine();
                }
                is.close();
            }
            catch (Exception except) {
                throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ResourceNotLoaded", new Object[]{ENTITIES_RESOURCE, except.toString()}));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void defineEntity(String name, char value) {
        if (_byName.get(name) == null) {
            _byName.put(name, new Integer(value));
            _byChar.put(new Integer(value), name);
        }
    }

    private static void defineElement(String name, int flags) {
        _elemDefs.put(name, new Integer(flags));
    }

    private static void defineBoolean(String tagName, String attrName) {
        HTMLdtd.defineBoolean(tagName, new String[]{attrName});
    }

    private static void defineBoolean(String tagName, String[] attrNames) {
        _boolAttrs.put(tagName, attrNames);
    }

    private static boolean isElement(String name, int flag) {
        Integer flags = (Integer)_elemDefs.get(name.toUpperCase(Locale.ENGLISH));
        if (flags == null) {
            return false;
        }
        return (flags & flag) == flag;
    }
}

