/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.StringValue;

public class NamespaceForPrefix
extends SystemFunction
implements CallableExpression {
    public Item evaluateItem(XPathContext context) throws XPathException {
        NodeInfo element = (NodeInfo)this.argument[1].evaluateItem(context);
        StringValue p = (StringValue)this.argument[0].evaluateItem(context);
        return NamespaceForPrefix.namespaceUriForPrefix(p, element);
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        AnyURIValue result = NamespaceForPrefix.namespaceUriForPrefix((StringValue)arguments[0].next(), (NodeInfo)arguments[1].next());
        return SingletonIterator.makeIterator(result);
    }

    private static AnyURIValue namespaceUriForPrefix(StringValue p, NodeInfo element) {
        InscopeNamespaceResolver resolver2 = new InscopeNamespaceResolver(element);
        String prefix = p == null ? "" : p.getStringValue();
        String uri = resolver2.getURIForPrefix(prefix, true);
        if (uri == null) {
            return null;
        }
        return new AnyURIValue(uri);
    }
}

