/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.Source;
import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.DocumentUriFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.AnyURIValue;

public class UriCollection
extends SystemFunction
implements CallableExpression {
    private String expressionBaseURI = null;

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator iter;
        String href = this.getNumberOfArguments() == 0 ? context.getConfiguration().getDefaultCollection() : this.argument[0].evaluateItem(context).getStringValue();
        CollectionURIResolver resolver2 = context.getConfiguration().getCollectionURIResolver();
        try {
            iter = resolver2.resolve(href, this.expressionBaseURI, context);
        }
        catch (XPathException e) {
            e.setLocator(this);
            throw e;
        }
        return UriCollection.getResolverResults(iter, context);
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        SequenceIterator iter;
        String href = this.getNumberOfArguments() == 0 ? context.getConfiguration().getDefaultCollection() : arguments[0].next().getStringValue();
        CollectionURIResolver resolver2 = context.getConfiguration().getCollectionURIResolver();
        try {
            iter = resolver2.resolve(href, this.expressionBaseURI, context);
        }
        catch (XPathException e) {
            e.setLocator(this);
            throw e;
        }
        return UriCollection.getResolverResults(iter, context);
    }

    private static SequenceIterator getResolverResults(SequenceIterator iter, final XPathContext context) {
        if (iter == null) {
            return EmptyIterator.getInstance();
        }
        ItemMappingFunction imf = new ItemMappingFunction(){

            public Item mapItem(Item item) throws XPathException {
                if (item instanceof NodeInfo) {
                    return DocumentUriFn.getDocumentURI((NodeInfo)item, context);
                }
                if (item instanceof Source) {
                    return new AnyURIValue(((Source)((Object)item)).getSystemId());
                }
                if (item instanceof AnyURIValue) {
                    return item;
                }
                throw new XPathException("Value returned by CollectionURIResolver must be a Source or an anyURI");
            }
        };
        return new ItemMappingIterator(iter, imf);
    }
}

