/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class XPathDynamicContext {
    private ItemType contextItemType;
    private XPathContextMajor contextObject;
    private SlotManager stackFrameMap;

    protected XPathDynamicContext(ItemType contextItemType, XPathContextMajor contextObject, SlotManager stackFrameMap) {
        this.contextItemType = contextItemType;
        this.contextObject = contextObject;
        this.stackFrameMap = stackFrameMap;
    }

    public void setContextNode(Source source) throws XPathException {
        NodeInfo origin;
        if (source instanceof NodeInfo) {
            origin = (NodeInfo)source;
            if (!origin.getConfiguration().isCompatible(this.contextObject.getConfiguration())) {
                throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
            }
        } else {
            origin = this.contextObject.getConfiguration().buildDocument(source);
        }
        this.setContextItem(origin);
    }

    public void setContextItem(Item item) throws XPathException {
        if (item instanceof NodeInfo && !((NodeInfo)item).getConfiguration().isCompatible(this.contextObject.getConfiguration())) {
            throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
        }
        if (!this.contextItemType.matchesItem(item, false, this.contextObject.getConfiguration())) {
            throw new XPathException("Supplied context item does not match required context item type " + this.contextItemType.toString());
        }
        UnfailingIterator<Item> iter = SingletonIterator.makeIterator(item);
        iter.next();
        this.contextObject.setCurrentIterator(iter);
    }

    public Item getContextItem() {
        return this.contextObject.getContextItem();
    }

    public void setVariable(XPathVariable variable, ValueRepresentation value) throws XPathException {
        StructuredQName expectedName;
        Object item;
        XPathException err;
        SequenceType requiredType = variable.getRequiredType();
        if (requiredType != SequenceType.ANY_SEQUENCE && (err = TypeChecker.testConformance(value, requiredType, this.contextObject)) != null) {
            throw err;
        }
        SequenceIterator iter = Value.asIterator(value);
        while ((item = iter.next()) != null) {
            if (!(item instanceof NodeInfo) || ((NodeInfo)item).getConfiguration().isCompatible(this.contextObject.getConfiguration())) continue;
            throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
        }
        int slot = variable.getLocalSlotNumber();
        StructuredQName structuredQName = expectedName = slot >= this.stackFrameMap.getNumberOfVariables() ? null : this.stackFrameMap.getVariableMap().get(slot);
        if (!variable.getVariableQName().equals(expectedName)) {
            throw new XPathException("Supplied XPathVariable is bound to the wrong slot: perhaps it was created using a different static context");
        }
        this.contextObject.setLocalVariable(slot, value);
    }

    public void setURIResolver(URIResolver resolver2) {
        this.contextObject.getController().setURIResolver(resolver2);
    }

    public URIResolver getURIResolver() {
        return this.contextObject.getController().getURIResolver();
    }

    public void setCollectionURIResolver(CollectionURIResolver resolver2) {
        this.contextObject.getController().setCollectionURIResolver(resolver2);
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.contextObject.getController().getCollectionURIResolver();
    }

    public void setErrorListener(ErrorListener listener) {
        this.contextObject.getController().setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.contextObject.getController().getErrorListener();
    }

    public XPathContext getXPathContextObject() {
        return this.contextObject;
    }

    protected void checkExternalVariables(SlotManager stackFrameMap, int numberOfExternals) throws XPathException {
        ValueRepresentation[] stack = this.contextObject.getStackFrame().getStackFrameValues();
        for (int i = 0; i < numberOfExternals; ++i) {
            if (stack[i] != null) continue;
            StructuredQName qname = stackFrameMap.getVariableMap().get(i);
            throw new XPathException("No value has been supplied for variable $" + qname.getDisplayName());
        }
    }
}

