/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import net.sqf.stringUtils.TextSource;
import net.sqf.xmlUtils.staxParser.NodeInfo;
import net.sqf.xmlUtils.staxParser.StringNode;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLLevels {
    private StringNode doc;
    private HashMap<Integer, Integer> levelMap = new HashMap();

    public XMLLevels(URI uri) throws IOException, SAXException, XMLStreamException {
        TextSource ts = TextSource.readTextFile(new File(uri));
        this.doc = new StringNode(ts);
    }

    public XMLLevels(String xmlString, String baseUri) throws IOException, SAXException, XMLStreamException {
        ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
        TextSource ts = TextSource.readTextFile(is, "UTF-8", new File(baseUri));
        this.doc = new StringNode(ts);
    }

    public String[] getLevels() {
        int maxLine = 0;
        try {
            ArrayList<NodeInfo> nodes = this.doc.getNodeSetInfo("//*");
            for (NodeInfo nodeI : nodes) {
                int level = this.getLevel(nodeI.getNode());
                int line = nodeI.getStart().getLineNumber();
                int lastLine = nodeI.getEnd().getLineNumber();
                this.addLine(line, level);
                this.addLine(lastLine, level);
                maxLine = line > maxLine ? line : maxLine;
                int n = maxLine = lastLine > maxLine ? lastLine : maxLine;
            }
            String[] levelArr = new String[maxLine];
            int levBefore = 0;
            int j = 0;
            while (j < levelArr.length) {
                int level = this.levelMap.containsKey(j + 1) ? this.levelMap.get(j + 1) : levBefore;
                levelArr[j] = "" + level;
                levBefore = level;
                ++j;
            }
            return levelArr;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return new String[0];
        }
    }

    private void addLine(int line, int level) {
        int levelBevor;
        int n = levelBevor = this.levelMap.containsKey(line) ? this.levelMap.get(line) : -1;
        if (levelBevor <= 0 || levelBevor >= level) {
            this.levelMap.put(line, level);
        }
    }

    private int getLevel(Node node) {
        Node parent = node.getParentNode();
        if (parent.getNodeType() == 9) {
            return 0;
        }
        return this.getLevel(parent) + 1;
    }

    public static boolean isExisting(String uri) throws URISyntaxException {
        File f = new File(new URI(uri).getPath());
        return f.isDirectory() && f.exists();
    }

    public static int getLastLine(Node node) {
        Object lastLine = node.getUserData("lineNumberLast");
        return (Integer)(lastLine == null ? Integer.valueOf(-1) : lastLine);
    }

    public static String[] getLevels(String uriString) throws IOException, SAXException, URISyntaxException, XMLStreamException {
        URI uri = new URI(uriString);
        XMLLevels xmlLevels = new XMLLevels(uri);
        return xmlLevels.getLevels();
    }

    public static String[] getLevels(String xml, String uri) throws IOException, SAXException, XMLStreamException {
        XMLLevels xmlLevels = new XMLLevels(xml, uri);
        return xmlLevels.getLevels();
    }

    public static void main(String[] args) throws URISyntaxException, IOException, SAXException, XMLStreamException {
        String uri = "/D:/nico/Work/Java/net.sqf.website/in/files/userGuide/people.xml";
        String xml = TextSource.readTextFile(new File(uri)).toString();
        String[] levels = XMLLevels.getLevels(xml, uri);
        int i = 0;
        while (i < levels.length) {
            System.out.println(levels[i]);
            ++i;
        }
    }
}

