/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.staxParser;

import java.util.ArrayList;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sqf.xmlUtils.staxParser.PositionalXMLReader;
import net.sqf.xmlUtils.xpath.NamespaceContextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UserDataManager {
    private final Document doc;
    private String docBytes;
    private boolean skipWhitespace = true;
    private Pattern attrPattern = Pattern.compile("\\s+(\\S+?)(\\s+)?=(\\s+)?(\"([^\"]*)\"|'([^']*)')");

    public UserDataManager(Document doc, String docBytes) {
        this.doc = doc;
        this.docBytes = docBytes;
    }

    void setXmlDeclaration(XMLStreamReader event) throws XMLStreamException {
        Range range = this.getRangeAndNextEvent(event);
        if (range.start.getCharacterOffset() == 0) {
            this.doc.setUserData("xmlDeclLocationStart", range.start, null);
            this.doc.setUserData("xmlDeclLocationEnd", range.end, null);
        }
    }

    void setDTD(XMLStreamReader event) throws XMLStreamException {
        Range range = this.getRangeAndNextEvent(event);
        this.skipWhitespace(range);
        this.doc.setUserData("hasDTD", true, null);
        this.doc.setUserData("dtdLocationStart", range.start, null);
        this.doc.setUserData("dtdLocationEnd", range.end, null);
    }

    void setNode(Node node, XMLStreamReader event) throws XMLStreamException {
        this.setNode(node, event, false);
    }

    void setNode(Node node, XMLStreamReader event, boolean textNode) throws XMLStreamException {
        NamespaceContext ns = event.getNamespaceContext();
        Range range = this.getRangeAndNextEvent(event);
        this.skipWhitespace(range);
        node.setUserData("nodeLocationStart", range.start, null);
        node.setUserData("nodeLocationEnd", range.end, null);
        node.setUserData("namespaceContext", ns, null);
    }

    void setStartElement(Element element, XMLStreamReader event) throws XMLStreamException {
        NamespaceContextImpl nsc = new NamespaceContextImpl(event);
        Range range = this.getRangeAndNextEvent(event);
        element.setUserData("nodeLocationStart", range.start, null);
        element.setUserData("nodeInnerLocationStart", range.end, null);
        element.setUserData("namespaceContext", nsc, null);
        this.skipWhitespace = false;
    }

    void setAttribute(Element el) {
        Location startLoc = (Location)el.getUserData("nodeLocationStart");
        Location endLoc = (Location)el.getUserData("nodeInnerLocationStart");
        Range range = new Range(startLoc, endLoc);
        String startTag = this.getString(range);
        NamedNodeMap attrMap = el.getAttributes();
        Pattern patternStart = Pattern.compile("\\s");
        Matcher matcherStart = patternStart.matcher(startTag);
        Pattern patternEnd = Pattern.compile("(/)?>$", 32);
        Matcher matcherEnd = patternEnd.matcher(startTag);
        int addEndPos = matcherEnd.find() ? matcherEnd.start() : startTag.length() - 1;
        int addStartPos = matcherStart.find() ? matcherStart.start() : addEndPos;
        el.setUserData("attributeRegionLocationStart", this.newLocation(range.start, addStartPos), null);
        el.setUserData("attributeRegionLocationEnd", this.newLocation(range.start, addEndPos), null);
        int i = 0;
        while (i < attrMap.getLength()) {
            this.setAttribute(startTag, range.start, attrMap.item(i));
            ++i;
        }
    }

    void setAttribute(String startTag, Location locStart, Node attr) {
        Matcher matcher = this.attrPattern.matcher(startTag);
        while (matcher.find()) {
            String name = matcher.group(1);
            if (!name.equals(attr.getNodeName())) continue;
            MatchResult mresult = matcher.toMatchResult();
            int startPos = mresult.start();
            int endPos = mresult.end();
            attr.setUserData("nodeLocationStart", this.newLocation(locStart, startPos), null);
            attr.setUserData("nodeLocationEnd", this.newLocation(locStart, endPos), null);
            break;
        }
    }

    void setEndElement(Element element, XMLStreamReader event) throws XMLStreamException {
        Node parent = element.getParentNode();
        boolean isEmpty = element.getFirstChild() == null;
        Range range = this.getRangeAndNextEvent(event);
        if (isEmpty && PositionalXMLReader.getPosition(element, "nodeLocationStart") == range.start.getCharacterOffset()) {
            element.setUserData("nodeInnerLocationStart", range.end, null);
            element.setUserData("nodeInnerLocationEnd", range.end, null);
        } else {
            element.setUserData("nodeInnerLocationEnd", range.start, null);
        }
        element.setUserData("nodeLocationEnd", range.end, null);
        element.setUserData("namespaceContext", new NamespaceContextImpl(element), null);
        this.setAttribute(element);
        this.skipWhitespace = parent.getNodeType() == 9;
    }

    private String getString(Range range) {
        return this.docBytes.substring(range.start.getCharacterOffset(), range.end.getCharacterOffset());
    }

    private Location newLocation(final Location loc, int addPositon) {
        final int correctLineNumber = loc.getLineNumber();
        final int correctColumnNumber = loc.getColumnNumber();
        final int correctPosition = loc.getCharacterOffset() + addPositon;
        return new Location(){

            @Override
            public String getSystemId() {
                return loc.getSystemId();
            }

            @Override
            public String getPublicId() {
                return loc.getPublicId();
            }

            @Override
            public int getLineNumber() {
                return correctLineNumber;
            }

            @Override
            public int getColumnNumber() {
                return correctColumnNumber;
            }

            @Override
            public int getCharacterOffset() {
                return correctPosition;
            }
        };
    }

    public void appendToTextNodeBundle(Node newTextNode, ArrayList<Node> textBuffer) {
        Node first = textBuffer.get(0);
        Node last = textBuffer.get(textBuffer.size() - 1);
        newTextNode.setUserData("nodeLocationStart", first.getUserData("nodeLocationStart"), null);
        newTextNode.setUserData("nodeLocationEnd", last.getUserData("nodeLocationEnd"), null);
    }

    private void skipWhitespace(Range range) {
        if (this.skipWhitespace) {
            String passage = this.getString(range);
            int corPosStart = passage.indexOf(60);
            int corPosEnd = passage.lastIndexOf(62) - passage.length() + 1;
            range.start = this.newLocation(range.start, corPosStart);
            range.end = this.newLocation(range.end, corPosEnd);
        }
    }

    private Range getRangeAndNextEvent(XMLStreamReader event) throws XMLStreamException {
        Location start = event.getLocation();
        event.next();
        Location end = event.getLocation();
        Range range = new Range(start, end);
        return range;
    }

    private class Range {
        private Location start;
        private Location end;

        public Range(Location start, Location end) {
            this.start = start;
            this.end = end;
        }
    }
}

