/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.xslt;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sqf.stringUtils.TextSource;
import net.sqf.xmlUtils.xslt.Parameter;
import net.sqf.xmlUtils.xslt.SaxonUtils;

public class XSLTStep {
    private static TransformerFactory transfac;
    private ArrayList<TransformerException> warnings = new ArrayList();
    private ArrayList<TransformerException> errors = new ArrayList();
    private ArrayList<TransformerException> fatalErrors = new ArrayList();
    private final Transformer transformer;
    private final ErrorListener el = new ErrorListener(){

        @Override
        public void warning(TransformerException arg0) throws TransformerException {
            XSLTStep.this.warnings.add(arg0);
        }

        @Override
        public void fatalError(TransformerException arg0) throws TransformerException {
            XSLTStep.this.fatalErrors.add(arg0);
        }

        @Override
        public void error(TransformerException arg0) throws TransformerException {
            XSLTStep.this.errors.add(arg0);
        }
    };

    static {
        try {
            transfac = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public XSLTStep(TextSource virtualXSL, ArrayList<Parameter> params) throws TransformerConfigurationException {
        this(SaxonUtils.getStreamSource(virtualXSL), params);
    }

    public XSLTStep(File xslsheet, ArrayList<Parameter> params) throws TransformerConfigurationException {
        this(SaxonUtils.getStreamSource(xslsheet), params);
    }

    public XSLTStep(Source xsl, ArrayList<Parameter> params) throws TransformerConfigurationException {
        this.transformer = transfac.newTransformer(xsl);
        this.transformer.setErrorListener(this.el);
        this.setParameters(params);
    }

    public XSLTStep(Source xslStream, ErrorListener errorListener, ArrayList<Parameter> params) throws TransformerConfigurationException {
        this(xslStream, params);
        this.transformer.setErrorListener(errorListener);
    }

    public XSLTStep(TextSource virtualXSL, ErrorListener errorListener, ArrayList<Parameter> params) throws TransformerConfigurationException {
        this(virtualXSL, params);
        this.transformer.setErrorListener(errorListener);
    }

    public XSLTStep(File xslsheet, ErrorListener errorListener, ArrayList<Parameter> params) throws TransformerConfigurationException {
        this(xslsheet, params);
        this.transformer.setErrorListener(errorListener);
    }

    public void setOutputProperty(Properties props) {
        this.transformer.setOutputProperties(props);
    }

    private void setParameters(ArrayList<Parameter> params) {
        for (Parameter p : params) {
            this.transformer.setParameter(p.getQName(), p.getValue());
        }
    }

    public TextSource transform(TextSource source, ArrayList<Parameter> params) {
        this.setParameters(params);
        return this.transform(source, source.getFile());
    }

    public TextSource transform(TextSource source) {
        return this.transform(source, source.getFile());
    }

    public TextSource transform(TextSource source, File outFile, ArrayList<Parameter> params) {
        this.setParameters(params);
        return this.transform(source, outFile);
    }

    public TextSource transform(TextSource source, File outFile) {
        StreamSource ss = new StreamSource(new StringReader(source.toString()));
        ss.setSystemId(source.getFile());
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        result.setSystemId(outFile.getAbsolutePath());
        this.transform(ss, result);
        TextSource resultSource = TextSource.createVirtualTextSource(outFile);
        resultSource.setData(writer.toString());
        return resultSource;
    }

    private Result transform(Source source, Result result) {
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            this.errors.add(e);
        }
        return result;
    }

    public ArrayList<TransformerException> getErrors(int level) {
        ArrayList<TransformerException> errorList = new ArrayList<TransformerException>();
        if (level <= 2) {
            errorList.addAll(this.fatalErrors);
        }
        if (level <= 1) {
            errorList.addAll(this.errors);
        }
        if (level <= 0) {
            errorList.addAll(this.warnings);
        }
        return errorList;
    }
}

