/*
 * Decompiled with CFR 0.152.
 */
package org.apache.env;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.env.WhichClass;
import org.apache.env.WhichConstant;
import org.apache.env.WhichJar;
import org.apache.env.WhichProject;

public class WhichXalan
implements WhichProject {
    public static final String SERVICE_NAME = "Xalan";
    private static final String XALAN_JARNAME = "xalan.jar";
    private static final String XMLAPIS_JARNAME = "xml-apis.jar";
    private static final String XALAN1_VERSION_CLASS = "org.apache.xalan.xslt.XSLProcessorVersion";
    private static final String XALAN2_VERSION_CLASS = "org.apache.xalan.processor.XSLProcessorVersion";
    private static final String XALAN2_2_VERSION_CLASS = "org.apache.xalan.Version";
    private static final String XALAN2_2_VERSION_METHOD = "getVersion";

    @Override
    public int getInfo(Hashtable hash, String options) {
        if (hash == null) {
            hash = new Hashtable<String, String>();
        }
        try {
            Class clazz = WhichClass.findClass(XALAN1_VERSION_CLASS, options);
            StringBuffer buf = new StringBuffer();
            Field f = clazz.getField("PRODUCT");
            buf.append(f.get(null));
            buf.append(';');
            f = clazz.getField("LANGUAGE");
            buf.append(f.get(null));
            buf.append(';');
            f = clazz.getField("S_VERSION");
            buf.append(f.get(null));
            buf.append(';');
            hash.put("Xalan1.version", buf.toString());
        }
        catch (Exception e1) {
            hash.put("Xalan1.version", WhichConstant.ITEM_DESC[3]);
        }
        int xalan2found = 0;
        int xalan22found = 0;
        try {
            Class clazz = WhichClass.findClass(XALAN2_VERSION_CLASS, options);
            StringBuffer buf = new StringBuffer();
            Field f = clazz.getField("S_VERSION");
            buf.append(f.get(null));
            hash.put("Xalan2x.version", buf.toString());
            xalan2found = 2;
        }
        catch (Exception e2) {
            hash.put("Xalan2x.version", WhichConstant.ITEM_DESC[3]);
            xalan2found = 3;
        }
        try {
            Class[] noArgs = new Class[]{};
            Class clazz = WhichClass.findClass(XALAN2_2_VERSION_CLASS, options);
            Method method = clazz.getMethod(XALAN2_2_VERSION_METHOD, noArgs);
            Object returnValue = method.invoke(null, new Object[0]);
            hash.put("Xalan22+.version", (String)returnValue);
            xalan22found = 2;
        }
        catch (Exception e3) {
            hash.put("Xalan22+.version", WhichConstant.ITEM_DESC[3]);
            xalan22found = 3;
        }
        int jarRetVal = WhichJar.searchClasspaths(hash, XALAN_JARNAME, options);
        int ignoreThisReturnValue = WhichJar.searchClasspaths(hash, XMLAPIS_JARNAME, options);
        return Math.max(jarRetVal, Math.max(xalan2found, xalan22found));
    }
}

