/*
 * Decompiled with CFR 0.152.
 */
package org.apache.env;

import java.lang.reflect.Field;
import java.util.Hashtable;
import org.apache.env.WhichClass;
import org.apache.env.WhichConstant;
import org.apache.env.WhichJar;
import org.apache.env.WhichProject;

public class WhichXerces
implements WhichProject {
    public static final String SERVICE_NAME = "Xerces";
    private static final String XERCES_JARNAME = "xerces.jar";
    private static final String XERCESIMPL_JARNAME = "xercesImpl.jar";
    private static final String PARSERAPIS_JARNAME = "xmlParserAPIs.jar";
    private static final String XERCES1_VERSION_CLASS = "org.apache.xerces.framework.Version";
    private static final String XERCES1_VERSION_FIELD = "fVersion";
    private static final String XERCES2_VERSION_CLASS = "org.apache.xerces.impl.Version";
    private static final String XERCES2_VERSION_FIELD = "fVersion";

    @Override
    public int getInfo(Hashtable hash, String options) {
        String buf;
        Field f;
        Class clazz;
        if (hash == null) {
            hash = new Hashtable<String, String>();
        }
        int xerces1found = 0;
        int xerces2found = 0;
        try {
            clazz = WhichClass.findClass(XERCES1_VERSION_CLASS, options);
            f = clazz.getField("fVersion");
            buf = (String)f.get(null);
            hash.put("Xerces1.version", buf);
            xerces1found = 2;
        }
        catch (Exception e1) {
            hash.put("Xerces1.version", WhichConstant.ITEM_DESC[3]);
            xerces1found = 3;
        }
        try {
            clazz = WhichClass.findClass(XERCES2_VERSION_CLASS, options);
            f = clazz.getField("fVersion");
            buf = (String)f.get(null);
            hash.put("Xerces2.version", buf);
            xerces2found = 2;
        }
        catch (Exception e1) {
            hash.put("Xerces2.version", WhichConstant.ITEM_DESC[3]);
            xerces2found = 3;
        }
        int jarRetVal = WhichJar.searchClasspaths(hash, XERCES_JARNAME, options);
        jarRetVal = Math.min(jarRetVal, WhichJar.searchClasspaths(hash, XERCESIMPL_JARNAME, options));
        int ignoreThisReturnValue = WhichJar.searchClasspaths(hash, PARSERAPIS_JARNAME, options);
        int anyXercesFound = Math.min(xerces1found, xerces2found);
        return Math.max(jarRetVal, anyXercesFound);
    }
}

