/*
 * Decompiled with CFR 0.152.
 */
package org.apache.html.dom;

import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.html.dom.HTMLElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;

public class HTMLOptionElementImpl
extends HTMLElementImpl
implements HTMLOptionElement {
    private static final long serialVersionUID = -4486774554137530907L;

    @Override
    public boolean getDefaultSelected() {
        return this.getBinary("default-selected");
    }

    @Override
    public void setDefaultSelected(boolean defaultSelected) {
        this.setAttribute("default-selected", defaultSelected);
    }

    @Override
    public String getText() {
        StringBuffer text = new StringBuffer();
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof Text) {
                text.append(((Text)child).getData());
            }
            child = child.getNextSibling();
        }
        return text.toString();
    }

    public void setText(String text) {
        Node child = this.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            this.removeChild(child);
            child = next;
        }
        this.insertBefore(this.getOwnerDocument().createTextNode(text), this.getFirstChild());
    }

    @Override
    public int getIndex() {
        Node parent = this.getParentNode();
        while (parent != null && !(parent instanceof HTMLSelectElement)) {
            parent = parent.getParentNode();
        }
        if (parent != null) {
            NodeList options = ((HTMLElement)parent).getElementsByTagName("OPTION");
            int i = 0;
            while (i < options.getLength()) {
                if (options.item(i) == this) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public void setIndex(int index) {
        NodeList options;
        Node parent = this.getParentNode();
        while (parent != null && !(parent instanceof HTMLSelectElement)) {
            parent = parent.getParentNode();
        }
        if (parent != null && (options = ((HTMLElement)parent).getElementsByTagName("OPTION")).item(index) != this) {
            this.getParentNode().removeChild(this);
            Node item = options.item(index);
            item.getParentNode().insertBefore(this, item);
        }
    }

    @Override
    public boolean getDisabled() {
        return this.getBinary("disabled");
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.setAttribute("disabled", disabled);
    }

    @Override
    public String getLabel() {
        return this.capitalize(this.getAttribute("label"));
    }

    @Override
    public void setLabel(String label) {
        this.setAttribute("label", label);
    }

    @Override
    public boolean getSelected() {
        return this.getBinary("selected");
    }

    public void setSelected(boolean selected) {
        this.setAttribute("selected", selected);
    }

    @Override
    public String getValue() {
        return this.getAttribute("value");
    }

    @Override
    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    public HTMLOptionElementImpl(HTMLDocumentImpl owner, String name) {
        super(owner, name);
    }
}

