/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv;

import java.util.Hashtable;
import org.apache.xerces.impl.dv.DVFactoryException;
import org.apache.xerces.impl.dv.DatatypeValidator;
import org.apache.xerces.impl.dv.ObjectFactory;

public abstract class DTDDVFactory {
    private static final String DEFAULT_FACTORY_CLASS = "org.apache.xerces.impl.dv.dtd.DTDDVFactoryImpl2";

    public static final DTDDVFactory getInstance() throws DVFactoryException {
        return DTDDVFactory.getInstance(DEFAULT_FACTORY_CLASS);
    }

    public static final DTDDVFactory getInstance(String factoryClass) throws DVFactoryException {
        try {
            Object dtdDVFactory = ObjectFactory.newInstance(factoryClass, ObjectFactory.findClassLoader(), true);
            return (DTDDVFactory)dtdDVFactory;
        }
        catch (ClassCastException e) {
            throw new DVFactoryException("DTD factory class " + factoryClass + " does not extend from DTDDVFactory.");
        }
    }

    protected DTDDVFactory() {
    }

    public abstract DatatypeValidator getBuiltInDV(String var1);

    public abstract Hashtable getBuiltInTypes();
}

