/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xml.serialize.SecuritySupport;

final class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = ObjectFactory.isDebugEnabled();
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;

    ObjectFactory() {
    }

    static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        String factoryClassName;
        ClassLoader cl;
        block45: {
            block46: {
                block43: {
                    if (DEBUG) {
                        ObjectFactory.debugPrintln("debug is on");
                    }
                    cl = ObjectFactory.findClassLoader();
                    try {
                        String systemProp = SecuritySupport.getSystemProperty(factoryId);
                        if (systemProp != null && systemProp.length() > 0) {
                            if (!DEBUG) return ObjectFactory.newInstance(systemProp, cl, true);
                            ObjectFactory.debugPrintln("found system property, value=" + systemProp);
                            return ObjectFactory.newInstance(systemProp, cl, true);
                        }
                    }
                    catch (SecurityException systemProp) {
                        // empty catch block
                    }
                    factoryClassName = null;
                    if (propertiesFilename != null) break block46;
                    File propertiesFile = null;
                    boolean propertiesFileExists = false;
                    try {
                        String javah = SecuritySupport.getSystemProperty("java.home");
                        propertiesFilename = String.valueOf(javah) + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                        propertiesFile = new File(propertiesFilename);
                        propertiesFileExists = SecuritySupport.getFileExists(propertiesFile);
                    }
                    catch (SecurityException e) {
                        fLastModified = -1L;
                        fXercesProperties = null;
                    }
                    Class<ObjectFactory> clazz = ObjectFactory.class;
                    // MONITORENTER : org.apache.xml.serialize.ObjectFactory.class
                    boolean loadProperties = false;
                    FileInputStream fis = null;
                    try {
                        try {
                            block48: {
                                block47: {
                                    if (fLastModified < 0L) break block47;
                                    if (propertiesFileExists && fLastModified < (fLastModified = SecuritySupport.getLastModified(propertiesFile))) {
                                        loadProperties = true;
                                        break block48;
                                    } else if (!propertiesFileExists) {
                                        fLastModified = -1L;
                                        fXercesProperties = null;
                                    }
                                    break block48;
                                }
                                if (propertiesFileExists) {
                                    loadProperties = true;
                                    fLastModified = SecuritySupport.getLastModified(propertiesFile);
                                }
                            }
                            if (loadProperties) {
                                fXercesProperties = new Properties();
                                fis = SecuritySupport.getFileInputStream(propertiesFile);
                                fXercesProperties.load(fis);
                            }
                        }
                        catch (Exception x) {
                            fXercesProperties = null;
                            fLastModified = -1L;
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block43;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fis == null) throw throwable;
                        try {
                            fis.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                // MONITOREXIT : clazz
                if (fXercesProperties != null) {
                    factoryClassName = fXercesProperties.getProperty(factoryId);
                }
                break block45;
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = SecuritySupport.getFileInputStream(new File(propertiesFilename));
                    Properties props = new Properties();
                    props.load(fis);
                    factoryClassName = props.getProperty(factoryId);
                }
                catch (Exception exception) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block45;
                }
            }
            catch (Throwable throwable) {
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (factoryClassName != null) {
            if (!DEBUG) return ObjectFactory.newInstance(factoryClassName, cl, true);
            ObjectFactory.debugPrintln("found in " + propertiesFilename + ", value=" + factoryClassName);
            return ObjectFactory.newInstance(factoryClassName, cl, true);
        }
        Object provider = ObjectFactory.findJarServiceProvider(factoryId);
        if (provider != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        if (!DEBUG) return ObjectFactory.newInstance(fallbackClassName, cl, true);
        ObjectFactory.debugPrintln("using fallback, value=" + fallbackClassName);
        return ObjectFactory.newInstance(fallbackClassName, cl, true);
    }

    private static boolean isDebugEnabled() {
        try {
            String val = SecuritySupport.getSystemProperty("xerces.debug");
            return val != null && !"false".equals(val);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static void debugPrintln(String msg) {
        if (DEBUG) {
            System.err.println("XERCES: " + msg);
        }
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader system;
        ClassLoader context = SecuritySupport.getContextClassLoader();
        ClassLoader chain = system = SecuritySupport.getSystemClassLoader();
        while (true) {
            if (context == chain) {
                ClassLoader current = ObjectFactory.class.getClassLoader();
                chain = system;
                while (true) {
                    if (current == chain) {
                        return system;
                    }
                    if (chain == null) break;
                    chain = SecuritySupport.getParentClassLoader(chain);
                }
                return current;
            }
            if (chain == null) break;
            chain = SecuritySupport.getParentClassLoader(chain);
        }
        return context;
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class providerClass = ObjectFactory.findProviderClass(className, cl, doFallback);
            Object instance = providerClass.newInstance();
            if (DEBUG) {
                ObjectFactory.debugPrintln("created new instance of " + providerClass + " using ClassLoader: " + cl);
            }
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Class findProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException, ConfigurationError {
        Class<?> providerClass;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            int lastDot = className.lastIndexOf(".");
            String packageName = className;
            if (lastDot != -1) {
                packageName = className.substring(0, lastDot);
            }
            security.checkPackageAccess(packageName);
        }
        if (cl == null) {
            providerClass = Class.forName(className);
        } else {
            try {
                providerClass = cl.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                if (doFallback) {
                    ClassLoader current = ObjectFactory.class.getClassLoader();
                    if (current == null) {
                        providerClass = Class.forName(className);
                    }
                    if (cl != current) {
                        cl = current;
                        providerClass = cl.loadClass(className);
                    }
                    throw x;
                }
                throw x;
            }
        }
        return providerClass;
    }

    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        ClassLoader current;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = ObjectFactory.findClassLoader();
        is = SecuritySupport.getResourceAsStream(cl, serviceId);
        if (is == null && cl != (current = ObjectFactory.class.getClassLoader())) {
            cl = current;
            is = SecuritySupport.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        if (DEBUG) {
            ObjectFactory.debugPrintln("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        }
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is), 80);
        }
        String factoryClassName = null;
        try {
            try {
                factoryClassName = rd.readLine();
            }
            catch (IOException x) {
                try {
                    rd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            try {
                rd.close();
            }
            catch (IOException iOException) {}
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            if (DEBUG) {
                ObjectFactory.debugPrintln("found in resource, value=" + factoryClassName);
            }
            return ObjectFactory.newInstance(factoryClassName, cl, false);
        }
        return null;
    }

    static final class ConfigurationError
    extends Error {
        static final long serialVersionUID = 937647395548533254L;
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

