/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.utils.process.queues;

import net.sqf.utils.process.log.ProcessStateListener;
import net.sqf.utils.process.queues.SimpleTask;
import net.sqf.utils.process.queues.SubQueue;
import net.sqf.utils.process.queues._Task;
import net.sqf.utils.process.queues.listeners.QueueCancelListener;
import net.sqf.utils.process.queues.listeners.QueueListener;

public class Queue<Input, Output>
extends SubQueue<Input, Output> {
    private final String title;
    private final ProcessStateListener psl;

    public Queue(String title, Class<Input> inputClass, Class<Output> outputClass, ProcessStateListener psl) {
        super(inputClass, outputClass);
        this.title = title;
        this.psl = psl;
    }

    public Queue(String title, SubQueue subQue, ProcessStateListener psl) {
        this(title, subQue.getInputClass(), subQue.getOutputClass(), psl);
        this.addAllTasks(subQue.getTasks());
    }

    @Override
    public void start(Input input) {
        this.addCancelListener(new QueueCancelListener(){

            @Override
            public void process(Exception e) {
                Queue.this.psl.end(e);
            }
        });
        this.addTask(new SimpleTask<Output, Output>("Finishing " + this.title, this.getInputClass(), this.getOutputClass()){

            @Override
            public Output process(Output result) {
                try {
                    Queue.this.psl.setProcessState(100.0, this.toString());
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return result;
            }
        });
        this.addEndListener(new QueueListener(){

            @Override
            public void process(_Task currentTask) {
                Queue.this.psl.end();
            }
        });
        this.addProgressListener(new QueueListener(){

            @Override
            public void process(_Task currentTask) {
                Queue.this.psl.setProcessState(Queue.this.getProgress(), currentTask.toString());
            }
        });
        this.addStartListener(new QueueListener(){

            @Override
            public void process(_Task currentTask) {
                Queue.this.psl.start();
                Queue.this.psl.setProcessState(0.0, currentTask.toString());
            }
        });
        super.start(input);
    }
}

