/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.xslt;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sqf.stringUtils.TextSource;
import net.sqf.xmlUtils.xslt.Parameter;
import net.sqf.xmlUtils.xslt.XSLTStep;

public class XSLTPipe {
    private ArrayList<XSLTStep> xsltSteps = new ArrayList();
    private ArrayList<TextSource> tempResults = new ArrayList();
    private ErrorListener errorListener = null;
    private final String title;
    private Properties outputProps;

    public XSLTPipe(String title) {
        this.title = title;
    }

    public XSLTPipe(String title, Properties outputProperties) {
        this(title);
        this.outputProps = outputProperties;
    }

    public XSLTPipe(String title, ErrorListener el) {
        this(title);
        this.errorListener = el;
    }

    public XSLTPipe(String title, Properties outputProperties, ErrorListener el) {
        this(title, el);
        this.outputProps = outputProperties;
    }

    public void addStep(Source[] xsls) throws TransformerConfigurationException {
        int i = 0;
        while (i < xsls.length) {
            this.addStep(xsls[i], new ArrayList<Parameter>());
            ++i;
        }
    }

    public void addStep(Source xsl) throws TransformerConfigurationException {
        this.addStep(xsl, new ArrayList<Parameter>());
    }

    public void addStep(TextSource[] xsls) throws TransformerConfigurationException {
        int i = 0;
        while (i < xsls.length) {
            this.addStep(xsls[i], new ArrayList<Parameter>());
            ++i;
        }
    }

    public void addStep(TextSource xsl) throws TransformerConfigurationException {
        this.addStep(xsl, new ArrayList<Parameter>());
    }

    public void addStep(File[] xsls) throws TransformerConfigurationException {
        int i = 0;
        while (i < xsls.length) {
            this.addStep(xsls[i], new ArrayList<Parameter>());
            ++i;
        }
    }

    public void addStep(File xsl) throws TransformerConfigurationException {
        this.addStep(xsl, new ArrayList<Parameter>());
    }

    public void addStep(Source xsl, ArrayList<Parameter> params) throws TransformerConfigurationException {
        this.addStep(this.errorListener != null ? new XSLTStep(xsl, this.errorListener, params) : new XSLTStep(xsl, params));
    }

    public void addStep(TextSource xsl, ArrayList<Parameter> params) throws TransformerConfigurationException {
        this.addStep(this.errorListener != null ? new XSLTStep(xsl, this.errorListener, params) : new XSLTStep(xsl, params));
    }

    public void addStep(File xsl, ArrayList<Parameter> params) throws TransformerConfigurationException {
        this.addStep(this.errorListener != null ? new XSLTStep(xsl, this.errorListener, params) : new XSLTStep(xsl, params));
    }

    private void addStep(XSLTStep step) {
        if (this.outputProps != null) {
            step.setOutputProperty(this.outputProps);
        }
        this.xsltSteps.add(step);
    }

    public void reset() {
        this.xsltSteps = new ArrayList();
    }

    public TextSource pipe(File source, ArrayList<Parameter> params) throws IOException {
        return this.pipe(TextSource.readTextFile(source), params);
    }

    public TextSource pipe(File source) throws IOException {
        return this.pipe(TextSource.readTextFile(source));
    }

    public TextSource pipe(TextSource source) {
        return this.pipe(source, new ArrayList<Parameter>());
    }

    public TextSource pipe(TextSource source, ArrayList<Parameter> params) {
        this.tempResults = new ArrayList();
        this.tempResults.add(source);
        HashMap<Integer, ArrayList<Parameter>> paramByStep = this.createParamStepMap(params);
        int stepCounter = 0;
        for (XSLTStep step : this.xsltSteps) {
            ArrayList<Parameter> stepParam = paramByStep.containsKey(stepCounter) ? paramByStep.get(stepCounter) : new ArrayList<Parameter>();
            this.tempResults.add(step.transform(this.tempResults.get(this.tempResults.size() - 1), stepParam));
            ArrayList<TransformerException> errors = step.getErrors(1);
            for (TransformerException te : errors) {
                System.err.println(te.getLocalizedMessage());
            }
            ++stepCounter;
        }
        return this.tempResults.get(this.tempResults.size() - 1);
    }

    public ArrayList<TextSource> getTempResults() {
        return this.tempResults;
    }

    private HashMap<Integer, ArrayList<Parameter>> createParamStepMap(ArrayList<Parameter> paramList) {
        HashMap<Integer, ArrayList<Parameter>> paramByStep = new HashMap<Integer, ArrayList<Parameter>>();
        for (Parameter param : paramList) {
            if (paramByStep.containsKey(param.getStep())) {
                paramByStep.get(param.getStep()).add(param);
                continue;
            }
            ArrayList<Parameter> stepList = new ArrayList<Parameter>();
            stepList.add(param);
            paramByStep.put(param.getStep(), stepList);
        }
        return paramByStep;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProps = outputProperties;
    }
}

