/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.library.HttpRequest;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;

public class Zip
extends DefaultStep {
    protected static final QName _href = new QName("", "href");
    protected static final QName _name = new QName("", "name");
    protected static final QName _command = new QName("", "command");
    protected static final QName _compression_method = new QName("", "compression-method");
    protected static final QName _compression_level = new QName("", "compression-level");
    protected static final QName c_zip_manifest = new QName("c", "http://www.w3.org/ns/xproc-step", "zip-manifest");
    protected static final QName c_zipfile = new QName("c", "http://www.w3.org/ns/xproc-step", "zipfile");
    protected static final QName c_entry = new QName("c", "http://www.w3.org/ns/xproc-step", "entry");
    protected static final QName c_file = new QName("c", "http://www.w3.org/ns/xproc-step", "file");
    protected static final QName c_directory = new QName("c", "http://www.w3.org/ns/xproc-step", "directory");
    protected static final QName _compressed_size = new QName("", "compressed-size");
    protected static final QName _comment = new QName("", "comment");
    protected static final QName _size = new QName("", "size");
    protected static final QName _date = new QName("", "date");
    private static final QName _status_only = new QName("status-only");
    private static final QName _detailed = new QName("detailed");
    private static final QName _status = new QName("status");
    private static final QName _value = new QName("value");
    private static final int bufsize = 8192;
    private static final QName[] serializerAttrs = new QName[]{_byte_order_mark, _cdata_section_elements, _doctype_public, _doctype_system, _encoding, _escape_uri_attributes, _include_content_type, _indent, _media_type, _method, _normalization_form, _omit_xml_declaration, _standalone, _undeclare_prefixes, _version};
    private ReadablePipe source = null;
    private ReadablePipe manifest = null;
    private WritablePipe result = null;
    private Map<String, FileToZip> zipManifest = new LinkedHashMap<String, FileToZip>();
    private Map<String, XdmNode> srcManifest = new LinkedHashMap<String, XdmNode>();

    public Zip(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else {
            this.manifest = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.manifest.resetReader();
        this.result.resetWriter();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() throws SaxonApiException {
        super.run();
        zipFn = this.getOption(Zip._href).getString();
        man = S9apiUtils.getDocumentElement(this.manifest.read());
        if (Zip.c_zip_manifest.equals(man.getNodeName())) ** GOTO lbl10
        throw new XProcException(this.step.getNode(), "The cx:zip manifest must be a c:zip-manifest.");
lbl-1000:
        // 1 sources

        {
            doc = this.source.read();
            root = S9apiUtils.getDocumentElement(doc);
            this.srcManifest.put(root.getBaseURI().toASCIIString(), doc);
lbl10:
            // 2 sources

            ** while (this.source.moreDocuments())
        }
lbl11:
        // 1 sources

        this.parseManifest(man);
        zipFile = null;
        try {
            zipFile = new File(new URI(zipFn));
        }
        catch (URISyntaxException e) {
            throw new XProcException(e);
        }
        zipParent = zipFile.getParentFile();
        zipTemp = null;
        inZip = null;
        outZip = null;
        try {
            zipTemp = File.createTempFile("calabashZip", ".zip", zipParent);
            zipTemp.deleteOnExit();
            if (zipFile.exists()) {
                inZip = new ZipFile(zipFile);
            }
            outZip = new ZipOutputStream(new FileOutputStream(zipTemp));
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        command = this.getOption(Zip._command).getString();
        if ("create".equals(command)) {
            try {
                if (inZip != null) {
                    inZip.close();
                }
            }
            catch (IOException ioe) {
                throw new XProcException(ioe);
            }
            inZip = null;
        }
        if ("update".equals(command) || "create".equals(command)) {
            this.update(inZip, outZip, false);
        } else if ("freshen".equals(command)) {
            this.update(inZip, outZip, true);
        } else if ("delete".equals(command)) {
            this.delete(inZip, outZip);
        } else {
            throw new XProcException(this.step.getNode(), "Unexpected cx:zip command: " + command);
        }
        if (zipFile.exists()) {
            zipFile.delete();
        }
        zipTemp.renameTo(zipFile);
        tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(Zip.c_zipfile);
        tree.addAttribute(Zip._href, zipFile.toURI().toASCIIString());
        tree.startContent();
        try {
            url = zipFile.toURI().toURL();
            connection = url.openConnection();
            stream = connection.getInputStream();
            zipStream = new ZipInputStream(stream);
            dfactory = DatatypeFactory.newInstance();
            cal = new GregorianCalendar();
            entry = zipStream.getNextEntry();
            while (entry != null) {
                cal.setTimeInMillis(entry.getTime());
                xmlCal = dfactory.newXMLGregorianCalendar(cal);
                if (entry.isDirectory()) {
                    tree.addStartElement(Zip.c_directory);
                } else {
                    tree.addStartElement(Zip.c_file);
                    tree.addAttribute(Zip._compressed_size, "" + entry.getCompressedSize());
                    tree.addAttribute(Zip._size, "" + entry.getSize());
                }
                if (entry.getComment() != null) {
                    tree.addAttribute(Zip._comment, entry.getComment());
                }
                tree.addAttribute(Zip._name, entry.getName());
                tree.addAttribute(Zip._date, xmlCal.toXMLFormat());
                tree.startContent();
                tree.addEndElement();
                entry = zipStream.getNextEntry();
            }
            zipStream.close();
        }
        catch (MalformedURLException mue) {
            throw new XProcException(XProcException.err_E0001, (Throwable)mue);
        }
        catch (IOException ioe) {
            throw new XProcException(XProcException.err_E0001, (Throwable)ioe);
        }
        catch (DatatypeConfigurationException dce) {
            throw new XProcException(XProcException.err_E0001, (Throwable)dce);
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    private void parseManifest(XdmNode man) {
        for (XdmNode child : new RelevantNodes(this.runtime, man, Axis.CHILD)) {
            if (XdmNodeKind.ELEMENT == child.getNodeKind()) {
                if (c_entry.equals(child.getNodeName())) {
                    String name = child.getAttributeValue(_name);
                    if (name == null || "".equals(name)) {
                        throw new XProcException(this.step.getNode(), "Missing or invalid name in cx:zip manifest.");
                    }
                    String href = child.getAttributeValue(_href);
                    if (href == null || "".equals(href)) {
                        throw new XProcException(this.step.getNode(), "Missing or invalid href in cx:zip manifest.");
                    }
                    String hrefuri = child.getBaseURI().resolve(href).toASCIIString();
                    String comment = child.getAttributeValue(_comment);
                    int method = 8;
                    int level = -1;
                    String value = child.getAttributeValue(_compression_method);
                    if ("stored".equals(value)) {
                        method = 0;
                    }
                    if ("smallest".equals(value = child.getAttributeValue(_compression_level))) {
                        level = 9;
                    } else if ("fastest".equals(value)) {
                        level = 1;
                    } else if ("huffman".equals(value)) {
                        level = 2;
                    } else if ("none".equals(value)) {
                        level = 0;
                        method = 0;
                    }
                    this.zipManifest.put(name, new FileToZip(name, hrefuri, method, level, comment, child));
                    continue;
                }
                throw new XProcException(this.step.getNode(), "Unexpected element in cx:zip manifest: " + child.getNodeName());
            }
            throw new XProcException(this.step.getNode(), "Unexpected content in cx:zip manifest.");
        }
    }

    public void update(ZipFile inZip, ZipOutputStream outZip, boolean freshen) {
        byte[] buffer = new byte[8192];
        try {
            if (inZip != null) {
                Enumeration<? extends ZipEntry> zenum = inZip.entries();
                while (zenum.hasMoreElements()) {
                    ZipEntry entry = zenum.nextElement();
                    String name = entry.getName();
                    boolean skip = this.srcManifest.containsKey(name);
                    if (!skip) {
                        if (this.zipManifest.containsKey(name) && freshen) {
                            FileToZip file = this.zipManifest.get(name);
                            long zipDate = entry.getTime();
                            long lastMod = file.getLastModified();
                            boolean bl = skip = lastMod > zipDate;
                            if (!skip) {
                                this.zipManifest.remove(name);
                            }
                        } else if (this.zipManifest.containsKey(name)) {
                            skip = true;
                        }
                    }
                    if (skip) continue;
                    outZip.putNextEntry(entry);
                    InputStream stream = inZip.getInputStream(entry);
                    int read = stream.read(buffer, 0, 8192);
                    while (read >= 0) {
                        outZip.write(buffer, 0, read);
                        read = stream.read(buffer, 0, 8192);
                    }
                    stream.close();
                    outZip.closeEntry();
                }
            }
            CRC32 crc = new CRC32();
            for (String name : this.zipManifest.keySet()) {
                int read;
                InputStream stream;
                URLConnection connection;
                FileToZip file = this.zipManifest.get(name);
                ZipEntry ze = new ZipEntry(name);
                if (file.getComment() != null) {
                    ze.setComment(file.getComment());
                }
                ze.setMethod(file.getMethod());
                outZip.setLevel(file.getLevel());
                URI uri = this.zipManifest.get(name).getHref();
                String href = uri.toASCIIString();
                if (ze.getMethod() == 0) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.srcManifest.containsKey(uri.toString())) {
                        XdmNode doc = this.srcManifest.get(href);
                        Serializer serializer = this.makeSerializer(file.getOptions());
                        serializer.setOutputStream(baos);
                        S9apiUtils.serialize(this.runtime, doc, serializer);
                    } else {
                        connection = uri.toURL().openConnection();
                        stream = connection.getInputStream();
                        read = stream.read(buffer, 0, 8192);
                        while (read > 0) {
                            baos.write(buffer, 0, read);
                            read = stream.read(buffer, 0, 8192);
                        }
                        stream.close();
                    }
                    byte[] bytes = baos.toByteArray();
                    ze.setSize(bytes.length);
                    crc.reset();
                    crc.update(bytes);
                    ze.setCrc(crc.getValue());
                }
                outZip.putNextEntry(ze);
                if (this.srcManifest.containsKey(href)) {
                    XdmNode doc = this.srcManifest.get(href);
                    Serializer serializer = this.makeSerializer(file.getOptions());
                    serializer.setOutputStream(outZip);
                    S9apiUtils.serialize(this.runtime, doc, serializer);
                } else {
                    URL url = uri.toURL();
                    connection = url.openConnection();
                    stream = connection.getInputStream();
                    read = stream.read(buffer, 0, 8192);
                    while (read >= 0) {
                        outZip.write(buffer, 0, read);
                        read = stream.read(buffer, 0, 8192);
                    }
                    stream.close();
                }
                outZip.closeEntry();
            }
            outZip.close();
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
    }

    public void delete(ZipFile inZip, ZipOutputStream outZip) {
        try {
            if (inZip != null) {
                Enumeration<? extends ZipEntry> zenum = inZip.entries();
                while (zenum.hasMoreElements()) {
                    ZipEntry entry = zenum.nextElement();
                    String name = entry.getName();
                    boolean delete = false;
                    if (this.zipManifest.containsKey(name)) {
                        delete = true;
                    }
                    if (delete) continue;
                    outZip.putNextEntry(entry);
                    InputStream stream = inZip.getInputStream(entry);
                    byte[] buffer = new byte[8192];
                    int read = stream.read(buffer, 0, 8192);
                    while (read >= 0) {
                        outZip.write(buffer, 0, read);
                        read = stream.read(buffer, 0, 8192);
                    }
                    stream.close();
                    outZip.closeEntry();
                }
            }
            outZip.close();
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }

    public Serializer makeSerializer(Hashtable<QName, String> options) {
        String list;
        Serializer serializer = new Serializer();
        if (options == null) {
            return serializer;
        }
        if (options.containsKey(_byte_order_mark)) {
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, "false".equals(options.get(_byte_order_mark)) ? "yes" : "no");
        }
        if (options.containsKey(_cdata_section_elements) && !"".equals(list = options.get(_cdata_section_elements))) {
            String[] names = list.split("\\s+");
            list = "";
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                QName q = new QName(name, this.step.getNode());
                list = String.valueOf(list) + q.getClarkName() + " ";
                ++n2;
            }
            serializer.setOutputProperty(Serializer.Property.CDATA_SECTION_ELEMENTS, list);
        }
        if (options.containsKey(_doctype_public)) {
            serializer.setOutputProperty(Serializer.Property.DOCTYPE_PUBLIC, options.get(_doctype_public));
        }
        if (options.containsKey(_doctype_system)) {
            serializer.setOutputProperty(Serializer.Property.DOCTYPE_SYSTEM, options.get(_doctype_system));
        }
        if (options.containsKey(_encoding)) {
            serializer.setOutputProperty(Serializer.Property.ENCODING, options.get(_encoding));
        }
        if (options.containsKey(_escape_uri_attributes)) {
            serializer.setOutputProperty(Serializer.Property.ESCAPE_URI_ATTRIBUTES, "true".equals(options.get(_escape_uri_attributes)) ? "yes" : "no");
        }
        if (options.containsKey(_include_content_type)) {
            serializer.setOutputProperty(Serializer.Property.INCLUDE_CONTENT_TYPE, "true".equals(options.get(_include_content_type)) ? "yes" : "no");
        }
        if (options.containsKey(_indent)) {
            serializer.setOutputProperty(Serializer.Property.INDENT, "true".equals(options.get(_indent)) ? "yes" : "no");
        }
        if (options.containsKey(_media_type)) {
            serializer.setOutputProperty(Serializer.Property.MEDIA_TYPE, options.get(_media_type));
        }
        if (options.containsKey(_method)) {
            serializer.setOutputProperty(Serializer.Property.METHOD, options.get(_method));
        }
        if (options.containsKey(_normalization_form)) {
            serializer.setOutputProperty(Serializer.Property.NORMALIZATION_FORM, options.get(_normalization_form));
        }
        if (options.containsKey(_omit_xml_declaration)) {
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "true".equals(options.get(_omit_xml_declaration)) ? "yes" : "no");
        }
        if (options.containsKey(_standalone)) {
            String standalone = options.get(_standalone);
            if ("true".equals(standalone)) {
                serializer.setOutputProperty(Serializer.Property.STANDALONE, "yes");
            } else if ("false".equals(standalone)) {
                serializer.setOutputProperty(Serializer.Property.STANDALONE, "no");
            }
        }
        if (options.containsKey(_undeclare_prefixes)) {
            serializer.setOutputProperty(Serializer.Property.UNDECLARE_PREFIXES, "true".equals(options.get(_undeclare_prefixes)) ? "yes" : "no");
        }
        if (options.containsKey(_version)) {
            serializer.setOutputProperty(Serializer.Property.VERSION, options.get(_version));
        }
        return serializer;
    }

    private class FileToZip {
        private String zipName = null;
        private URI href = null;
        private String origHref = null;
        private int method = -1;
        private int level = -1;
        private String comment = null;
        private long lastModified = -1L;
        private Hashtable<QName, String> options = null;

        public FileToZip(String zipName, String href, int method, int level, String comment, XdmNode entry) {
            try {
                this.origHref = href;
                this.zipName = zipName;
                this.href = new URI(href);
                this.method = method;
                this.level = level;
                this.comment = comment;
                this.lastModified = this.readLastModified(this.href);
                QName[] qNameArray = serializerAttrs;
                int n = qNameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    QName attr = qNameArray[n2];
                    String value = entry.getAttributeValue(attr);
                    if (value != null) {
                        if (this.options == null) {
                            this.options = new Hashtable();
                        }
                        this.options.put(attr, value);
                    }
                    ++n2;
                }
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
        }

        public String getName() {
            return this.zipName;
        }

        public URI getHref() {
            return this.href;
        }

        public int getMethod() {
            return this.method;
        }

        public int getLevel() {
            return this.level;
        }

        public String getComment() {
            return this.comment;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public Hashtable<QName, String> getOptions() {
            return this.options;
        }

        private long readLastModified(URI uri) {
            if (Zip.this.srcManifest.containsKey(this.origHref)) {
                Date date = new Date();
                return date.getTime();
            }
            if (uri.getScheme().equals("file")) {
                String fn = uri.toASCIIString();
                if (fn.startsWith("file:") && (fn = fn.substring(5)).startsWith("///")) {
                    fn = fn.substring(2);
                }
                File f = new File(fn);
                return f.lastModified();
            }
            HttpRequest httpReq = new HttpRequest(Zip.this.runtime, Zip.this.step);
            Pipe inputPipe = new Pipe(Zip.this.runtime);
            Pipe outputPipe = new Pipe(Zip.this.runtime);
            httpReq.setInput("source", inputPipe);
            httpReq.setOutput("result", outputPipe);
            TreeWriter req = new TreeWriter(Zip.this.runtime);
            req.startDocument(Zip.this.step.getNode().getBaseURI());
            req.addStartElement(XProcConstants.c_request);
            req.addAttribute(_method, "HEAD");
            req.addAttribute(_href, uri.toASCIIString());
            req.addAttribute(_status_only, "true");
            req.addAttribute(_detailed, "true");
            req.startContent();
            req.addEndElement();
            req.endDocument();
            inputPipe.write(req.getResult());
            try {
                httpReq.run();
            }
            catch (SaxonApiException sae) {
                throw new XProcException(sae);
            }
            XdmNode result = S9apiUtils.getDocumentElement(outputPipe.read());
            int status = Integer.parseInt(result.getAttributeValue(_status));
            if (status == 200) {
                for (XdmNode node : new RelevantNodes(Zip.this.runtime, result, Axis.CHILD)) {
                    if (!"Last-Modified".equals(node.getAttributeValue(_name))) continue;
                    String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
                    String dateStr = node.getAttributeValue(_value);
                    int day = Integer.parseInt(dateStr.substring(5, 7));
                    String monthStr = dateStr.substring(8, 11).toUpperCase();
                    int year = Integer.parseInt(dateStr.substring(12, 16));
                    int hour = Integer.parseInt(dateStr.substring(17, 19));
                    int min = Integer.parseInt(dateStr.substring(20, 22));
                    int sec = Integer.parseInt(dateStr.substring(23, 25));
                    String tzStr = dateStr.substring(26, 29);
                    int month = 0;
                    month = 0;
                    while (month < 12) {
                        if (months[month].equals(monthStr)) break;
                        ++month;
                    }
                    GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    cal.set(year, month, day, hour, min, sec);
                    return cal.getTimeInMillis();
                }
                return -1L;
            }
            return -1L;
        }
    }
}

