/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class Copy
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _target = new QName("target");
    private static final QName _fail_on_error = new QName("fail-on-error");
    private static final int bufsize = 8192;
    private WritablePipe result = null;

    public Copy(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        boolean failOnError = this.getOption(_fail_on_error, true);
        RuntimeValue href = this.getOption(_href);
        URI uri = href.getBaseURI().resolve(href.getString());
        if (!"file".equals(uri.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the copy step.");
        }
        File file = new File(uri.getPath());
        if (!file.exists()) {
            throw new XProcException(this.step.getNode(), "Cannot copy: file does not exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new XProcException(this.step.getNode(), "Cannot copy: file is a directory: " + file.getAbsolutePath());
        }
        href = this.getOption(_target);
        uri = href.getBaseURI().resolve(href.getString());
        if (!"file".equals(uri.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the copy step.");
        }
        File target = new File(uri.getPath());
        if (target.isDirectory() && (target = new File(target, file.getName())).isDirectory()) {
            throw new XProcException(this.step.getNode(), "Cannot copy: target is a directory: " + target.getAbsolutePath());
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        tree.addText(target.toURI().toASCIIString());
        try {
            FileInputStream src = new FileInputStream(file);
            FileOutputStream dst = new FileOutputStream(target);
            byte[] buffer = new byte[8192];
            int read = src.read(buffer, 0, 8192);
            while (read >= 0) {
                dst.write(buffer, 0, read);
                read = src.read(buffer, 0, 8192);
            }
            src.close();
            dst.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new XProcException(fnfe);
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

