/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.library.HttpRequest;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.net.URI;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class Info
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _method = new QName("method");
    private static final QName _status_only = new QName("status-only");
    private static final QName _detailed = new QName("detailed");
    private static final QName _status = new QName("status");
    private static final QName _name = new QName("name");
    private static final QName _value = new QName("value");
    private static final QName _username = new QName("username");
    private static final QName _password = new QName("password");
    private static final QName _auth_method = new QName("auth_method");
    private static final QName _send_authorization = new QName("send-authorization");
    private static final QName _fail_on_error = new QName("fail-on-error");
    protected static final QName c_uri = new QName("c", "http://www.w3.org/ns/xproc-step", "uri");
    protected static final QName c_directory = new QName("c", "http://www.w3.org/ns/xproc-step", "directory");
    protected static final QName c_file = new QName("c", "http://www.w3.org/ns/xproc-step", "file");
    protected static final QName c_other = new QName("c", "http://www.w3.org/ns/xproc-step", "other");
    protected static final QName c_error = new QName("c", "http://www.w3.org/ns/xproc-step", "error");
    protected static final QName err_fu01 = new QName("err", "http://www.w3.org/ns/xproc-error", "FU01");
    private static final QName _uri = new QName("uri");
    private static final QName _readable = new QName("readable");
    private static final QName _writable = new QName("writable");
    private static final QName _exists = new QName("exists");
    private static final QName _hidden = new QName("hidden");
    private static final QName _last_modified = new QName("last-modified");
    private static final QName _size = new QName("size");
    private WritablePipe result = null;

    public Info(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue href = this.getOption(_href);
        URI uri = href.getBaseURI().resolve(href.getString());
        boolean failOnError = this.getOption(_fail_on_error, true);
        this.finest(this.step.getNode(), "Checking info for " + uri);
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        if ("file".equals(uri.getScheme())) {
            File file = new File(uri.getPath());
            if (!file.exists()) {
                if (failOnError) {
                    throw new XProcException(err_fu01);
                }
                tree.addStartElement(c_error);
                tree.addText("File not found");
                tree.addEndElement();
                tree.endDocument();
                this.result.write(tree.getResult());
                return;
            }
            if (file.isDirectory()) {
                tree.addStartElement(c_directory);
            } else if (file.isFile()) {
                tree.addStartElement(c_file);
            } else {
                tree.addStartElement(c_other);
            }
            tree.addAttribute(_href, uri.toASCIIString());
            if (file.canRead()) {
                tree.addAttribute(_readable, "true");
            }
            if (file.canWrite()) {
                tree.addAttribute(_writable, "true");
            }
            if (file.isHidden()) {
                tree.addAttribute(_hidden, "true");
            }
            tree.addAttribute(_size, "" + file.length());
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(file.lastModified());
            TimeZone tz = TimeZone.getDefault();
            long gmt = file.lastModified() - (long)tz.getRawOffset();
            if (tz.useDaylightTime() && tz.inDaylightTime(cal.getTime())) {
                gmt -= (long)tz.getDSTSavings();
            }
            cal.setTimeInMillis(gmt);
            tree.addAttribute(_last_modified, String.format("%1$04d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02dZ", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13)));
            tree.startContent();
            tree.addEndElement();
        } else {
            tree.addStartElement(c_uri);
            HttpRequest httpReq = new HttpRequest(this.runtime, this.step);
            Pipe inputPipe = new Pipe(this.runtime);
            Pipe outputPipe = new Pipe(this.runtime);
            httpReq.setInput("source", inputPipe);
            httpReq.setOutput("result", outputPipe);
            TreeWriter req = new TreeWriter(this.runtime);
            req.startDocument(this.step.getNode().getBaseURI());
            req.addStartElement(XProcConstants.c_request);
            req.addAttribute(_method, "HEAD");
            req.addAttribute(_href, uri.toASCIIString());
            req.addAttribute(_status_only, "true");
            req.addAttribute(_detailed, "true");
            QName[] qNameArray = new QName[]{_username, _password, _auth_method, _send_authorization};
            int n = qNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                QName name = qNameArray[n2];
                RuntimeValue v = this.getOption(name);
                if (v != null) {
                    req.addAttribute(name, v.getString());
                }
                ++n2;
            }
            req.startContent();
            req.addEndElement();
            req.endDocument();
            inputPipe.write(req.getResult());
            httpReq.run();
            XdmNode result = S9apiUtils.getDocumentElement(outputPipe.read());
            int status = Integer.parseInt(result.getAttributeValue(_status));
            tree.addAttribute(_href, href.getString());
            tree.addAttribute(_status, "" + status);
            tree.addAttribute(_readable, status >= 200 && status < 400 ? "true" : "false");
            tree.addAttribute(_exists, status >= 400 && status < 500 ? "false" : "true");
            tree.addAttribute(_uri, uri.toASCIIString());
            for (XdmNode node : new RelevantNodes(this.runtime, result, Axis.CHILD)) {
                if ("Last-Modified".equals(node.getAttributeValue(_name))) {
                    String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
                    String dateStr = node.getAttributeValue(_value);
                    String dayStr = dateStr.substring(5, 7);
                    String monthStr = dateStr.substring(8, 11).toUpperCase();
                    String yearStr = dateStr.substring(12, 16);
                    String timeStr = dateStr.substring(17, 25);
                    String tzStr = dateStr.substring(26, 29);
                    int month = 0;
                    month = 0;
                    while (month < 12) {
                        if (months[month].equals(monthStr)) break;
                        ++month;
                    }
                    tree.addAttribute(_last_modified, String.format("%1$04d-%2$02d-%3$02dT%4$s%5$s", Integer.parseInt(yearStr), month + 1, Integer.parseInt(dayStr), timeStr, "GMT".equals(tzStr) ? "Z" : ""));
                }
                if (!"Content-Length".equals(node.getAttributeValue(_name))) continue;
                tree.addAttribute(_size, node.getAttributeValue(_value));
            }
            tree.startContent();
            for (XdmNode node : new RelevantNodes(this.runtime, result, Axis.CHILD)) {
                tree.addSubtree(node);
            }
            tree.addEndElement();
        }
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

