/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.SequenceType;

public class ResolveURI
extends XProcExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", "http://www.w3.org/ns/xproc", "resolve-uri");

    protected ResolveURI() {
    }

    public ResolveURI(XProcRuntime runtime) {
        this.tl_runtime.set(runtime);
    }

    @Override
    public StructuredQName getFunctionQName() {
        return funcname;
    }

    @Override
    public int getMinimumNumberOfArguments() {
        return 1;
    }

    @Override
    public int getMaximumNumberOfArguments() {
        return 2;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.OPTIONAL_STRING};
    }

    @Override
    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ATOMIC;
    }

    @Override
    public boolean dependsOnFocus() {
        return true;
    }

    @Override
    public ExtensionFunctionCall makeCallExpression() {
        return new ResolveURICall();
    }

    private class ResolveURICall
    extends ExtensionFunctionCall {
        private ResolveURICall() {
        }

        @Override
        public Sequence call(XPathContext xPathContext, Sequence[] sequences) throws XPathException {
            String relativeURI = sequences[0].head().getStringValue();
            XProcRuntime runtime = (XProcRuntime)ResolveURI.this.tl_runtime.get();
            XStep step = runtime.getXProcData().getStep();
            if (step != null && !(step instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            String baseURI = null;
            if (sequences.length > 1) {
                baseURI = sequences[1].head().getStringValue();
            } else {
                baseURI = runtime.getStaticBaseURI().toASCIIString();
                try {
                    Item item = xPathContext.getContextItem();
                    baseURI = ((TinyDocumentImpl)item).getBaseURI();
                }
                catch (Exception item) {
                    // empty catch block
                }
            }
            try {
                URI abs = net.sf.saxon.functions.ResolveURI.makeAbsolute(relativeURI, baseURI);
                String resolvedURI = abs.toASCIIString();
                return new AnyURIValue(resolvedURI);
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
        }
    }
}

