/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class Error
extends DefaultStep {
    private static final QName c_error = new QName("c", "http://www.w3.org/ns/xproc-step", "error");
    private static final QName _name = new QName("name");
    private static final QName _code = new QName("code");
    private static final QName _code_prefix = new QName("code-prefix");
    private static final QName _code_namespace = new QName("code-namespace");
    private static final QName _type = new QName("type");
    private ReadablePipe source = null;

    public Error(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
    }

    @Override
    public void reset() {
        this.source.resetReader();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode doc = this.source.read();
        this.finest(null, "Error step ??? read " + doc.getDocumentURI());
        RuntimeValue codeNameValue = this.getOption(_code);
        String codeNameStr = codeNameValue.getString();
        String cpfx = this.getOption(_code_prefix, (String)null);
        String cns = this.getOption(_code_namespace, (String)null);
        if (cpfx == null && cns != null) {
            cpfx = "ERR";
        }
        if (cpfx != null && cns == null) {
            throw XProcException.dynamicError(34, "You can't specify a prefix without a namespace");
        }
        if (cns != null && codeNameStr.contains(":")) {
            throw XProcException.dynamicError(34, "You can't specify a namespace if the code name contains a colon");
        }
        QName errorCode = null;
        errorCode = codeNameStr.contains(":") ? new QName(codeNameStr, codeNameValue.getNode()) : new QName(cpfx == null ? "" : cpfx, cns, codeNameStr);
        cpfx = errorCode.getPrefix();
        cns = errorCode.getNamespaceURI();
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(c_error);
        treeWriter.addNamespace(cpfx, cns);
        treeWriter.addAttribute(_name, this.step.getName());
        treeWriter.addAttribute(_type, "p:error");
        treeWriter.addAttribute(_code, errorCode.toString());
        treeWriter.startContent();
        treeWriter.addSubtree(doc);
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.step.reportError(treeWriter.getResult());
        throw new XProcException(errorCode, doc, doc.getStringValue());
    }
}

