/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class WWWFormURLEncode
extends DefaultStep
implements ProcessMatchingNodes {
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Vector<Tuple> params = new Vector();
    private static final QName _match = new QName("", "match");
    private ProcessMatch matcher = null;
    private String encoded = "";

    public WWWFormURLEncode(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        int pos = -1;
        int count = -1;
        for (Tuple t : this.params) {
            ++count;
            if (!name.equals(t.name)) continue;
            pos = count;
        }
        if (pos >= 0) {
            this.params.remove(pos);
        }
        this.params.add(new Tuple(name, value));
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        for (Tuple t : this.params) {
            if (!"".equals(this.encoded)) {
                this.encoded = String.valueOf(this.encoded) + "&";
            }
            this.encoded = String.valueOf(this.encoded) + t.name.getLocalName() + "=" + this.encode(t.value.getString());
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        this.matcher.addText(this.encoded);
        return false;
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        this.matcher.addText(this.encoded);
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        this.matcher.addComment(this.encoded);
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        this.matcher.addPI(node.getNodeName().getLocalName(), this.encoded);
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        this.matcher.addAttribute(node.getNodeName(), this.encoded);
    }

    private String encode(String src) {
        String genDelims = ":/?#[]@";
        String subDelims = "!$'()*+,;=";
        String unreserved = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
        String okChars = String.valueOf(genDelims) + subDelims + unreserved;
        String encoded = "";
        try {
            byte[] bytes = src.getBytes("UTF-8");
            int pos = 0;
            while (pos < bytes.length) {
                encoded = okChars.indexOf(bytes[pos]) >= 0 ? String.valueOf(encoded) + (char)bytes[pos] : String.valueOf(encoded) + String.format("%%%02X", bytes[pos]);
                ++pos;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }

    private class Tuple {
        public QName name;
        public RuntimeValue value;

        public Tuple(QName name, RuntimeValue value) {
            this.name = name;
            this.value = value;
        }
    }
}

