/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcRuntime;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public abstract class SourceArtifact {
    protected XdmNode node = null;
    protected XProcRuntime runtime = null;
    protected Hashtable<QName, String> extnAttrs = null;
    protected Logger logger = null;

    public SourceArtifact(XProcRuntime runtime, XdmNode node) {
        this.runtime = runtime;
        this.node = node;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public XProcRuntime getXProc() {
        return this.runtime;
    }

    public XdmNode getNode() {
        return this.node;
    }

    public String xplFile() {
        if (this.node == null) {
            return "";
        }
        if (this.node.getDocumentURI() == null) {
            return "";
        }
        return this.node.getDocumentURI().toASCIIString();
    }

    public int xplLine() {
        if (this.node == null) {
            return -1;
        }
        return this.node.getLineNumber();
    }

    public void addExtensionAttribute(XdmNode attr) {
        if (this.extnAttrs == null) {
            this.extnAttrs = new Hashtable();
        }
        this.extnAttrs.put(attr.getNodeName(), attr.getStringValue());
    }

    public String getExtensionAttribute(QName name) {
        if (this.extnAttrs == null || !this.extnAttrs.containsKey(name)) {
            return null;
        }
        return this.extnAttrs.get(name);
    }

    public Set<QName> getExtensionAttributes() {
        if (this.extnAttrs == null) {
            this.extnAttrs = new Hashtable();
        }
        return this.extnAttrs.keySet();
    }

    public void error(String message, QName code) {
        this.runtime.error(null, this.node, message, code);
    }

    public void error(XdmNode node, String message, QName code) {
        this.runtime.error(null, node, message, code);
    }
}

