/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XRootStep;
import java.util.HashSet;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class XPipelineCall
extends XAtomicStep {
    private DeclareStep decl = null;

    public XPipelineCall(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
        this.parent = parent;
    }

    public void setDeclaration(DeclareStep decl) {
        this.decl = decl;
    }

    @Override
    public XCompoundStep getParent() {
        return this.parent;
    }

    @Override
    public void run() throws SaxonApiException {
        RuntimeValue value;
        this.fine(null, "Running " + this.step.getType());
        this.decl.setup();
        if (this.runtime.getErrorCode() != null) {
            throw new XProcException(this.runtime.getErrorCode(), this.runtime.getErrorMessage());
        }
        XRootStep root = new XRootStep(this.runtime);
        XPipeline newstep = new XPipeline(this.runtime, this.decl, root);
        newstep.instantiate(this.decl);
        this.inScopeOptions = this.parent.getInScopeOptions();
        HashSet<QName> pipeOpts = new HashSet<QName>();
        for (QName name : newstep.step.getOptions()) {
            pipeOpts.add(name);
        }
        for (QName name : this.step.getOptions()) {
            Option option = this.step.getOption(name);
            value = this.computeValue(option);
            this.setOption(name, value);
            if (pipeOpts.contains(name)) {
                newstep.passOption(name, value);
            }
            this.inScopeOptions.put(name, value);
        }
        for (QName name : this.step.getParameters()) {
            Parameter param = this.step.getParameter(name);
            value = this.computeValue(param);
            newstep.setParameter(name, value);
        }
        for (String port : this.inputs.keySet()) {
            if (port.startsWith("|")) continue;
            newstep.inputs.put(port, (Vector)this.inputs.get(port));
        }
        for (String port : this.outputs.keySet()) {
            if (port.endsWith("|")) continue;
            newstep.outputs.put(port, (WritablePipe)this.outputs.get(port));
        }
        newstep.run();
    }
}

