/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.io.Encoding;
import nu.validator.htmlparser.io.HtmlInputStreamReader;
import nu.validator.htmlparser.test.SystemErrErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class DecoderLoopTester {
    private static final int LEAD_OFFSET = 55232;
    private static final int NUMBER_OR_ASTRAL_CHARS = 24500;

    private void runTest(int padding) throws SAXException, IOException {
        Encoding utf8 = Encoding.forName("UTF-8");
        char[] charArr = new char[1 + padding + 49000];
        int i = 0;
        charArr[i++] = 65279;
        int j = 0;
        while (j < padding) {
            charArr[i++] = 120;
            ++j;
        }
        j = 0;
        while (j < 24500) {
            int value = 65536 + j;
            charArr[i++] = (char)(55232 + (value >> 10));
            charArr[i++] = (char)(56320 + (value & 0x3FF));
            ++j;
        }
        CharBuffer charBuffer = CharBuffer.wrap(charArr);
        CharsetEncoder enc = utf8.newEncoder();
        enc.onMalformedInput(CodingErrorAction.REPORT);
        enc.onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer byteBuffer = enc.encode(charBuffer);
        byte[] byteArr = new byte[byteBuffer.limit()];
        byteBuffer.get(byteArr);
        SystemErrErrorHandler eh = new SystemErrErrorHandler();
        this.compare(new HtmlInputStreamReader((InputStream)new ByteArrayInputStream(byteArr), (ErrorHandler)eh, null, null, Heuristics.NONE), padding, charArr, byteArr);
        this.compare(new HtmlInputStreamReader((InputStream)new ByteArrayInputStream(byteArr), (ErrorHandler)eh, null, null, utf8), padding, charArr, byteArr);
    }

    private void compare(HtmlInputStreamReader reader, int padding, char[] charArr, byte[] byteArr) throws SAXException, IOException {
        char[] readBuffer = new char[2048];
        int offset = 0;
        int num = 0;
        int readNum = 0;
        while ((num = reader.read(readBuffer)) != -1) {
            int j = 0;
            while (j < num) {
                System.out.println(offset + j);
                if (readBuffer[j] != charArr[offset + j]) {
                    throw new RuntimeException("Test failed. Char: " + Integer.toHexString(readBuffer[j]) + " j: " + j + " readNum: " + readNum);
                }
                ++j;
            }
            offset += num;
            ++readNum;
        }
    }

    void runTests() throws SAXException, IOException {
        int i = 0;
        while (i < 4) {
            this.runTest(i);
            ++i;
        }
    }

    public static void main(String[] args) throws IOException, SAXException {
        new DecoderLoopTester().runTests();
    }
}

