/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xmlresolver.Catalog;

public class Configuration {
    private final Properties properties;
    private final URL propertiesFileUri;

    private static boolean isTrue(String aString) {
        return "true".equalsIgnoreCase(aString) || "yes".equalsIgnoreCase(aString) || "1".equalsIgnoreCase(aString);
    }

    public static Configuration create(String aPropertiesFiles) {
        if (aPropertiesFiles != null) {
            for (String fn : aPropertiesFiles.split(";")) {
                URL url;
                if ("".equals(fn) || (url = Catalog.class.getResource("/" + fn)) == null) continue;
                InputStream in = Catalog.class.getResourceAsStream("/" + fn);
                if (in == null) {
                    Catalog.logger.warning("Cannot find " + fn);
                    continue;
                }
                Properties properties = new Properties();
                try {
                    properties.load(in);
                    return new Configuration(properties, url);
                }
                catch (IOException e) {
                    Catalog.logger.warning("I/O error reading " + fn);
                }
            }
        }
        return new Configuration(null, null);
    }

    public Configuration(Properties properties, URL propertiesFileUri) {
        this.properties = properties;
        this.propertiesFileUri = propertiesFileUri;
    }

    private String getProperty(String aPropertyName) {
        return this.properties != null ? this.properties.getProperty(aPropertyName) : null;
    }

    private String getProperty(String aSystemPropertyName, String aPropertyName) {
        String res = System.getProperty(aSystemPropertyName);
        return res != null ? res : this.getProperty(aPropertyName);
    }

    public Vector<String> queryCatalogFiles() {
        String catalogList = System.getProperty("xml.catalog.files");
        boolean fromPropertiesFile = false;
        boolean relativeCatalogs = true;
        if (this.properties != null) {
            String allow;
            if (catalogList == null && (catalogList = this.properties.getProperty("catalogs")) != null) {
                fromPropertiesFile = true;
            }
            if ((allow = this.properties.getProperty("relative-catalogs")) != null) {
                relativeCatalogs = Configuration.isTrue(allow);
            }
        }
        if (catalogList == null) {
            catalogList = "./catalog.xml";
        }
        Vector<String> catalogFiles = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(catalogList, ";");
        while (tokens.hasMoreTokens()) {
            String catalogFile = tokens.nextToken();
            URL absURI = null;
            if (fromPropertiesFile && !relativeCatalogs) {
                try {
                    absURI = new URL(this.propertiesFileUri, catalogFile);
                    catalogFile = absURI.toString();
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
            }
            catalogFiles.add(catalogFile);
        }
        return catalogFiles;
    }

    public boolean queryPreferPublic() {
        String prefer = this.getProperty("xml.catalog.prefer", "prefer");
        return prefer == null || "public".equalsIgnoreCase(prefer);
    }

    public String queryCache() {
        String home;
        String cacheDir = this.getProperty("xml.catalog.cache", "cache");
        if (cacheDir == null && Configuration.isTrue(this.getProperty("xml.catalog.cacheUnderHome", "cacheUnderHome")) && (home = System.getProperty("user.home")) != null && !"".equals(home)) {
            String dir = home + "/.xmlresolver/cache";
            File fDir = new File(dir);
            if (!fDir.exists()) {
                fDir.mkdirs();
            }
            if (!fDir.exists() || !fDir.isDirectory()) {
                Catalog.logger.warning("Could not create default cache directory: " + dir);
            } else {
                cacheDir = dir;
            }
        }
        return cacheDir;
    }

    public boolean queryCacheSchemeURI(String scheme) {
        if (scheme == null) {
            return false;
        }
        String prop = this.getProperty("xml.catalog.cache." + scheme, "cache-" + scheme + "-uri");
        if (prop == null) {
            return !"file".equals(scheme);
        }
        return Configuration.isTrue(prop);
    }
}

