/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.staxParser;

import javax.xml.stream.Location;
import net.sqf.xmlUtils.staxParser.NodeInfo;
import net.sqf.xmlUtils.staxParser.PositionalXMLReader;
import org.w3c.dom.Element;

public class ElementInfo
extends NodeInfo {
    private Location innerStart;
    private Location innerEnd;
    private Location attrRegStart;
    private Location attrRegEnd;

    protected ElementInfo(Element node) {
        super(node);
        this.innerStart = PositionalXMLReader.getLocation(node, "nodeInnerLocationStart");
        this.innerEnd = PositionalXMLReader.getLocation(node, "nodeInnerLocationEnd");
        this.attrRegStart = PositionalXMLReader.getLocation(node, "attributeRegionLocationStart");
        this.attrRegEnd = PositionalXMLReader.getLocation(node, "attributeRegionLocationEnd");
    }

    public Location getInnerStart() {
        return this.innerStart;
    }

    public int getInnerStartOffset() {
        return this.innerStart.getCharacterOffset();
    }

    public Location getInnerEnd() {
        return this.innerEnd;
    }

    public int getInnerEndOffset() {
        return this.innerEnd.getCharacterOffset();
    }

    public Location getAttributRegionStart() {
        return this.attrRegStart;
    }

    public int getAttributRegionStartOffset() {
        return this.attrRegStart.getCharacterOffset();
    }

    public Location getAttributRegionEnd() {
        return this.attrRegEnd;
    }

    public int getAttributRegionEndOffset() {
        return this.attrRegEnd.getCharacterOffset();
    }

    public Location getLocation(String key) {
        return PositionalXMLReader.getLocation(this.getNode(), key);
    }

    public int getLocationOffset(String key) {
        return PositionalXMLReader.getLocation(this.getNode(), key).getCharacterOffset();
    }

    @Override
    public int getMarkEnd() {
        return this.getInnerStartOffset();
    }
}

