/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xmlUtils.staxParser;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import net.sqf.stringUtils.StringUtil;
import net.sqf.stringUtils.TextSource;
import net.sqf.xmlUtils.staxParser.ElementInfo;
import net.sqf.xmlUtils.staxParser.NodeInfo;
import net.sqf.xmlUtils.staxParser.PositionalStaxParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PositionalXMLReader {
    public static final String NODE_INNER_LOCATION_START = "nodeInnerLocationStart";
    public static final String NODE_INNER_LOCATION_END = "nodeInnerLocationEnd";
    public static final String NODE_LOCATION_START = "nodeLocationStart";
    public static final String NODE_LOCATION_END = "nodeLocationEnd";
    public static final String ATTRIBUTE_REGION_LOCATION_START = "attributeRegionLocationStart";
    public static final String ATTRIBUTE_REGION_LOCATION_END = "attributeRegionLocationEnd";
    public static final String DTD_LOCATION_START = "dtdLocationStart";
    public static final String DTD_LOCATION_END = "dtdLocationEnd";
    public static final String XML_DECL_LOCATION_START = "xmlDeclLocationStart";
    public static final String XML_DECL_LOCATION_END = "xmlDeclLocationEnd";
    public static final int STANDARD_TYPE = 0;
    public static final int ELEMENT_START_TYPE = 1;
    public static final int ELEMENT_END_TYPE = 2;
    public static final int ATTRIBUTE_TYPE = 3;
    public static final int TEXT_TYPE = 4;
    public static final int DTD_TYPE = 5;
    public static final int DTD_TYPE_END = 6;
    protected static final String ELEMENT_ID = "elementId";
    public static final String HAS_DTD = "hasDTD";
    public static final String NAMESPACE_CONTEXT = "namespaceContext";
    private final HashMap<Integer, Integer> linePositionMap = new HashMap();
    private int lineCounter = 0;
    private static final PositionalStaxParser woodStoxParser = PositionalXMLReader.initialParser();
    private boolean isWellformed = true;

    private static PositionalStaxParser initialParser() {
        return new PositionalStaxParser();
    }

    public static int getPosition(Node node, String userDataKey) {
        Location loc = (Location)node.getUserData(userDataKey);
        return loc.getCharacterOffset();
    }

    public static int getLine(Node node, String userDataKey) {
        Location loc = (Location)node.getUserData(userDataKey);
        return loc.getLineNumber();
    }

    private void positionMap(String doc) {
        String[] lines = StringUtil.getLinesArr(doc);
        int position = 0;
        int lineCount = 0;
        while (lineCount < lines.length) {
            this.linePositionMap.put(lineCount + 1, position);
            String line = lines[lineCount];
            position += line.length();
            ++lineCount;
        }
        this.lineCounter = lineCount;
    }

    public int getLineForPos(int pos) {
        int line = 0;
        while (line < this.lineCounter) {
            int linePos = this.linePositionMap.get(line + 1);
            if (!this.linePositionMap.containsKey(line + 2)) break;
            int lineNextPos = this.linePositionMap.get(line + 2);
            if (linePos <= pos && lineNextPos > pos) break;
            ++line;
        }
        return line;
    }

    public boolean isWellformed(TextSource source) {
        return this.isWellformed(source.toString());
    }

    public boolean isWellformed(String source) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.isWellformed = true;
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    PositionalXMLReader.this.isWellformed = false;
                }

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    PositionalXMLReader.this.isWellformed = false;
                }
            });
            docBuilder.parse(new InputSource(new StringReader(source)));
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        catch (SAXException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return this.isWellformed;
    }

    public Document readXML(File doc) throws IOException, SAXException, XMLStreamException {
        TextSource ts = TextSource.readTextFile(doc);
        return this.readXML(ts);
    }

    public Document readXML(TextSource source) throws IOException, SAXException, XMLStreamException {
        Document docNode;
        this.positionMap(source.toString());
        ArrayList allNodes = new ArrayList();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docNode = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Can't create SAX parser / DOM builder.", e);
        }
        woodStoxParser.parse(docNode, source);
        docNode.setUserData("allNodes", allNodes, null);
        return docNode;
    }

    public static Location getLocation(Node node, String key) {
        return (Location)node.getUserData(key);
    }

    public static NodeInfo getNodeInfo(Element node) {
        return new ElementInfo(node);
    }

    public static NodeInfo getNodeInfo(Node node) {
        if (node instanceof Element) {
            return PositionalXMLReader.getNodeInfo((Element)node);
        }
        return new NodeInfo(node);
    }

    public static ArrayList<NodeInfo> getNodeInfo(NodeList nodes) {
        ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>();
        int i = 0;
        while (i < nodes.getLength()) {
            nodeInfos.add(PositionalXMLReader.getNodeInfo(nodes.item(i)));
            ++i;
        }
        return nodeInfos;
    }
}

