/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.xsm.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathExpressionException;
import net.sqf.xmlUtils.staxParser.PositionalXMLReader;
import net.sqf.xmlUtils.xpath.XPathReader;
import net.sqf.xsm.operations.AddOp;
import net.sqf.xsm.operations.DeleteOp;
import net.sqf.xsm.operations.ReplaceOp;
import net.sqf.xsm.operations._Operation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OperationsSet
extends ArrayList<_Operation> {
    private static final long serialVersionUID = 2596362096996568212L;
    private static XPathReader xpr = new XPathReader();

    private ArrayList<_Operation> getWrapper(_Operation op) {
        ArrayList<_Operation> wrappers = new ArrayList<_Operation>();
        for (_Operation wrapper : this) {
            if (wrapper.getStart() < op.getStart() && wrapper.getEnd() > op.getEnd()) {
                wrappers.add(wrapper);
                continue;
            }
            if (wrapper.getStart() == wrapper.getEnd() && op.getStart() == op.getEnd() || wrapper.getStart() != op.getStart() || wrapper.getEnd() != op.getEnd() || wrapper.getPrio() <= op.getPrio()) continue;
            wrappers.add(wrapper);
        }
        return wrappers;
    }

    private ArrayList<_Operation> getIncludes(_Operation op) {
        ArrayList<_Operation> includes = new ArrayList<_Operation>();
        for (_Operation include : this) {
            if (include.getStart() > op.getStart() && include.getEnd() < op.getEnd()) {
                includes.add(include);
                continue;
            }
            if (include.getStart() == include.getEnd() && op.getStart() == op.getEnd() || include.getStart() != op.getStart() || include.getEnd() != op.getEnd() || op.getPrio() <= include.getPrio()) continue;
            includes.add(include);
        }
        return includes;
    }

    @Override
    public boolean add(_Operation op) {
        ArrayList<_Operation> wrapper = this.getWrapper(op);
        ArrayList<_Operation> includes = this.getIncludes(op);
        for (_Operation includeOp : includes) {
            this.remove(includeOp);
        }
        if (wrapper.size() > 0) {
            return false;
        }
        boolean ret = super.add(op);
        OperationsSet.sort(this);
        return ret;
    }

    public boolean addAll(OperationsSet c) {
        for (_Operation op : c) {
            this.add(op);
        }
        return true;
    }

    public static OperationsSet createOperations(Document sourceDoc, String replacerDocString, NodeList sheetNodes) throws XPathExpressionException, IOException, SAXException {
        OperationsSet ops = new OperationsSet();
        int i = 0;
        while (i < sheetNodes.getLength()) {
            ops.addAll(OperationsSet.createOperation(sourceDoc, replacerDocString, sheetNodes.item(i), i));
            ++i;
        }
        OperationsSet.sort(ops);
        return ops;
    }

    private static void sort(OperationsSet operations) {
        Collections.sort(operations, new Comparator<_Operation>(){

            @Override
            public int compare(_Operation o1, _Operation o2) {
                return o1.getStart() < o2.getStart() ? -1 : 1;
            }
        });
    }

    public static OperationsSet createOperation(Document sourceDoc, String sheetDocString, Node sheetNode, int prio) throws XPathExpressionException {
        NodeList sourceNodes;
        String xpath = sheetNode.getAttributes().getNamedItem("node").getNodeValue();
        NamespaceContext nsc = (NamespaceContext)sheetNode.getUserData("namespaceContext");
        try {
            sourceNodes = xpr.getNodeSet(xpath, sourceDoc, nsc);
        }
        catch (XPathExpressionException e) {
            int ln = PositionalXMLReader.getLine(sheetNode, "nodeLocationStart");
            throw new XPathExpressionException("XPath expression error in line " + ln + ": " + e.getMessage());
        }
        OperationsSet operations = new OperationsSet();
        if (xpr.getBoolean("self::xsm:delete", sheetNode)) {
            operations.addAll(OperationsSet.createDeleteOperations(sourceNodes, prio));
        } else if (xpr.getBoolean("self::xsm:replace", sheetNode)) {
            operations.addAll(OperationsSet.createReplaceOperations(sheetDocString, sourceNodes, sheetNode, prio));
        } else if (xpr.getBoolean("self::xsm:add", sheetNode)) {
            operations.addAll(OperationsSet.createAddeOperations(sheetDocString, sourceNodes, sheetNode, prio));
        }
        OperationsSet.sort(operations);
        return operations;
    }

    private static OperationsSet createDeleteOperations(NodeList sourceNodes, int prio) {
        OperationsSet operations = new OperationsSet();
        int i = 0;
        while (i < sourceNodes.getLength()) {
            operations.add(new DeleteOp(sourceNodes.item(i), prio));
            ++i;
        }
        return operations;
    }

    private static OperationsSet createReplaceOperations(String sheetDocString, NodeList sourceNodes, Node xsmReplace, int prio) throws XPathExpressionException {
        OperationsSet operations = new OperationsSet();
        Node contentNode = xpr.getNode("xsm:content", xsmReplace);
        int startCont = PositionalXMLReader.getPosition(contentNode, "nodeInnerLocationStart");
        int endCont = PositionalXMLReader.getPosition(contentNode, "nodeInnerLocationEnd");
        String replaceContString = sheetDocString.substring(startCont, endCont);
        int startAtr = PositionalXMLReader.getPosition(contentNode, "attributeRegionLocationStart");
        int endAtr = PositionalXMLReader.getPosition(contentNode, "attributeRegionLocationEnd");
        String replaceAttrString = sheetDocString.substring(startAtr, endAtr);
        int i = 0;
        while (i < sourceNodes.getLength()) {
            String replaceString = sourceNodes.item(i).getNodeType() == 2 ? replaceAttrString : replaceContString;
            operations.add(new ReplaceOp(sourceNodes.item(i), replaceString, prio));
            ++i;
        }
        return operations;
    }

    private static OperationsSet createAddeOperations(String sheetDocString, NodeList sourceNodes, Node xsmAdd, int prio) throws XPathExpressionException {
        OperationsSet operations = new OperationsSet();
        String position = xsmAdd.getAttributes().getNamedItem("position").getNodeValue();
        String addString = "";
        if (position.equals("attribute") || position.equals("@")) {
            Node xsmContent = xpr.getNode("xsm:content", xsmAdd);
            int start = PositionalXMLReader.getPosition(xsmContent, "attributeRegionLocationStart");
            int end = PositionalXMLReader.getPosition(xsmContent, "attributeRegionLocationEnd");
            addString = sheetDocString.substring(start, end);
            int i = 0;
            while (i < sourceNodes.getLength()) {
                NodeList addAttrList = xpr.getNodeSet("./@*", xsmContent);
                int j = 0;
                while (j < addAttrList.getLength()) {
                    String attrXpath = "@*[namespace-uri()='" + xpr.getString("namespace-uri()", addAttrList.item(j)) + "'][local-name()='" + xpr.getString("local-name()", addAttrList.item(j)) + "']";
                    Node attrToReplace = xpr.getNode(attrXpath, sourceNodes.item(i));
                    if (attrToReplace != null) {
                        operations.add(new DeleteOp(attrToReplace, prio));
                    }
                    ++j;
                }
                operations.add(new AddOp(sourceNodes.item(i), addString, position, prio));
                ++i;
            }
        } else {
            Node xsmContent = xpr.getNode("xsm:content", xsmAdd);
            int start = PositionalXMLReader.getPosition(xsmContent, "nodeInnerLocationStart");
            int end = PositionalXMLReader.getPosition(xsmContent, "nodeInnerLocationEnd");
            addString = sheetDocString.substring(start, end);
            int i = 0;
            while (i < sourceNodes.getLength()) {
                operations.add(new AddOp(sourceNodes.item(i), addString, position, prio));
                ++i;
            }
        }
        return operations;
    }
}

