<?xml version="1.0" encoding="UTF-8"?>
<!--  
    Copyright (c) 2014 Nico Kutscherauer
        
    This file is part of Escali Schematron.
    
    Escali Schematron is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Escali Schematron is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Escali Schematron.  If not, see http://www.gnu.org/licenses/gpl-3.0.

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:es="http://www.escali.schematron-quickfix.com/" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:bxsl="http://www.w3.org/1999/XSL/TransformAliasAlias" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" xmlns:xsm="http://www.schematron-quickfix.com/manipulator/process" exclude-result-prefixes="xs xd" version="2.0">

    <!--
    Implementation of sqf:DELETE
-->
    <xsl:template match="sqf:delete" mode="xsm:save-mode">
        <bxsl:variable name="sqf:node" select="es:getNodePath(.)"/>
        <bxsl:choose>
            <bxsl:when test=". instance of attribute()">
                <bxsl:variable name="sqf:parent" select="es:getNodePath(..)"/>
                <xsm:add position="before">
                    <bxsl:attribute name="node" select="$sqf:parent"/>
                    <xsm:content>
                        <bxsl:processing-instruction name="{$sqf:changePrefix}-start" sqf:changeMarker="true">
                            <bxsl:text>delete-</bxsl:text>
                            <bxsl:value-of select="generate-id()"/>
                        </bxsl:processing-instruction>
                    </xsm:content>
                </xsm:add>
                <xsm:add position="first-child">
                    <bxsl:attribute name="node" select="$sqf:parent"/>
                    <xsm:content>
                        <bxsl:processing-instruction name="{$sqf:changePrefix}-end" sqf:changeMarker="true">
                            <bxsl:text>delete-</bxsl:text>
                            <bxsl:value-of select="generate-id()"/>
                        </bxsl:processing-instruction>
                    </xsm:content>
                </xsm:add>
                <xsm:delete>
                    <bxsl:attribute name="node" select="$sqf:node"/>
                </xsm:delete>
            </bxsl:when>
            <bxsl:otherwise>
                <xsm:replace>
                    <bxsl:attribute name="node" select="$sqf:node"/>
                    <xsm:content>
                        <bxsl:processing-instruction name="{$sqf:changePrefix}-start" sqf:changeMarker="true">
                            <bxsl:text>delete-</bxsl:text>
                            <bxsl:value-of select="generate-id()"/>
                        </bxsl:processing-instruction>
                        <bxsl:processing-instruction name="{$sqf:changePrefix}-end" sqf:changeMarker="true">
                            <bxsl:text>delete-</bxsl:text>
                            <bxsl:value-of select="generate-id()"/>
                        </bxsl:processing-instruction>
                    </xsm:content>
                </xsm:replace>
            </bxsl:otherwise>
        </bxsl:choose>
    </xsl:template>

    <!--
        Implementation of sqf:REPLACE
    -->
    <xsl:template match="sqf:replace" mode="xsm:save-mode">
        <xsl:param name="fixId" tunnel="yes"/>
        <xsl:variable name="sqf:match" select="
                if (@match) then
                    (@match)
                else
                    ('self::node()')"/>
        <axsl:variable name="match">
            <xsl:call-template name="nodeMatching">
                <xsl:with-param name="nodes" select="$sqf:match"/>
            </xsl:call-template>
        </axsl:variable>
        <bxsl:variable name="sqf:nodeFac" as="node()*">
            <xsl:call-template name="nodeFac"/>
        </bxsl:variable>
        <bxsl:choose>
            <bxsl:when test="$sqf:nodeFac[. instance of attribute()]">
                <bxsl:variable name="sqf:nodeFac">
                    <xsm:replace>
                        <bxsl:attribute name="node" select="es:getNodePath(.)"/>
                        <xsm:content>
                            <bxsl:copy-of select="$sqf:nodeFac"/>
                        </xsm:content>
                    </xsm:replace>
                </bxsl:variable>
                <bxsl:if test="not(. instance of attribute())">
                    <bxsl:message terminate="yes">
                        <xsl:text>Only an attribute can replaced by an attribute!</xsl:text>
                        <xsl:text> (FixId: </xsl:text>
                        <xsl:value-of select="$fixId"/>
                        <xsl:text>, Context: </xsl:text>
                        <axsl:value-of select="es:getNodePath(.)"/>
                        <xsl:text>)</xsl:text>
                    </bxsl:message>
                </bxsl:if>
                <xsl:call-template name="xsm:addChangeMarker">
                    <xsl:with-param name="position" select="'attribute'"/>
                    <xsl:with-param name="variableName" select="'sqf:nodeFac'"/>
                </xsl:call-template>
            </bxsl:when>
            <bxsl:otherwise>
                <xsm:replace>
                    <bxsl:attribute name="node" select="es:getNodePath(.)"/>
                    <xsm:content>
                        <xsl:call-template name="xsm:addChangeMarker">
                            <xsl:with-param name="variableName" select="'sqf:nodeFac'"/>
                        </xsl:call-template>
                    </xsm:content>
                </xsm:replace>
            </bxsl:otherwise>
        </bxsl:choose>
        <!--<bxsl:if test="$sqf:nodeFac[. instance of attribute()">
            <bxsl:variable name="sqf:parent" select="es:getNodePath(..)"/>
            <xsm:add position="before">
                <bxsl:attribute name="node" select="$sqf:parent"/>
                <xsm:content>
                    <bxsl:processing-instruction name="{$sqf:changePrefix}-start" sqf:changeMarker="true">
                        <bxsl:text>attribute-change-</bxsl:text>
                        <bxsl:value-of select="generate-id()"/>
                    </bxsl:processing-instruction>
                </xsm:content>
            </xsm:add>
            <xsm:add position="first-child">
                <bxsl:attribute name="node" select="$sqf:parent"/>
                <xsm:content>
                    <bxsl:processing-instruction name="{$sqf:changePrefix}-end" sqf:changeMarker="true">
                        <bxsl:text>attribute-change-</bxsl:text>
                        <bxsl:value-of select="generate-id()"/>
                    </bxsl:processing-instruction>
                </xsm:content>
            </xsm:add>
            <axsl:if test="not(({$sqf:match}) instance of attribute())">
                <bxsl:message terminate="yes">
                    <xsl:text>Only an attribute can replaced by an attribute!</xsl:text>
                    <xsl:text> (FixId: </xsl:text>
                    <xsl:value-of select="$fixId"/>
                    <xsl:text>, Context: </xsl:text>
                    <axsl:value-of select="es:getNodePath(.)"/>
                    <xsl:text>)</xsl:text>
                </bxsl:message>
            </axsl:if>
        </bxsl:if>
        <xsm:replace>
            <bxsl:attribute name="node" select="es:getNodePath(.)"/>
            <xsm:content>
                <axsl:copy-of select="$nodeFac"/>
            </xsm:content>
        </xsm:replace>-->
    </xsl:template>
    <!--
        Implementation of sqf:STRINGREPLACE
    -->
    <xsl:template match="sqf:stringReplace" mode="xsm:save-mode">
        <xsm:replace>
            <bxsl:variable name="sqf:node" select="."/>
            <bxsl:attribute name="node" select="es:getNodePath($sqf:node)"/>
            <xsm:content>
                <bxsl:analyze-string select="." regex="{@regex}">
                    <bxsl:matching-substring>
                        <bxsl:variable name="sqf:nodeFac" as="node()*">
                            <xsl:apply-templates select="@select | node()" mode="template"/>
                        </bxsl:variable>
                        <xsl:call-template name="xsm:addChangeMarker">
                            <xsl:with-param name="variableName" select="'sqf:nodeFac'"/>
                            <xsl:with-param name="generate-id" select="'generate-id($sqf:node)'"/>
                        </xsl:call-template>
                    </bxsl:matching-substring>
                    <bxsl:non-matching-substring>
                        <bxsl:value-of select="."/>
                    </bxsl:non-matching-substring>
                </bxsl:analyze-string>
            </xsm:content>
        </xsm:replace>
    </xsl:template>
    <!--
        Implementation of sqf:ADD
    -->
    <xsl:template match="sqf:add" mode="xsm:save-mode">
        <xsm:add>
            <xsl:variable name="sqf:match" select="
                    if (@match) then
                        (@match)
                    else
                        ('self::node()')"/>
            <bxsl:variable name="sqf:position" select="'{@position}'"/>
            <bxsl:variable name="sqf:node-type" select="'{@node-type}'"/>

            <bxsl:variable name="sqf:nodeFac" as="node()*">
                <xsl:call-template name="nodeFac"/>
            </bxsl:variable>



            <bxsl:attribute name="position" select="
                        if ($sqf:position = '')
                        then
                        (
                            if ($sqf:node-type = 'attribute')
                            then
                            ('attribute')
                            else if ($sqf:node-type = ('keep') and (({$sqf:match})[1] instance of attribute()))
                            then
                                ('attribute')
                            else if ($sqf:node-type = '' and $sqf:nodeFac[1] instance of attribute())
                            then
                                ('attribute')
                            else
                            ('first-child')
                        )
                        else
                        if ($sqf:position = ('first-child',
                        'last-child'))
                        then
                        (
                        if (({$sqf:match})[1] instance of element() or ({$sqf:match})[1] instance of attribute())
                        then
                        ($sqf:position)
                        else
                        ('after')
                        )
                        else
                        ($sqf:position)"/>



            <bxsl:attribute name="node" select="
                    es:getNodePath(
                    if ((. instance of attribute()))
                    then
                        (..)
                    else
                        (.)
                    )"/>
            <xsm:content>
                <bxsl:if test="$sqf:nodeFac[. instance of attribute()]">
                    <bxsl:copy-of select="$sqf:nodeFac[. instance of attribute()]"/>
                </bxsl:if>
                <bxsl:if test="$sqf:nodeFac[not(. instance of attribute())]">
                    <xsl:call-template name="xsm:addChangeMarker">
                        <xsl:with-param name="position" select="@position"/>
                        <xsl:with-param name="variableName" select="'sqf:nodeFac'"/>
                    </xsl:call-template>
                </bxsl:if>
            </xsm:content>
        </xsm:add>
    </xsl:template>

    <xsl:template name="xsm:save-mode-add">
        <bxsl:variable name="sqf:addAttributes" select="($sqf:addChilds | $sqf:addLastChilds)[xsm:content/@*]"/>
        <bxsl:variable name="sqf:addChilds" select="$sqf:addChilds except $sqf:addAttributes"/>
        <bxsl:variable name="sqf:addLastChilds" select="$sqf:addLastChilds except $sqf:addAttributes"/>
        <bxsl:if test="$sqf:addAttributes and (. instance of element() or . instance of attribute())">
            <xsl:call-template name="xsm:addChangeMarker">
                <xsl:with-param name="position" select="'attribute'"/>
                <xsl:with-param name="variableName" select="'sqf:addAttributes'"/>
            </xsl:call-template>
        </bxsl:if>
        <bxsl:copy-of select="$sqf:addChilds | $sqf:addLastChilds"/>
        <bxsl:apply-templates select="@*" mode="#current"/>
        <bxsl:apply-templates select="node()" mode="#current"/>
    </xsl:template>

    <xsl:template name="xsm:addChangeMarker">
        <xsl:param name="position" select="'first-child'"/>
        <xsl:param name="variableName" required="yes"/>
        <xsl:param name="generate-id">generate-id()</xsl:param>
        <bxsl:variable name="startPi">
            <bxsl:processing-instruction name="{$sqf:changePrefix}-start" sqf:changeMarker="true">
                <bxsl:text>
                    <xsl:value-of select="
                            if ($position = 'attribute') then
                                ('attribute-change')
                            else
                                (local-name())"/>
                </bxsl:text>
                <bxsl:text>-</bxsl:text>
                <bxsl:value-of select="{$generate-id}"/>
            </bxsl:processing-instruction>
        </bxsl:variable>
        <bxsl:variable name="endPi">
            <bxsl:processing-instruction name="{$sqf:changePrefix}-end" sqf:changeMarker="true">
                <bxsl:text>
                    <xsl:value-of select="
                            if ($position = 'attribute') then
                                ('attribute-change')
                            else
                                (local-name())"/>
                </bxsl:text>
                <bxsl:text>-</bxsl:text>
                <bxsl:value-of select="{$generate-id}"/>
            </bxsl:processing-instruction>
        </bxsl:variable>
        <xsl:choose>
            <xsl:when test="$position = 'attribute'">
                <xsm:add position="before">
                    <bxsl:attribute name="node" select="
                            es:getNodePath(
                            if ((. instance of attribute()))
                            then
                                (..)
                            else
                                (.)
                            )"/>
                    <xsm:content>
                        <bxsl:copy-of select="$startPi"/>
                    </xsm:content>
                </xsm:add>
                <xsm:add position="first-child">
                    <bxsl:attribute name="node" select="
                            es:getNodePath(
                            if ((. instance of attribute()))
                            then
                                (..)
                            else
                                (.)
                            )"/>
                    <xsm:content>
                        <bxsl:copy-of select="$endPi"/>
                    </xsm:content>
                </xsm:add>
                <bxsl:copy-of select="${$variableName}"/>
            </xsl:when>
            <xsl:otherwise>
                <bxsl:copy-of select="$startPi"/>
                <bxsl:copy-of select="${$variableName}[not(. instance of attribute())]"/>
                <bxsl:copy-of select="$endPi"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
