/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.sf.saxon.s9api.QName;

public class XProcConstants {
    public static final String XPROC_VERSION = XProcConstants.initializeVersion();
    public static final String NS_XPROC = "http://www.w3.org/ns/xproc";
    public static final String NS_XPROC_ERROR = "http://www.w3.org/ns/xproc-error";
    public static final String NS_XPROC_ERROR_EX = "http://xproc.org/ns/errors";
    public static final String NS_XPROC_STEP = "http://www.w3.org/ns/xproc-step";
    public static final String NS_CALABASH_EX = "http://xmlcalabash.com/ns/extensions";
    public static final String NS_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_CALABASH_CONFIG = "http://xmlcalabash.com/ns/configuration";
    public static final String NS_EXPROC_CONFIG = "http://exproc.org/ns/configuration";
    public static final String NS_EXPROC_FUNCTIONS = "http://exproc.org/standard/functions";
    public static final String NS_ESCALI = "http://www.escali.schematron-quickfix.com/";
    public static final String CALABASH_EXTENSION_LIBRARY_1_0 = "http://xmlcalabash.com/extension/steps/library-1.0.xpl";
    public static final QName p_pipeline = new QName("http://www.w3.org/ns/xproc", "pipeline");
    public static final QName p_library = new QName("http://www.w3.org/ns/xproc", "library");
    public static final QName p_declare_step = new QName("http://www.w3.org/ns/xproc", "declare-step");
    public static final QName p_for_each = new QName("http://www.w3.org/ns/xproc", "for-each");
    public static final QName p_viewport = new QName("http://www.w3.org/ns/xproc", "viewport");
    public static final QName p_viewport_source = new QName("http://www.w3.org/ns/xproc", "viewport-source");
    public static final QName p_choose = new QName("http://www.w3.org/ns/xproc", "choose");
    public static final QName p_otherwise = new QName("http://www.w3.org/ns/xproc", "otherwise");
    public static final QName p_xpath_context = new QName("http://www.w3.org/ns/xproc", "xpath-context");
    public static final QName p_when = new QName("http://www.w3.org/ns/xproc", "when");
    public static final QName p_group = new QName("http://www.w3.org/ns/xproc", "group");
    public static final QName p_try = new QName("http://www.w3.org/ns/xproc", "try");
    public static final QName p_catch = new QName("http://www.w3.org/ns/xproc", "catch");
    public static final QName p_iteration_source = new QName("http://www.w3.org/ns/xproc", "iteration-source");
    public static final QName p_import = new QName("http://www.w3.org/ns/xproc", "import");
    public static final QName p_log = new QName("http://www.w3.org/ns/xproc", "log");
    public static final QName p_input = new QName("http://www.w3.org/ns/xproc", "input");
    public static final QName p_pipe = new QName("http://www.w3.org/ns/xproc", "pipe");
    public static final QName p_document = new QName("http://www.w3.org/ns/xproc", "document");
    public static final QName p_data = new QName("http://www.w3.org/ns/xproc", "data");
    public static final QName p_inline = new QName("http://www.w3.org/ns/xproc", "inline");
    public static final QName p_empty = new QName("http://www.w3.org/ns/xproc", "empty");
    public static final QName p_output = new QName("http://www.w3.org/ns/xproc", "output");
    public static final QName p_option = new QName("http://www.w3.org/ns/xproc", "option");
    public static final QName p_with_option = new QName("http://www.w3.org/ns/xproc", "with-option");
    public static final QName p_parameter = new QName("http://www.w3.org/ns/xproc", "parameter");
    public static final QName p_with_param = new QName("http://www.w3.org/ns/xproc", "with-param");
    public static final QName p_variable = new QName("http://www.w3.org/ns/xproc", "variable");
    public static final QName p_namespaces = new QName("http://www.w3.org/ns/xproc", "namespaces");
    public static final QName p_serialization = new QName("http://www.w3.org/ns/xproc", "serialization");
    public static final QName p_documentation = new QName("http://www.w3.org/ns/xproc", "documentation");
    public static final QName p_pipeinfo = new QName("http://www.w3.org/ns/xproc", "pipeinfo");
    public static final QName p_in_scope_names = new QName("http://www.w3.org/ns/xproc", "in-scope-names");
    public static final QName p_template = new QName("http://www.w3.org/ns/xproc", "template");
    public static final QName p_document_template = new QName("http://www.w3.org/ns/xproc", "document-template");
    public static final QName cx_until_unchanged = new QName("http://xmlcalabash.com/ns/extensions", "until-unchanged");
    public static final QName p_iteration_position = new QName("http://www.w3.org/ns/xproc", "iteration-position");
    public static final QName p_episode = new QName("http://www.w3.org/ns/xproc", "episode");
    public static final QName p_language = new QName("http://www.w3.org/ns/xproc", "language");
    public static final QName p_product_name = new QName("http://www.w3.org/ns/xproc", "product-name");
    public static final QName p_product_version = new QName("http://www.w3.org/ns/xproc", "product-version");
    public static final QName p_vendor = new QName("http://www.w3.org/ns/xproc", "vendor");
    public static final QName p_vendor_uri = new QName("http://www.w3.org/ns/xproc", "vendor-uri");
    public static final QName p_version = new QName("http://www.w3.org/ns/xproc", "version");
    public static final QName p_xpath_version = new QName("http://www.w3.org/ns/xproc", "xpath-version");
    public static final QName p_psvi_supported = new QName("http://www.w3.org/ns/xproc", "psvi-supported");
    public static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");
    public static final QName c_multipart = new QName("c", "http://www.w3.org/ns/xproc-step", "multipart");
    public static final QName c_header = new QName("c", "http://www.w3.org/ns/xproc-step", "header");
    public static final QName c_data = new QName("c", "http://www.w3.org/ns/xproc-step", "data");
    public static final QName c_content_type = new QName("c", "http://www.w3.org/ns/xproc-step", "content-type");
    public static final QName c_result = new QName("c", "http://www.w3.org/ns/xproc-step", "result");
    public static final QName c_request = new QName("c", "http://www.w3.org/ns/xproc-step", "request");
    public static final QName c_response = new QName("c", "http://www.w3.org/ns/xproc-step", "response");
    public static final QName c_param = new QName("c", "http://www.w3.org/ns/xproc-step", "param");
    public static final QName c_param_set = new QName("c", "http://www.w3.org/ns/xproc-step", "param-set");
    public static final QName c_errors = new QName("c", "http://www.w3.org/ns/xproc-step", "errors");
    public static final QName c_error = new QName("c", "http://www.w3.org/ns/xproc-step", "error");
    public static final QName xml_base = new QName("xml", "http://www.w3.org/XML/1998/namespace", "base");
    public static final QName xml_lang = new QName("xml", "http://www.w3.org/XML/1998/namespace", "lang");
    public static final QName xml_id = new QName("xml", "http://www.w3.org/XML/1998/namespace", "id");
    public static final QName cx_depends_on = new QName("cx", "http://xmlcalabash.com/ns/extensions", "depends-on");
    public static final QName cx_cache = new QName("cx", "http://xmlcalabash.com/ns/extensions", "cache");
    public static final QName cx_type = new QName("cx", "http://xmlcalabash.com/ns/extensions", "type");
    public static final QName xs_QName = new QName("xs", "http://www.w3.org/2001/XMLSchema", "QName");
    public static final QName xs_untypedAtomic = new QName("xs", "http://www.w3.org/2001/XMLSchema", "untypedAtomic");
    public static final QName xs_string = new QName("xs", "http://www.w3.org/2001/XMLSchema", "string");
    public static final QName xs_anyURI = new QName("xs", "http://www.w3.org/2001/XMLSchema", "anyURI");
    public static final QName xs_NCName = new QName("xs", "http://www.w3.org/2001/XMLSchema", "NCName");
    public static final QName xs_boolean = new QName("xs", "http://www.w3.org/2001/XMLSchema", "boolean");
    public static final QName xs_decimal = new QName("xs", "http://www.w3.org/2001/XMLSchema", "decimal");
    public static final QName xs_double = new QName("xs", "http://www.w3.org/2001/XMLSchema", "double");
    public static final QName xs_integer = new QName("xs", "http://www.w3.org/2001/XMLSchema", "integer");
    public static final QName xs_float = new QName("xs", "http://www.w3.org/2001/XMLSchema", "float");

    protected XProcConstants() {
    }

    private static String initializeVersion() {
        Properties config = new Properties();
        InputStream stream = null;
        try {
            stream = XProcConstants.class.getResourceAsStream("/etc/version.properties");
            if (stream == null) {
                throw new UnsupportedOperationException("JAR file doesn't contain version.properties file!?");
            }
            config.load(stream);
            String major = config.getProperty("version.major");
            String minor = config.getProperty("version.minor");
            String release = config.getProperty("version.release");
            if (major == null || minor == null || release == null) {
                throw new UnsupportedOperationException("Invalid version.properties in JAR file!?");
            }
            return String.valueOf(major) + "." + minor + "." + release;
        }
        catch (IOException ioe) {
            throw new UnsupportedOperationException("No version.properties in JAR file!?");
        }
    }

    public static QName staticError(int errno) {
        String localName = String.format("XS%04d", errno);
        return new QName("err", NS_XPROC_ERROR, localName);
    }

    public static QName dynamicError(int errno) {
        String localName = String.format("XD%04d", errno);
        return new QName("err", NS_XPROC_ERROR, localName);
    }

    public static QName stepError(int errno) {
        String localName = String.format("XC%04d", errno);
        return new QName("err", NS_XPROC_ERROR, localName);
    }
}

