/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.drivers.Main;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.UserArgs;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;

public class CalabashTask
extends MatchingTask {
    private UserArgs userArgs = new UserArgs();
    private Map<String, List<TypedResource>> inputResources = new HashMap<String, List<TypedResource>>();
    private Map<String, TypedFileNameMapper> inputMappers = new HashMap<String, TypedFileNameMapper>();
    private File baseDir = null;
    private String inPort = null;
    private Resource inResource = null;
    private Input.Type inType = Input.Type.XML;
    private boolean failOnNoResources = true;
    private Resource pipelineResource = null;
    private File destDir = null;
    private String outPort = null;
    private Resource outResource = null;
    private HashMap<String, Union> outputResources = new HashMap();
    private Map<String, FileNameMapper> outputMappers = new HashMap<String, FileNameMapper>();
    private String targetExtension = "-out.xml";
    private boolean isTargetExtensionSet = false;
    private boolean failOnError = true;
    private Union resources = new Union();
    private boolean useImplicitFileset = true;
    private boolean performDirectoryScan = true;
    private FileNameMapper mapper = null;
    private boolean force = false;
    private CommandlineJava.SysProperties sysProperties = new CommandlineJava.SysProperties();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<Option> options = new ArrayList<Option>();
    private List<Step> steps = new ArrayList<Step>();

    public void setBasedir(File dir) {
        this.baseDir = dir;
    }

    public void setInPort(String port) {
        this.inPort = port;
    }

    public void setIn(Resource inResource) {
        this.inResource = inResource;
    }

    public void setInType(Input.Type inType) {
        this.inType = inType;
    }

    public void addConfiguredInput(Input input) {
        if (!input.shouldUse()) {
            this.log("Skipping input '" + input.getPort() + "' as it is configured to be unused.", 4);
            return;
        }
        String port = input.getPort();
        FileNameMapper inputMapper = input.getMapper();
        Union resources = input.getResources();
        if (port == null) {
            port = this.inPort;
        }
        if (inputMapper != null) {
            if (resources.size() != 0) {
                this.handleError("Both mapper and fileset on input port: " + port);
                return;
            }
            if (port.equals(this.inPort)) {
                this.handleError("Cannot use mapper on main input port: " + port);
                return;
            }
            if (this.inputResources.containsKey(port)) {
                this.handleError("Mapper used on input port that already has resources: " + port);
                return;
            }
            if (this.inputMappers.containsKey(port)) {
                this.handleError("Mapper used on input port that already has a mapper: " + port);
                return;
            }
            this.inputMappers.put(port, new TypedFileNameMapper(inputMapper, input.getType(), input.getContentType()));
        } else {
            if (this.inputMappers.containsKey(port)) {
                this.handleError("Resources used on input port that already has a mapper: " + port);
                return;
            }
            if (resources.size() != 0 && !this.inputResources.containsKey(port)) {
                this.inputResources.put(port, new ArrayList());
            }
            Resource[] resourceArray = resources.listResources();
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                this.inputResources.get(port).add(new TypedResource(resource, input.getType(), input.getContentType()));
                ++n2;
            }
        }
    }

    public void setFailOnNoResources(boolean b) {
        this.failOnNoResources = b;
    }

    public void setPipeline(Resource pipeline) {
        try {
            this.userArgs.setPipeline(pipeline.getInputStream(), pipeline.toString());
            this.pipelineResource = pipeline;
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void addConfiguredPipeline(UseableResources pipeline) {
        if (!pipeline.shouldUse()) {
            this.log("Skipping pipeline as it is configured to be unused.", 4);
            return;
        }
        if (pipeline.size() == 0) {
            return;
        }
        if (pipeline.size() > 1) {
            this.handleError("The pipeline element must be specified with at most one nested resource.");
        }
        this.setPipeline((Resource)pipeline.iterator().next());
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setOutPort(String port) {
        this.outPort = port;
    }

    public void setOut(Resource outResource) {
        this.outResource = outResource;
    }

    public void addConfiguredOutput(Port o) {
        if (!o.shouldUse()) {
            this.log("Skipping output '" + o.getPort() + "' as it is configured to be unused.", 4);
            return;
        }
        String port = o.getPort();
        FileNameMapper outputMapper = o.getMapper();
        Union resources = o.getResources();
        if (port == null) {
            port = this.outPort;
        }
        if (outputMapper != null && resources.size() != 0) {
            this.handleError("Both mapper and fileset on output port: " + port);
            return;
        }
        if (outputMapper != null) {
            if (this.outputResources.containsKey(port)) {
                this.handleError("Mapper used on output port that already has resources: " + port);
                return;
            }
            if (this.outputMappers.containsKey(port)) {
                this.handleError("Mapper used on output port that already has a mapper: " + port);
                return;
            }
            this.outputMappers.put(port, outputMapper);
        } else {
            if (this.outputMappers.containsKey(port)) {
                this.handleError("Resources used on output port that already has a mapper: " + port);
                return;
            }
            if (!this.outputResources.containsKey(port)) {
                this.outputResources.put(port, new Union());
            }
            this.outputResources.get(port).add(resources);
        }
    }

    public void setExtension(String name) {
        this.targetExtension = name;
        this.isTargetExtensionSet = true;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void add(ResourceCollection rc) {
        this.resources.add(rc);
    }

    public void setUseImplicitFileset(boolean useimplicitfileset) {
        this.useImplicitFileset = useimplicitfileset;
    }

    public void setScanIncludedDirectories(boolean b) {
        this.performDirectoryScan = b;
    }

    public void addMapper(Mapper mapper) throws BuildException {
        this.add(mapper.getImplementation());
    }

    public void add(FileNameMapper fileNameMapper) throws BuildException {
        if (this.mapper != null) {
            this.handleError("Cannot define more than one mapper");
            return;
        }
        this.mapper = fileNameMapper;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.sysProperties.addVariable(sysp);
    }

    public void addSyspropertyset(PropertySet sysp) {
        this.sysProperties.addSyspropertyset(sysp);
    }

    public void addConfiguredNamespace(Namespace namespace) {
        if (!namespace.shouldUse()) {
            this.log("Skipping namespace '" + namespace.getPrefix() + "=" + namespace.getURI() + "' as it is configured to be unused.", 4);
            return;
        }
        if (namespace.getPrefix() == null) {
            this.handleError("<namespace> prefix cannot be null");
            return;
        }
        if (namespace.getURI() == null) {
            this.handleError("<namespace> URI cannot be null");
            return;
        }
        try {
            this.userArgs.addBinding(namespace.getPrefix(), namespace.getURI());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void addConfiguredOption(Option option) {
        if (!option.shouldUse()) {
            this.log("Skipping option '" + option.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        this.options.add(option);
    }

    public void useOption(Option option) {
        if (!option.shouldUse()) {
            this.log("Skipping option '" + option.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        try {
            this.userArgs.addOption(option.getName(), option.getValue());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void addConfiguredParameter(Parameter parameter) {
        if (!parameter.shouldUse()) {
            this.log("Skipping parameter '" + parameter.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        this.parameters.add(parameter);
    }

    public void useParameter(Parameter parameter) {
        if (!parameter.shouldUse()) {
            this.log("Skipping parameter '" + parameter.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        try {
            this.userArgs.addParam(parameter.getPort(), parameter.getName(), parameter.getValue());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setDebug(boolean debug) {
        try {
            this.userArgs.setDebug(debug);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setGeneralValues(boolean generalValues) {
        try {
            this.userArgs.setExtensionValues(generalValues);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setXPointerOnText(boolean xPointerOnText) {
        try {
            this.userArgs.setAllowXPointerOnText(xPointerOnText);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setUseXslt10(boolean useXslt10) {
        try {
            this.userArgs.setUseXslt10(useXslt10);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setTransparentJSON(boolean transparentJSON) {
        try {
            this.userArgs.setTransparentJSON(transparentJSON);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setJSONFlavor(String jsonFlavor) {
        try {
            this.userArgs.setJsonFlavor(jsonFlavor);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setProfileFile(Resource profileFile) {
        try {
            this.userArgs.setProfile(profileFile.getOutputStream());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void addConfiguredProfile(UseableResources profile) {
        if (!profile.shouldUse()) {
            this.log("Skipping profile as it is configured to be unused.", 4);
            return;
        }
        if (profile.size() == 0) {
            return;
        }
        if (profile.size() > 1) {
            this.handleError("The profile element must be specified with at most one nested resource.");
        }
        this.setProfileFile((Resource)profile.iterator().next());
    }

    public void setSaxonProcessor(String saxonProcessor) {
        try {
            this.userArgs.setSaxonProcessor(saxonProcessor);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setSaxonConfigFile(Resource saxonConfigFile) {
        try {
            this.userArgs.setSaxonConfig(saxonConfigFile.getInputStream(), saxonConfigFile.toString());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void addConfiguredSaxonConfig(UseableResources saxonConfig) {
        if (!saxonConfig.shouldUse()) {
            this.log("Skipping saxonConfig as it is configured to be unused.", 4);
            return;
        }
        if (saxonConfig.size() == 0) {
            return;
        }
        if (saxonConfig.size() > 1) {
            this.handleError("The saxonConfig element must be specified with at most one nested resource.");
        }
        this.setSaxonConfigFile((Resource)saxonConfig.iterator().next());
    }

    public void setSchemaAware(boolean schemaAware) {
        try {
            this.userArgs.setSchemaAware(schemaAware);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setSafeMode(boolean safeMode) {
        try {
            this.userArgs.setSafeMode(safeMode);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setConfigFile(Resource configFile) {
        try {
            this.userArgs.setConfig(configFile.getInputStream(), configFile.toString());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void addConfiguredConfig(UseableResources config) {
        if (!config.shouldUse()) {
            this.log("Skipping config as it is configured to be unused.", 4);
            return;
        }
        if (config.size() == 0) {
            return;
        }
        if (config.size() > 1) {
            this.handleError("The config element must be specified with at most one nested resource.");
        }
        this.setConfigFile((Resource)config.iterator().next());
    }

    public void setLogStyle(String logStyle) {
        try {
            this.userArgs.setLogStyle(logStyle);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setEntityResolver(Class entityResolver) {
        try {
            this.userArgs.setEntityResolverClass(entityResolver.getName());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void setURIResolver(Class uriResolver) {
        try {
            this.userArgs.setUriResolverClass(uriResolver.getName());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void addConfiguredLibrary(UseableResources libraries) {
        if (!libraries.shouldUse()) {
            this.log("Skipping library as it is configured to be unused.", 4);
            return;
        }
        try {
            Iterator iterator = libraries.iterator();
            while (iterator.hasNext()) {
                Resource library = (Resource)iterator.next();
                this.userArgs.addLibrary(library.getInputStream(), library.toString());
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void addConfiguredStep(Step step) {
        if (!step.shouldUse()) {
            this.log("Skipping step '" + step.getName() + "' as it is configured to be unused.", 4);
            return;
        }
        if (step.getName() == null) {
            this.handleError("Steps must have their 'name' attribute set");
        }
        this.steps.add(step);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute() {
        block53: {
            if (!(this.inResource == null && this.resources.size() == 0 && this.inputResources.isEmpty() && this.inputMappers.isEmpty() || this.steps.isEmpty())) {
                this.handleError("if steps are given, only active inputs nested in these steps are supported");
            }
            if (!this.parameters.isEmpty() && !this.steps.isEmpty()) {
                this.handleError("if steps are given, only active parameters nested in these steps are supported");
            }
            if (!this.options.isEmpty() && !this.steps.isEmpty()) {
                this.handleError("if steps are given, only active options nested in these steps are supported");
            }
            if (this.pipelineResource != null && !this.pipelineResource.isExists()) {
                this.handleError("pipeline '" + this.pipelineResource.getName() + "' does not exist");
                return;
            }
            if (this.inResource != null && !this.inResource.isExists()) {
                this.handleError("input file '" + this.inResource.getName() + "' does not exist");
                return;
            }
            if (this.inResource != null && this.resources.size() != 0) {
                this.handleError("'in' and explicit filesets cannot be used together.");
                return;
            }
            if ((this.inResource != null || this.outResource != null) && this.useImplicitFileset) {
                this.log("'in' and/or 'out' cannot be used with implicit fileset: ignoring implicit fileset.", 3);
                this.useImplicitFileset = false;
            }
            if (!this.steps.isEmpty() && this.useImplicitFileset) {
                this.log("steps cannot be used with implicit fileset: ignoring implicit fileset.", 3);
                this.useImplicitFileset = false;
            }
            if (this.outResource != null && this.mapper != null) {
                this.handleError("Nested <mapper> for default output and 'out' cannot be used together.");
                return;
            }
            if ((this.outputMappers.containsKey(this.outPort) || this.outputResources.containsKey(this.outPort)) && this.mapper != null) {
                this.handleError("Nested <mapper> and port for default output cannot be used together.");
                return;
            }
            if (this.outResource != null && this.isTargetExtensionSet) {
                this.handleError("'extension' and 'out' cannot be used together.");
                return;
            }
            if (this.isTargetExtensionSet && this.mapper != null) {
                this.handleError("'extension' and nested <mapper> cannot be used together.");
                return;
            }
            try {
                if (this.baseDir == null) {
                    this.baseDir = this.getProject().getBaseDir();
                }
                if (this.sysProperties.size() > 0) {
                    this.sysProperties.setSystem();
                }
                this.checkDest();
                if (this.inResource != null) {
                    i = new Input();
                    i.setPort(this.inPort);
                    i.add(this.inResource);
                    i.setType(this.inType);
                    this.addConfiguredInput(i);
                }
                if (this.outResource != null) {
                    o = new Port();
                    o.setPort(this.outPort);
                    o.add(this.outResource);
                    this.addConfiguredOutput(o);
                }
                if (this.outputResources.containsKey(this.outPort) && (this.isTargetExtensionSet || this.mapper != null)) {
                    this.handleError("Either 'out' or <output> corresponding to default output port and either 'extension' or nested <mapper> for naming output cannot be used together.");
                    return;
                }
                for (Parameter parameter : this.parameters) {
                    this.useParameter(parameter);
                }
                for (Option option : this.options) {
                    this.useOption(option);
                }
                if (!this.useImplicitFileset && this.resources.size() == 0) {
                    useInputResources = new HashMap<String, List<TypedResource>>();
                    useInputResources.putAll(this.inputResources);
                    for (String port : this.inputMappers.keySet()) {
                        inputMapper = this.inputMappers.get(port);
                        for (TypedResource typedResource : this.inputResources.get(this.inPort)) {
                            inputFileNames = inputMapper.mapFileName(typedResource.getResource().getName());
                            if (inputFileNames == null) continue;
                            mappedResources = new ArrayList<TypedResource>();
                            var12_26 = inputFileNames;
                            var11_24 = inputFileNames.length;
                            var10_20 = 0;
                            while (var10_20 < var11_24) {
                                fileName = var12_26[var10_20];
                                mappedResource = new FileResource(this.baseDir, fileName);
                                if (mappedResource.isExists()) {
                                    mappedResources.add(new TypedResource((Resource)mappedResource, inputMapper.getType(), inputMapper.getContentType()));
                                } else {
                                    this.log("Skipping non-exstent mapped resource: " + mappedResource.toString(), 4);
                                }
                                ++var10_20;
                            }
                            useInputResources.put(port, mappedResources);
                        }
                    }
                    useOutputResources = new HashMap<String, Union>();
                    useOutputResources.putAll(this.outputResources);
                    if (this.outputMappers.size() != 0) {
                        for (TypedResource typedResource : this.inputResources.get(this.inPort)) {
                            for (String port : this.outputMappers.keySet()) {
                                outputMapper = this.outputMappers.get(port);
                                outputFileNames = outputMapper.mapFileName(typedResource.getResource().getName());
                                if (outputFileNames == null) continue;
                                outputResources = new Union();
                                mappedResource = outputFileNames;
                                var12_27 = outputFileNames.length;
                                var11_24 = 0;
                                while (var11_24 < var12_27) {
                                    fileName = mappedResource[var11_24];
                                    outputResources.add(new FileResource(this.destDir, fileName));
                                    ++var11_24;
                                }
                                useOutputResources.put(port, outputResources);
                            }
                        }
                    }
                    this.process(useInputResources, useOutputResources);
                    break block53;
                }
                if (this.useImplicitFileset) {
                    scanner = this.getDirectoryScanner(this.baseDir);
                    this.log("Pipelining into " + this.destDir, 2);
                    includedFiles = scanner.getIncludedFiles();
                    i = 0;
                    while (i < includedFiles.length) {
                        this.resources.add(new FileResource(this.baseDir, includedFiles[i]));
                        ++i;
                    }
                    if (this.performDirectoryScan) {
                        includedDirs = scanner.getIncludedDirectories();
                        j = 0;
                        while (j < includedDirs.length) {
                            includedFiles = new File(this.baseDir, includedDirs[j]).list();
                            i = 0;
                            while (i < includedFiles.length) {
                                this.resources.add(new FileResource(this.baseDir, String.valueOf(includedDirs[j]) + File.separator + includedFiles[i]));
                                ++i;
                            }
                            ++j;
                        }
                    }
                } else if (this.resources.size() == 0) {
                    if (this.failOnNoResources) {
                        this.handleError("no resources specified");
                    }
                    return;
                }
                useMapper = null;
                if (!this.outputResources.containsKey(this.outPort)) {
                    useMapper = this.mapper != null ? this.mapper : new ExtensionMapper();
                }
                var5_11 = this.resources.listResources();
                var4_8 = var5_11.length;
                var3_6 = 0;
                while (var3_6 < var4_8) {
                    resource = var5_11[var3_6];
                    this.log("Resource: " + resource.getName(), 4);
                    useInputResources = new HashMap<String, List<TypedResource>>();
                    useInputResources.putAll(this.inputResources);
                    useInputResources.put(this.inPort, Arrays.asList(new TypedResource[]{new TypedResource(resource, this.inType)}));
                    for (String port : this.inputMappers.keySet()) {
                        inputMapper = this.inputMappers.get(port);
                        inputFileNames = inputMapper.mapFileName(resource.getName());
                        if (inputFileNames == null) continue;
                        mappedResources = new ArrayList<TypedResource>();
                        var15_33 = inputFileNames;
                        var14_32 = inputFileNames.length;
                        mappedResource = 0;
                        while (mappedResource < var14_32) {
                            fileName = var15_33[mappedResource];
                            mappedResource = new FileResource(this.baseDir, fileName);
                            mappedResources.add(new TypedResource(mappedResource, inputMapper.getType(), inputMapper.getContentType()));
                            ++mappedResource;
                        }
                        useInputResources.put(port, mappedResources);
                    }
                    useOutputResources = new HashMap<String, Union>();
                    useOutputResources.putAll(this.outputResources);
                    if (useMapper == null) ** GOTO lbl178
                    outFileName = useMapper.mapFileName(resource.getName());
                    if (outFileName == null || outFileName.length == 0) {
                        this.log("Skipping '" + resource.getName() + "' as it cannot be mapped to output.", 3);
                    } else if (outFileName == null || outFileName.length > 1) {
                        this.log("Skipping " + resource.getName() + " as its mapping is ambiguous.", 3);
                    } else {
                        useOutputResources.put(this.outPort, new Union(new FileResource(this.destDir, outFileName[0])));
lbl178:
                        // 4 sources

                        for (String port : this.outputMappers.keySet()) {
                            outputMapper = this.outputMappers.get(port);
                            outputFileNames = outputMapper.mapFileName(resource.getName());
                            if (outputFileNames == null) continue;
                            outputResources = new Union();
                            var16_35 = outputFileNames;
                            var15_34 = outputFileNames.length;
                            var14_32 = 0;
                            while (var14_32 < var15_34) {
                                fileName = var16_35[var14_32];
                                outputResources.add(new FileResource(this.destDir, fileName));
                                ++var14_32;
                            }
                            useOutputResources.put(port, outputResources);
                        }
                        this.process(useInputResources, useOutputResources);
                    }
                    ++var3_6;
                }
            }
            finally {
                this.userArgs = new UserArgs();
                this.inputResources.clear();
                this.inputMappers.clear();
                this.baseDir = null;
                this.inPort = null;
                this.inResource = null;
                this.inType = Input.Type.XML;
                this.failOnNoResources = true;
                this.pipelineResource = null;
                this.destDir = null;
                this.outPort = null;
                this.outResource = null;
                this.outputResources.clear();
                this.outputMappers.clear();
                this.targetExtension = "-out.xml";
                this.isTargetExtensionSet = false;
                this.failOnError = true;
                this.resources = new Union();
                this.useImplicitFileset = true;
                this.performDirectoryScan = true;
                this.mapper = null;
                this.force = false;
                if (this.sysProperties.size() > 0) {
                    this.sysProperties.restoreSystem();
                    this.sysProperties = new CommandlineJava.SysProperties();
                }
                this.parameters.clear();
                this.options.clear();
                this.steps.clear();
            }
        }
    }

    private void process(Map<String, List<TypedResource>> inputResources, Map<String, Union> outputResources) throws BuildException {
        if (!this.force && this.pipelineResource != null) {
            long pipelineLastModified = this.pipelineResource.getLastModified();
            pipelineLastModified = pipelineLastModified == 0L ? Long.MAX_VALUE : pipelineLastModified;
            Vector<Long> inputsLastModified = new Vector<Long>();
            for (String port : inputResources.keySet()) {
                for (TypedResource typedResource : inputResources.get(port)) {
                    long lastModified = typedResource.getResource().getLastModified();
                    inputsLastModified.add(lastModified == 0L ? Long.MAX_VALUE : lastModified);
                }
            }
            long newestInputLastModified = inputsLastModified.isEmpty() ? Long.MAX_VALUE : (Long)Collections.max(inputsLastModified);
            Vector<Long> outputsLastModified = new Vector<Long>();
            for (String port : outputResources.keySet()) {
                Resource[] resourceArray = outputResources.get(port).listResources();
                int n = resourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource resource = resourceArray[n2];
                    outputsLastModified.add(resource.getLastModified());
                    ++n2;
                }
            }
            long oldestOutputLastModified = outputsLastModified.isEmpty() ? 0L : (Long)Collections.min(outputsLastModified);
            this.log("Newest input time: " + newestInputLastModified, 4);
            this.log("Oldest output time: " + oldestOutputLastModified, 4);
            this.log("Pipeline file " + this.pipelineResource + " time: " + pipelineLastModified, 4);
            if (newestInputLastModified <= oldestOutputLastModified && pipelineLastModified <= oldestOutputLastModified) {
                this.log("Skipping because all outputs are newer than inputs and newer than pipeline", 4);
                return;
            }
        }
        try {
            Resource resource;
            for (String port : outputResources.keySet()) {
                Union resources = outputResources.get(port);
                Iterator iterator = resources.iterator();
                while (iterator.hasNext()) {
                    resource = (Resource)iterator.next();
                    this.userArgs.addOutput(port, resource.getOutputStream());
                }
            }
            for (String port : inputResources.keySet()) {
                for (TypedResource typedResource : inputResources.get(port)) {
                    resource = typedResource.getResource();
                    this.userArgs.addInput(port, resource.getInputStream(), resource.toString(), typedResource.getType(), typedResource.getContentType());
                }
            }
            for (Step step : this.steps) {
                for (Input input : step.getInputs()) {
                    Resource[] resourceArray = input.getResources().listResources();
                    int n = resourceArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        resource = resourceArray[n3];
                        this.userArgs.addInput(input.getPort(), resource.getInputStream(), resource.toString(), input.getType(), input.getContentType());
                        ++n3;
                    }
                }
                for (Parameter parameter : step.getParameters()) {
                    this.useParameter(parameter);
                }
                this.userArgs.setCurStepName(step.getName());
                for (Option option : step.getOptions()) {
                    this.useOption(option);
                }
            }
            new Main().run(this.userArgs, this.userArgs.createConfiguration());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private void checkDest() {
        if (this.destDir == null) {
            this.destDir = this.baseDir;
            this.log("destdir defaulting to basedir", 4);
        }
    }

    protected void handleError(String msg) {
        if (this.failOnError) {
            throw new BuildException(msg, this.getLocation());
        }
        this.log(msg, 1);
    }

    protected void handleError(Throwable ex) {
        if (this.failOnError) {
            throw new BuildException(ex);
        }
        this.log("Caught an exception: " + ex, 1);
        ex.printStackTrace(new PrintStream(new LogOutputStream(this, 3)));
    }

    private class ExtensionMapper
    implements FileNameMapper {
        private ExtensionMapper() {
        }

        @Override
        public void setFrom(String from) {
        }

        @Override
        public void setTo(String to) {
        }

        @Override
        public String[] mapFileName(String xmlFile) {
            int dotPos = xmlFile.lastIndexOf(46);
            if (dotPos > 0) {
                xmlFile = xmlFile.substring(0, dotPos);
            }
            return new String[]{String.valueOf(xmlFile) + CalabashTask.this.targetExtension};
        }
    }

    public static class Input
    extends Port {
        private Input.Type type = Input.Type.XML;
        private String contentType;

        public Input.Type getType() {
            return this.type;
        }

        public void setType(Input.Type type) {
            this.type = type;
        }

        public String getContentType() {
            if (this.contentType != null && this.type != Input.Type.DATA) {
                throw new IllegalStateException("contentType of input can only be set if type is DATA");
            }
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }

    public static class Namespace
    extends Useable {
        private String prefix = null;
        private String uri = null;

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setURI(String uri) {
            this.uri = uri;
        }

        public String getURI() {
            return this.uri;
        }
    }

    public static class Option
    extends Useable {
        private String name = null;
        private String value = null;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Parameter
    extends Option {
        private String port = "*";

        public void setPort(String port) {
            this.port = port;
        }

        public String getPort() {
            return this.port;
        }
    }

    public static class Port
    extends Useable {
        private String port = null;
        private Union resources = new Union();
        private FileNameMapper mapper = null;

        public void setPort(String port) {
            this.port = port;
        }

        public void add(ResourceCollection rc) {
            this.resources.add(rc);
        }

        public void addConfiguredMapper(Mapper mapper) throws BuildException {
            this.add(mapper.getImplementation());
        }

        public void add(FileNameMapper fileNameMapper) throws BuildException {
            if (this.mapper != null) {
                throw new BuildException("Cannot define more than one mapper");
            }
            this.mapper = fileNameMapper;
        }

        public String getPort() {
            return this.port;
        }

        public Union getResources() {
            return this.resources;
        }

        public FileNameMapper getMapper() {
            return this.mapper;
        }
    }

    public static class Step
    extends Useable {
        private String name = null;
        private List<Input> inputs = new ArrayList<Input>();
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private List<Option> options = new ArrayList<Option>();

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addConfiguredInput(Input input) {
            if (!input.shouldUse()) {
                ((Useable)this).project.log("Skipping input '" + input.getPort() + "' as it is configured to be unused.", 4);
                return;
            }
            this.inputs.add(input);
            if (input.getMapper() != null) {
                throw new BuildException("Mappers are not supported for inputs that are nested in steps");
            }
        }

        public List<Input> getInputs() {
            return this.inputs;
        }

        public void addConfiguredParameter(Parameter parameter) {
            this.parameters.add(parameter);
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void addConfiguredOption(Option option) {
            this.options.add(option);
        }

        public List<Option> getOptions() {
            return this.options;
        }
    }

    private static class TypedFileNameMapper
    implements FileNameMapper {
        private FileNameMapper fileNameMapper;
        private Input.Type type;
        private String contentType;

        private TypedFileNameMapper(FileNameMapper fileNameMapper, Input.Type type) {
            this(fileNameMapper, type, null);
        }

        private TypedFileNameMapper(FileNameMapper fileNameMapper, Input.Type type, String contentType) {
            if (fileNameMapper == null) {
                throw new IllegalArgumentException("fileNameMapper must not be null");
            }
            this.fileNameMapper = fileNameMapper;
            if (type == null) {
                throw new IllegalArgumentException("type must not be null");
            }
            this.type = type;
            this.contentType = contentType;
        }

        public Input.Type getType() {
            return this.type;
        }

        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void setFrom(String s) {
            this.fileNameMapper.setFrom(s);
        }

        @Override
        public void setTo(String s) {
            this.fileNameMapper.setTo(s);
        }

        @Override
        public String[] mapFileName(String s) {
            return this.fileNameMapper.mapFileName(s);
        }
    }

    private static class TypedResource {
        private Resource resource = null;
        private Input.Type type = null;
        private String contentType = null;

        private TypedResource(Resource resource, Input.Type type) {
            this(resource, type, (String)null);
        }

        private TypedResource(Resource resource, Input.Type type, String contentType) {
            if (resource == null) {
                throw new IllegalArgumentException("resource must not be null");
            }
            this.resource = resource;
            if (type == null) {
                throw new IllegalArgumentException("type must not be null");
            }
            this.type = type;
            this.contentType = contentType;
        }

        public Resource getResource() {
            return this.resource;
        }

        public Input.Type getType() {
            return this.type;
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    private static class Useable {
        private Project project;
        private Object ifCond;
        private Object unlessCond;

        private Useable() {
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public void setIf(Object ifCond) {
            this.ifCond = ifCond;
        }

        public void setUnless(Object unlessCond) {
            this.unlessCond = unlessCond;
        }

        public boolean shouldUse() {
            PropertyHelper ph = PropertyHelper.getPropertyHelper(this.project);
            return ph.testIfCondition(this.ifCond) && ph.testUnlessCondition(this.unlessCond);
        }

        /* synthetic */ Useable(Useable useable, Useable useable2) {
            this();
        }
    }

    public static class UseableResources
    extends Resources {
        private Useable useable = new Useable(null, null);

        public void setIf(Object ifCond) {
            this.useable.setIf(ifCond);
        }

        public void setUnless(Object unlessCond) {
            this.useable.setUnless(unlessCond);
        }

        public boolean shouldUse() {
            return this.useable.shouldUse();
        }
    }
}

