/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends XProcExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", "http://www.w3.org/ns/xproc", "system-property");

    protected SystemProperty() {
    }

    public SystemProperty(XProcRuntime runtime) {
        this.tl_runtime.set(runtime);
    }

    @Override
    public StructuredQName getFunctionQName() {
        return funcname;
    }

    @Override
    public int getMinimumNumberOfArguments() {
        return 1;
    }

    @Override
    public int getMaximumNumberOfArguments() {
        return 1;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    @Override
    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    @Override
    public ExtensionFunctionCall makeCallExpression() {
        return new SystemPropertyCall();
    }

    private class SystemPropertyCall
    extends ExtensionFunctionCall {
        private StaticContext staticContext = null;

        private SystemPropertyCall() {
        }

        @Override
        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.staticContext = context;
        }

        @Override
        public Sequence call(XPathContext xPathContext, Sequence[] sequences) throws XPathException {
            StructuredQName propertyName = null;
            XProcRuntime runtime = (XProcRuntime)SystemProperty.this.tl_runtime.get();
            XStep step = runtime.getXProcData().getStep();
            if (step != null && !(step instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            try {
                String lexicalQName = sequences[0].head().getStringValue();
                propertyName = StructuredQName.fromLexicalQName(lexicalQName, false, false, xPathContext.getConfiguration().getNameChecker(), this.staticContext.getNamespaceResolver());
            }
            catch (XPathException e) {
                if (e.getErrorCodeLocalPart() == null || e.getErrorCodeLocalPart().equals("FOCA0002") || e.getErrorCodeLocalPart().equals("FONS0004")) {
                    e.setErrorCode("XTDE1390");
                }
                throw e;
            }
            String uri = propertyName.getURI();
            String local = propertyName.getLocalPart();
            String value = "";
            if (uri.equals("http://www.w3.org/ns/xproc")) {
                if ("episode".equals(local)) {
                    value = runtime.getEpisode();
                } else if ("language".equals(local)) {
                    value = runtime.getLanguage();
                } else if ("product-name".equals(local)) {
                    value = runtime.getProductName();
                } else if ("product-version".equals(local)) {
                    value = runtime.getProductVersion();
                } else if ("vendor".equals(local)) {
                    value = runtime.getVendor();
                } else if ("vendor-uri".equals(local)) {
                    value = runtime.getVendorURI();
                } else if ("version".equals(local)) {
                    value = runtime.getXProcVersion();
                } else if ("xpath-version".equals(local)) {
                    value = runtime.getXPathVersion();
                } else if ("psvi-supported".equals(local)) {
                    value = runtime.getPSVISupported() ? "true" : "false";
                }
            } else if (uri.equals("http://xmlcalabash.com/ns/extensions")) {
                if ("transparent-json".equals(local)) {
                    value = runtime.transparentJSON() ? "true" : "false";
                } else if ("json-flavor".equals(local)) {
                    value = runtime.jsonFlavor();
                } else if ("general-values".equals(local)) {
                    value = runtime.getAllowGeneralExpressions() ? "true" : "false";
                } else if ("xpointer-on-text".equals(local)) {
                    value = runtime.getAllowXPointerOnText() ? "true" : "false";
                } else if ("use-xslt-1.0".equals(local) || "use-xslt-10".equals(local)) {
                    value = runtime.getUseXslt10Processor() ? "true" : "false";
                } else if ("saxon-version".equals(local)) {
                    value = runtime.getConfiguration().getProcessor().getSaxonProductVersion();
                } else if ("saxon-edition".equals(local)) {
                    value = runtime.getConfiguration().saxonProcessor;
                }
            }
            return new StringValue(value);
        }
    }
}

