/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;

public class StringReplace
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("", "match");
    private static final QName _replace = new QName("", "replace");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private RuntimeValue replace = null;
    private Hashtable<String, String> rns = new Hashtable();
    private static Hashtable<QName, RuntimeValue> atomicStepsGetNoInScopeOptions = new Hashtable();

    public StringReplace(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue match = this.getOption(_match);
        this.replace = this.getOption(_replace);
        for (String prefix : this.replace.getNamespaceBindings().keySet()) {
            this.rns.put(prefix, this.replace.getNamespaceBindings().get(prefix));
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), match);
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
        return false;
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        String newValue = this.computeReplacement(node);
        this.matcher.addAttribute(node, newValue);
    }

    private String computeReplacement(XdmNode node) {
        Vector<XdmItem> values = this.evaluateXPath(node, this.rns, this.replace.getString(), atomicStepsGetNoInScopeOptions);
        String newValue = "";
        for (XdmItem item : values) {
            newValue = String.valueOf(newValue) + item.getStringValue();
        }
        return newValue;
    }
}

