/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.XPointer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class XInclude
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName xi_include = new QName("http://www.w3.org/2001/XInclude", "include");
    private static final QName xi_fallback = new QName("http://www.w3.org/2001/XInclude", "fallback");
    private static final QName _fixup_xml_base = new QName("", "fixup-xml-base");
    private static final QName _fixup_xml_lang = new QName("", "fixup-xml-lang");
    private static final QName cx_mark_roots = new QName("cx", "http://xmlcalabash.com/ns/extensions", "mark-roots");
    private static final QName cx_copy_attributes = new QName("cx", "http://xmlcalabash.com/ns/extensions", "copy-attributes");
    private static final QName cx_root = new QName("cx", "http://xmlcalabash.com/ns/extensions", "root");
    private static final QName _encoding = new QName("", "encoding");
    private static final QName _href = new QName("", "href");
    private static final QName _parse = new QName("", "parse");
    private static final QName _xpointer = new QName("", "xpointer");
    private static final Pattern linesXptrRE = Pattern.compile("\\s*lines\\s*\\(\\s*(\\d+)\\s*-\\s*(\\d+)\\s*\\)\\s*");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Stack<ProcessMatch> matcherStack = new Stack();
    private Stack<String> inside = new Stack();
    private boolean fixupBase = false;
    private boolean fixupLang = false;
    private boolean markRoots = false;
    private boolean copyAttributes = false;
    private Exception mostRecentException = null;

    public XInclude(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.fixupBase = this.getOption(_fixup_xml_base, false);
        this.fixupLang = this.getOption(_fixup_xml_lang, false);
        String mark = this.getStep().getExtensionAttribute(cx_copy_attributes);
        if (mark != null && !"false".equals(mark)) {
            if ("true".equals(mark)) {
                this.copyAttributes = true;
            } else {
                throw new XProcException("On p:xinclude, cx:copy-attributes must be 'true' or 'false'.");
            }
        }
        if ((mark = this.getStep().getExtensionAttribute(cx_mark_roots)) != null && !"false".equals(mark)) {
            if ("true".equals(mark)) {
                this.markRoots = true;
            } else {
                throw new XProcException("On p:xinclude, cx:mark-roots must be 'true' or 'false'.");
            }
        }
        XdmNode doc = this.source.read();
        XdmNode xdoc = this.expandXIncludes(doc);
        this.result.write(xdoc);
    }

    private XdmNode expandXIncludes(XdmNode doc) {
        this.finest(doc, "Starting expandXIncludes");
        ProcessMatch matcher = new ProcessMatch(this.runtime, this);
        this.matcherStack.push(matcher);
        matcher.match(doc, new RuntimeValue("/|*", this.step.getNode()));
        XdmNode result = matcher.getResult();
        matcher = this.matcherStack.pop();
        return result;
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        this.matcherStack.peek().startDocument(node.getBaseURI());
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
        this.matcherStack.peek().endDocument();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        ProcessMatch matcher = this.matcherStack.peek();
        if (xi_include.equals(node.getNodeName())) {
            String href = node.getAttributeValue(_href);
            String parse = node.getAttributeValue(_parse);
            String xptr = node.getAttributeValue(_xpointer);
            XPointer xpointer = null;
            XdmNode subdoc = null;
            if (xptr != null) {
                xpointer = new XPointer(xptr);
            }
            if ("text".equals(parse)) {
                if (!this.runtime.getAllowXPointerOnText() && xpointer != null) {
                    throw XProcException.stepError(1, "XPointer is not allowed on XInclude when parse='text'");
                }
                String text = this.readText(href, node, node.getBaseURI().toASCIIString(), xpointer);
                if (text == null) {
                    this.finest(node, "XInclude text parse failed: " + href);
                    this.fallback(node, href);
                    return false;
                }
                this.finest(node, "XInclude text parse: " + href);
                matcher.addText(text);
                return false;
            }
            subdoc = this.readXML(href, node.getBaseURI().toASCIIString());
            String iuri = null;
            if (subdoc == null) {
                this.finest(node, "XInclude parse failed: " + href);
                this.fallback(node, href);
                return false;
            }
            iuri = subdoc.getBaseURI().toASCIIString();
            if (xptr != null) {
                iuri = String.valueOf(iuri) + "#" + xptr;
            }
            if (this.inside.contains(iuri)) {
                throw XProcException.stepError(29, "XInclude document includes itself: " + href);
            }
            this.finest(node, "XInclude parse: " + href);
            Vector<Object> nodes = null;
            if (xpointer == null) {
                nodes = new Vector();
                XdmSequenceIterator xdmSequenceIterator = subdoc.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    XdmNode child = (XdmNode)xdmSequenceIterator.next();
                    nodes.add(child);
                }
            } else {
                Hashtable<String, String> hashtable = xpointer.xpathNamespaces();
                nodes = xpointer.selectNodes(this.runtime, subdoc);
            }
            for (XdmNode xdmNode : nodes) {
                void var10_17;
                if ((this.fixupBase || this.fixupLang || this.markRoots || this.copyAttributes) && xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
                    Fixup fixup = new Fixup(this.runtime, node);
                    XdmNode xdmNode2 = fixup.fixup(xdmNode);
                }
                if (var10_17.getNodeKind() == XdmNodeKind.ELEMENT || var10_17.getNodeKind() == XdmNodeKind.DOCUMENT) {
                    this.inside.push(iuri);
                    XdmNode ex = this.expandXIncludes((XdmNode)var10_17);
                    matcher.addSubtree(ex);
                    this.inside.pop();
                    continue;
                }
                matcher.addSubtree((XdmNode)var10_17);
            }
            return false;
        }
        matcher.addStartElement(node);
        matcher.addAttributes(node);
        matcher.startContent();
        return true;
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("processAttribute can't happen in XInclude");
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
        if (!xi_include.equals(node.getNodeName())) {
            this.matcherStack.peek().addEndElement();
        }
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("processText can't happen in XInclude");
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("processComment can't happen in XInclude");
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        throw new UnsupportedOperationException("processPI can't happen in XInclude");
    }

    public String readText(String href, XdmNode node, String base, XPointer xpointer) {
        this.finest(null, "XInclude read text: " + href + " (" + base + ")");
        URI baseURI = null;
        try {
            baseURI = new URI(base);
        }
        catch (URISyntaxException use) {
            throw new XProcException(use);
        }
        URI hrefURI = baseURI.resolve(href);
        String data = "";
        try {
            URL url = hrefURI.toURL();
            URLConnection conn = url.openConnection();
            String contentType = conn.getContentType();
            int contentLength = conn.getContentLength();
            String charset = HttpUtils.getCharset(contentType);
            if (charset == null && node.getAttributeValue(_encoding) != null) {
                charset = node.getAttributeValue(_encoding);
            }
            if (charset == null) {
                charset = "utf-8";
            }
            InputStreamReader stream = null;
            BufferedReader rd = null;
            stream = charset == null ? new InputStreamReader(conn.getInputStream()) : new InputStreamReader(conn.getInputStream(), charset);
            if (xpointer != null) {
                data = xpointer.selectText(stream, contentLength);
            } else {
                String line;
                rd = new BufferedReader(stream);
                while ((line = rd.readLine()) != null) {
                    data = String.valueOf(data) + line + "\n";
                }
                rd.close();
            }
            stream.close();
        }
        catch (Exception e) {
            this.finest(null, "XInclude read text failed");
            this.mostRecentException = e;
            return null;
        }
        return data;
    }

    public XdmNode readXML(String href, String base) {
        this.finest(null, "XInclude read XML: " + href + " (" + base + ")");
        try {
            XdmNode doc = this.runtime.parse(href, base);
            return doc;
        }
        catch (Exception e) {
            this.finest(null, "XInclude read XML failed");
            this.mostRecentException = e;
            return null;
        }
    }

    public void fallback(XdmNode node, String href) {
        this.finest(node, "fallback: " + node.getNodeName());
        boolean valid = true;
        XdmNode fallback = null;
        for (XdmNode child : new RelevantNodes(this.runtime, node, Axis.CHILD)) {
            if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                valid = valid && xi_fallback.equals(child.getNodeName()) && fallback == null;
                fallback = child;
                continue;
            }
            valid = false;
        }
        if (!valid) {
            throw new XProcException(this.step.getNode(), "XInclude element must contain exactly one xi:fallback element.");
        }
        if (fallback == null) {
            if (this.mostRecentException != null) {
                throw new XProcException(this.step.getNode(), "XInclude resource error (" + href + ") and no fallback provided.", (Throwable)this.mostRecentException);
            }
            throw new XProcException(this.step.getNode(), "XInclude resource error (" + href + ") and no fallback provided.");
        }
        XdmSequenceIterator iter = fallback.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode fbc = (XdmNode)iter.next();
            if (fbc.getNodeKind() == XdmNodeKind.ELEMENT) {
                fbc = this.expandXIncludes(fbc);
            }
            this.matcherStack.peek().addSubtree(fbc);
        }
    }

    private class Fixup
    implements ProcessMatchingNodes {
        private XProcRuntime runtime = null;
        private ProcessMatch matcher = null;
        private boolean root = true;
        private XdmNode xinclude = null;

        public Fixup(XProcRuntime runtime, XdmNode node) {
            this.runtime = runtime;
            this.xinclude = node;
        }

        public XdmNode fixup(XdmNode node) {
            this.matcher = new ProcessMatch(this.runtime, this);
            this.matcher.match(node, new RuntimeValue("*", XInclude.this.step.getNode()));
            XdmNode fixed = this.matcher.getResult();
            return fixed;
        }

        @Override
        public boolean processStartDocument(XdmNode node) throws SaxonApiException {
            this.matcher.startDocument(node.getBaseURI());
            return true;
        }

        @Override
        public void processEndDocument(XdmNode node) throws SaxonApiException {
            this.matcher.endDocument();
        }

        @Override
        public boolean processStartElement(XdmNode node) throws SaxonApiException {
            HashSet<QName> copied = new HashSet<QName>();
            this.matcher.addStartElement(node);
            if (this.root) {
                XdmNode child;
                XdmSequenceIterator iter;
                this.root = false;
                if (XInclude.this.copyAttributes) {
                    iter = this.xinclude.axisIterator(Axis.ATTRIBUTE);
                    while (iter.hasNext()) {
                        child = (XdmNode)iter.next();
                        boolean copy = !"".equals(child.getNodeName().getNamespaceURI());
                        copy = copy && (!XProcConstants.xml_base.equals(child.getNodeName()) || !XInclude.this.fixupBase);
                        copy = copy && (!XProcConstants.xml_lang.equals(child.getNodeName()) || !XInclude.this.fixupLang);
                        boolean bl = copy = copy && (!cx_mark_roots.equals(child.getNodeName()) || !XInclude.this.markRoots);
                        if (!copy) continue;
                        copied.add(child.getNodeName());
                        this.matcher.addAttribute(child);
                    }
                }
                iter = node.axisIterator(Axis.ATTRIBUTE);
                while (iter.hasNext()) {
                    child = (XdmNode)iter.next();
                    if (XProcConstants.xml_base.equals(child.getNodeName()) && XInclude.this.fixupBase || XProcConstants.xml_lang.equals(child.getNodeName()) && XInclude.this.fixupLang || cx_mark_roots.equals(child.getNodeName()) && XInclude.this.markRoots || copied.contains(child.getNodeName())) continue;
                    copied.add(child.getNodeName());
                    this.matcher.addAttribute(child);
                }
                if (XInclude.this.fixupBase) {
                    copied.add(XProcConstants.xml_base);
                    this.matcher.addAttribute(XProcConstants.xml_base, node.getBaseURI().toASCIIString());
                }
                if (XInclude.this.markRoots) {
                    copied.add(cx_root);
                    this.matcher.addAttribute(cx_root, "true");
                }
                String lang = this.getLang(node);
                if (XInclude.this.fixupLang && lang != null) {
                    copied.add(XProcConstants.xml_lang);
                    this.matcher.addAttribute(XProcConstants.xml_lang, lang);
                }
            } else {
                XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
                while (iter.hasNext()) {
                    XdmNode child = (XdmNode)iter.next();
                    if (copied.contains(child.getNodeName())) continue;
                    this.matcher.addAttribute(child);
                }
            }
            this.matcher.startContent();
            return true;
        }

        @Override
        public void processAttribute(XdmNode node) throws SaxonApiException {
            throw new XProcException(node, "This can't happen!?");
        }

        @Override
        public void processEndElement(XdmNode node) throws SaxonApiException {
            this.matcher.addEndElement();
        }

        @Override
        public void processText(XdmNode node) throws SaxonApiException {
            throw new XProcException(node, "This can't happen!?");
        }

        @Override
        public void processComment(XdmNode node) throws SaxonApiException {
            throw new XProcException(node, "This can't happen!?");
        }

        @Override
        public void processPI(XdmNode node) throws SaxonApiException {
            throw new XProcException(node, "This can't happen!?");
        }

        private String getLang(XdmNode node) {
            String lang = null;
            while (lang == null && node.getNodeKind() == XdmNodeKind.ELEMENT) {
                lang = node.getAttributeValue(XProcConstants.xml_lang);
                node = node.getParent();
            }
            return lang;
        }
    }
}

