/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.ComputableValue;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.value.StringValue;

public class RuntimeValue {
    private Vector<XdmItem> generalValue = null;
    private String value = null;
    private XdmNode node = null;
    private ComputableValue val = null;
    private boolean initialized = false;
    private Hashtable<String, String> nsBindings = null;

    public RuntimeValue() {
    }

    public RuntimeValue(String value, XdmNode node) {
        this.value = value;
        this.node = node;
        this.initialized = true;
        this.nsBindings = new Hashtable();
        XdmSequenceIterator nsIter = node.axisIterator(Axis.NAMESPACE);
        while (nsIter.hasNext()) {
            XdmNode ns = (XdmNode)nsIter.next();
            QName nodeName = ns.getNodeName();
            String uri = ns.getStringValue();
            if (nodeName == null) {
                this.nsBindings.put("", uri);
                continue;
            }
            String localName = nodeName.getLocalName();
            this.nsBindings.put(localName, uri);
        }
    }

    public RuntimeValue(String value, XdmNode node, Hashtable<String, String> nsBindings) {
        this.value = value;
        this.node = node;
        this.nsBindings = nsBindings;
        this.initialized = true;
    }

    public RuntimeValue(String value, Vector<XdmItem> generalValue, XdmNode node, Hashtable<String, String> nsBindings) {
        this.value = value;
        this.generalValue = generalValue;
        this.node = node;
        this.nsBindings = nsBindings;
        this.initialized = true;
    }

    public RuntimeValue(String value) {
        this.value = value;
        this.initialized = true;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public XdmAtomicValue getUntypedAtomic(XProcRuntime runtime) {
        try {
            ItemTypeFactory itf = new ItemTypeFactory(runtime.getProcessor());
            ItemType untypedAtomic = itf.getAtomicType(new QName("http://www.w3.org/2001/XMLSchema", "xs:untypedAtomic"));
            XdmAtomicValue val = new XdmAtomicValue(this.value, untypedAtomic);
            return val;
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
    }

    public String getString() {
        return this.value;
    }

    public boolean hasGeneralValue() {
        return this.generalValue != null;
    }

    public XdmValue getValue() {
        if (this.generalValue == null) {
            throw new XProcException(this.node, "Unexpexted null value in getValue()");
        }
        if (this.generalValue.size() == 1) {
            return this.generalValue.get(0);
        }
        return new XdmValue(this.generalValue);
    }

    public StringValue getStringValue() {
        return new StringValue(this.value);
    }

    public QName getQName() {
        if (this.value.contains(":")) {
            return new QName(this.value, this.node);
        }
        return new QName("", this.value);
    }

    public XdmNode getNode() {
        return this.node;
    }

    public URI getBaseURI() {
        return this.node.getBaseURI();
    }

    public Hashtable<String, String> getNamespaceBindings() {
        return this.nsBindings;
    }

    public boolean getBoolean() {
        if ("true".equals(this.value) || "1".equals(this.value)) {
            return true;
        }
        if ("false".equals(this.value) || "0".equals(this.value)) {
            return false;
        }
        throw new XProcException(this.node, "Non boolean string: " + this.value);
    }

    public int getInt() {
        int result = Integer.parseInt(this.value);
        return result;
    }

    public XdmSequenceIterator getNamespaces() {
        return this.node.axisIterator(Axis.NAMESPACE);
    }
}

