/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadableDocument;
import com.xmlcalabash.io.ReadableInline;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.ComputableValue;
import com.xmlcalabash.model.DataBinding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.DocumentBinding;
import com.xmlcalabash.model.InlineBinding;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.NamespaceBinding;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XCatch;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XSelect;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TypeUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;

public class XAtomicStep
extends XStep {
    private static final QName _name = new QName("", "name");
    private static final QName _namespace = new QName("", "namespace");
    private static final QName _value = new QName("", "value");
    private static final QName _type = new QName("", "type");
    private static final QName cx_item = new QName("cx", "http://xmlcalabash.com/ns/extensions", "item");
    protected Hashtable<String, Vector<ReadablePipe>> inputs = new Hashtable();
    protected Hashtable<String, WritablePipe> outputs = new Hashtable();

    public XAtomicStep(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step);
        this.parent = parent;
    }

    @Override
    public XCompoundStep getParent() {
        return this.parent;
    }

    public boolean hasReadablePipes(String port) {
        if (this.inputs.containsKey(port)) {
            return this.inputs.get(port).size() > 0;
        }
        return false;
    }

    public boolean hasWriteablePipe(String port) {
        return this.outputs.containsKey(port);
    }

    @Override
    public RuntimeValue optionAvailable(QName optName) {
        if (!this.inScopeOptions.containsKey(optName)) {
            return null;
        }
        return (RuntimeValue)this.inScopeOptions.get(optName);
    }

    protected ReadablePipe getPipeFromBinding(Binding binding) {
        ReadablePipe pipe = null;
        if (binding.getBindingType() == 1) {
            PipeNameBinding pnbinding = (PipeNameBinding)binding;
            XCompoundStep start = this.parent;
            if (this instanceof XCompoundStep) {
                start = (XCompoundStep)this;
            }
            pipe = start.getBinding(pnbinding.getStep(), pnbinding.getPort());
        } else if (binding.getBindingType() == 2) {
            InlineBinding ibinding = (InlineBinding)binding;
            pipe = new ReadableInline(this.runtime, ibinding.nodes(), ibinding.getExcludedNamespaces());
        } else if (binding.getBindingType() == 5) {
            pipe = new ReadableDocument(this.runtime);
        } else if (binding.getBindingType() == 3) {
            DocumentBinding dbinding = (DocumentBinding)binding;
            pipe = this.runtime.getConfigurer().getXMLCalabashConfigurer().makeReadableDocument(this.runtime, dbinding);
        } else if (binding.getBindingType() == 8) {
            DataBinding dbinding = (DataBinding)binding;
            pipe = this.runtime.getConfigurer().getXMLCalabashConfigurer().makeReadableData(this.runtime, dbinding);
        } else if (binding.getBindingType() == 7) {
            XCompoundStep step = this.parent;
            while (!(step instanceof XCatch)) {
                step = step.getParent();
            }
            pipe = step.getBinding(step.getName(), "error");
        } else {
            throw new XProcException(binding.getNode(), "Unknown binding type: " + binding.getBindingType());
        }
        pipe.setReader(this.step);
        return pipe;
    }

    protected void instantiateReaders(Step step) {
        for (Input input : step.inputs()) {
            String port = input.getPort();
            if (port.startsWith("|")) continue;
            Vector<Object> readers = null;
            if (this.inputs.containsKey(port)) {
                readers = this.inputs.get(port);
            } else {
                readers = new Vector();
                this.inputs.put(port, readers);
            }
            for (Binding binding : input.getBinding()) {
                ReadablePipe pipe = this.getPipeFromBinding(binding);
                pipe.canReadSequence(input.getSequence());
                if (input.getSelect() != null) {
                    this.finest(step.getNode(), String.valueOf(step.getName()) + " selects from " + pipe + " for " + port);
                    pipe = new XSelect(this.runtime, this, pipe, input.getSelect(), input.getNode());
                }
                readers.add(pipe);
                this.finest(step.getNode(), String.valueOf(step.getName()) + " reads from " + pipe + " for " + port);
            }
            XInput xinput = new XInput(this.runtime, input);
            this.addInput(xinput);
        }
    }

    @Override
    public void instantiate(Step step) {
        this.instantiateReaders(step);
        for (Output output : step.outputs()) {
            String port = output.getPort();
            XOutput xoutput = new XOutput(this.runtime, output);
            xoutput.setLogger(step.getLog(port));
            this.addOutput(xoutput);
            WritablePipe wpipe = xoutput.getWriter();
            wpipe.canWriteSequence(output.getSequence());
            this.outputs.put(port, wpipe);
            this.finest(step.getNode(), String.valueOf(step.getName()) + " writes to " + wpipe + " for " + port);
        }
        this.parent.addStep(this);
    }

    protected void computeParameters(XProcStep xstep) throws SaxonApiException {
        Vector<String> paramPorts = new Vector<String>();
        boolean primaryParamPort = false;
        for (Input input : this.step.inputs()) {
            if (!input.getParameterInput()) continue;
            primaryParamPort |= input.getPrimary();
            paramPorts.add(input.getPort());
        }
        int position = 0;
        boolean loopdone = false;
        while (!loopdone) {
            ++position;
            loopdone = true;
            for (Parameter p : this.step.parameters()) {
                if ("http://www.w3.org/ns/xproc".equals(p.getName().getNamespaceURI())) {
                    throw XProcException.dynamicError(31);
                }
                boolean bl = loopdone = p.getPosition() <= position;
                if (p.getPosition() != position) continue;
                loopdone = false;
                if (!primaryParamPort) {
                    String port = p.getPort();
                    if (port == null) {
                        throw XProcException.staticError(34, this.step.getNode(), "No parameter input port.");
                    }
                    xstep.setParameter(p.getPort(), p.getName(), this.computeValue(p));
                    continue;
                }
                xstep.setParameter(p.getName(), this.computeValue(p));
            }
            for (String port : paramPorts) {
                Input input = this.step.getInput(port);
                boolean bl = loopdone = loopdone && input.getPosition() <= position;
                if (input.getPosition() != position) continue;
                for (ReadablePipe source : this.inputs.get(port)) {
                    while (source.moreDocuments()) {
                        XdmNode node = source.read();
                        XdmNode docelem = S9apiUtils.getDocumentElement(node);
                        if (XProcConstants.c_param_set.equals(docelem.getNodeName())) {
                            for (XdmNode attr : new RelevantNodes(this.runtime, docelem, Axis.ATTRIBUTE)) {
                                QName aname = attr.getNodeName();
                                if (!"".equals(aname.getNamespaceURI()) && !"http://www.w3.org/ns/xproc".equals(aname.getNamespaceURI())) continue;
                                throw XProcException.dynamicError(14, this.step.getNode(), "Attribute not allowed");
                            }
                            for (XdmNode child : new RelevantNodes(this.runtime, docelem, Axis.CHILD)) {
                                if (child.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                                if (!child.getNodeName().equals(XProcConstants.c_param)) {
                                    throw XProcException.dynamicError(18, this.step.getNode(), "Element not allowed: " + child.getNodeName());
                                }
                                this.parseParameterNode(xstep, child);
                            }
                            continue;
                        }
                        if (XProcConstants.c_param.equals(docelem.getNodeName())) {
                            this.parseParameterNode(xstep, docelem);
                            continue;
                        }
                        throw new XProcException(this.step.getNode(), docelem.getNodeName() + " found where c:param or c:param-set expected");
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        for (String port : this.inputs.keySet()) {
            for (ReadablePipe rpipe : this.inputs.get(port)) {
                rpipe.resetReader();
            }
        }
        for (String port : this.outputs.keySet()) {
            WritablePipe wpipe = this.outputs.get(port);
            wpipe.resetWriter();
        }
        this.clearOptions();
        this.clearParameters();
    }

    @Override
    public void run() throws SaxonApiException {
        WritablePipe wpipe;
        XProcStep xstep = this.runtime.getConfiguration().newStep(this.runtime, this);
        for (String port : this.inputs.keySet()) {
            int totalDocs = 0;
            Input input = this.step.getInput(port);
            if (!input.getParameterInput()) {
                ReadablePipe pipe;
                int readerCount = this.inputs.get(port).size();
                if (readerCount > 1) {
                    pipe = new Pipe(this.runtime);
                    ((Pipe)pipe).setWriter(this.step);
                    ((Pipe)pipe).setReader(this.step);
                    ((Pipe)pipe).canWriteSequence(true);
                    ((Pipe)pipe).canReadSequence(input.getSequence());
                    for (ReadablePipe reader : this.inputs.get(port)) {
                        if (reader.moreDocuments()) {
                            while (reader.moreDocuments()) {
                                XdmNode doc = reader.read();
                                ((Pipe)pipe).write(doc);
                                ++totalDocs;
                            }
                            continue;
                        }
                        if (!(reader instanceof ReadableDocument)) continue;
                        ++totalDocs;
                    }
                    xstep.setInput(port, pipe);
                } else if (readerCount == 1) {
                    pipe = this.inputs.get(port).firstElement();
                    pipe.setReader(this.step);
                    if (pipe.moreDocuments()) {
                        totalDocs += pipe.documentCount();
                    } else if (pipe instanceof ReadableDocument) {
                        ++totalDocs;
                    }
                    xstep.setInput(port, pipe);
                }
            }
            if (totalDocs == true || input.getSequence()) continue;
            throw XProcException.dynamicError(6, this.step.getNode(), String.valueOf(totalDocs) + " documents appear on the '" + port + "' port.");
        }
        for (String port : this.outputs.keySet()) {
            xstep.setOutput(port, this.outputs.get(port));
        }
        DeclareStep decl = this.step.getDeclaration();
        this.inScopeOptions = this.parent.getInScopeOptions();
        for (QName name : this.step.getOptions()) {
            Option option = this.step.getOption(name);
            RuntimeValue value = this.computeValue(option);
            Option optionDecl = decl.getOption(name);
            String typeName = optionDecl.getType();
            XdmNode declNode = optionDecl.getNode();
            if (typeName != null && declNode != null) {
                if (typeName.contains("|")) {
                    TypeUtils.checkLiteral(value.getString(), typeName);
                } else {
                    QName type = new QName(typeName, declNode);
                    TypeUtils.checkType(this.runtime, value.getString(), type, option.getNode());
                }
            }
            xstep.setOption(name, value);
            this.inScopeOptions.put(name, value);
        }
        xstep.reset();
        this.computeParameters(xstep);
        if (XProcConstants.p_in_scope_names.equals(this.step.getType())) {
            for (QName name : this.inScopeOptions.keySet()) {
                xstep.setParameter(name, (RuntimeValue)this.inScopeOptions.get(name));
            }
        }
        XProcData data = this.runtime.getXProcData();
        data.openFrame(this);
        this.runtime.start(this);
        xstep.run();
        this.runtime.finish(this);
        String cache = this.getInheritedExtensionAttribute(XProcConstants.cx_cache);
        if ("true".equals(cache)) {
            for (String port : this.outputs.keySet()) {
                wpipe = this.outputs.get(port);
                if (!(wpipe instanceof Pipe)) continue;
                Pipe rpipe = new Pipe(this.runtime, ((Pipe)wpipe).documents());
                rpipe.canReadSequence(true);
                rpipe.setReader(this.step);
                while (rpipe.moreDocuments()) {
                    XdmNode doc = rpipe.read();
                    this.runtime.cache(doc, this.step.getNode().getBaseURI());
                }
            }
        } else if (!"false".equals(cache) && cache != null) {
            throw XProcException.dynamicError(19);
        }
        for (String port : this.outputs.keySet()) {
            wpipe = this.outputs.get(port);
            wpipe.close();
        }
        data.closeFrame();
    }

    public void reportError(XdmNode doc) {
        this.parent.reportError(doc);
    }

    private void parseParameterNode(XProcStep impl, XdmNode pnode) {
        String value = pnode.getAttributeValue(_value);
        if (value == null && this.runtime.getAllowGeneralExpressions()) {
            this.parseParameterValueNode(impl, pnode);
            return;
        }
        Parameter p = new Parameter(this.step.getXProc(), pnode);
        String port = p.getPort();
        String name = pnode.getAttributeValue(_name);
        String ns = pnode.getAttributeValue(_namespace);
        QName pname = null;
        if (ns == null) {
            pname = new QName(name, pnode);
        } else {
            QName testNode;
            int pos = name.indexOf(":");
            if (pos > 0 && !ns.equals((testNode = new QName(name = name.substring(pos), pnode)).getNamespaceURI())) {
                throw XProcException.dynamicError(25);
            }
            pname = new QName(ns, name);
        }
        if ("http://www.w3.org/ns/xproc".equals(pname.getNamespaceURI())) {
            throw XProcException.dynamicError(31);
        }
        p.setName(pname);
        for (XdmNode attr : new RelevantNodes(this.runtime, pnode, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if (!"".equals(aname.getNamespaceURI()) || aname.equals(_name) || aname.equals(_namespace) || aname.equals(_value)) continue;
            throw XProcException.dynamicError(14);
        }
        if (port != null) {
            impl.setParameter(port, pname, new RuntimeValue(value, pnode));
        } else {
            impl.setParameter(pname, new RuntimeValue(value, pnode));
        }
    }

    private void parseParameterValueNode(XProcStep impl, XdmNode pnode) {
        Parameter p = new Parameter(this.step.getXProc(), pnode);
        String port = p.getPort();
        String name = pnode.getAttributeValue(_name);
        String ns = pnode.getAttributeValue(_namespace);
        QName pname = null;
        if (ns == null) {
            pname = new QName(name, pnode);
        } else {
            Object testNode;
            int pos = name.indexOf(":");
            if (pos > 0 && !ns.equals(((QName)(testNode = new QName(name = name.substring(pos), pnode))).getNamespaceURI())) {
                throw XProcException.dynamicError(25);
            }
            pname = new QName(ns, name);
        }
        p.setName(pname);
        for (XdmNode attr : new RelevantNodes(this.runtime, pnode, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if (!"".equals(aname.getNamespaceURI()) || aname.equals(_name) || aname.equals(_namespace)) continue;
            throw XProcException.dynamicError(14);
        }
        String stringValue = "";
        Vector<XdmItem> items = new Vector<XdmItem>();
        for (XdmNode child : new RelevantNodes(this.runtime, pnode, Axis.CHILD)) {
            if (child.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            if (!child.getNodeName().equals(cx_item)) {
                throw XProcException.dynamicError(18, this.step.getNode(), "Element not allowed: " + child.getNodeName());
            }
            String type = child.getAttributeValue(_type);
            if (type == null) {
                Vector<XdmValue> nodes = new Vector<XdmValue>();
                URI baseURI = null;
                XdmSequenceIterator iter = child.axisIterator(Axis.CHILD);
                while (iter.hasNext()) {
                    XdmNode gchild = (XdmNode)iter.next();
                    if (baseURI == null && gchild.getNodeKind() == XdmNodeKind.ELEMENT) {
                        baseURI = gchild.getBaseURI();
                    }
                    nodes.add(gchild);
                }
                XdmDestination dest = new XdmDestination();
                try {
                    if (baseURI == null) {
                        baseURI = new URI("http://example.com/");
                    }
                    S9apiUtils.writeXdmValue(this.runtime.getProcessor(), nodes, (Destination)dest, baseURI);
                    XdmNode doc = dest.getXdmNode();
                    stringValue = String.valueOf(stringValue) + doc.getStringValue();
                    items.add(doc);
                    continue;
                }
                catch (URISyntaxException use) {
                    throw new XProcException(use);
                }
                catch (SaxonApiException sae) {
                    throw new XProcException(sae);
                }
            }
            stringValue = String.valueOf(stringValue) + child.getStringValue();
            items.add(new XdmAtomicValue(child.getStringValue()));
        }
        RuntimeValue value = new RuntimeValue(stringValue, items, pnode, new Hashtable<String, String>());
        if (port != null) {
            impl.setParameter(port, pname, value);
        } else {
            impl.setParameter(pname, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected RuntimeValue computeValue(ComputableValue var) {
        Pattern varrefpat;
        Matcher varref;
        XdmNode node;
        Hashtable<String, String> nsBindings = new Hashtable<String, String>();
        Hashtable globals = this.inScopeOptions;
        XdmNode doc = null;
        try {
            if (var.getBinding().size() > 0) {
                Binding binding = var.getBinding().firstElement();
                Object pipe = null;
                pipe = binding.getBindingType() == 7 ? ((XCatch)this).errorPipe : this.getPipeFromBinding(binding);
                doc = pipe.read();
                if (pipe.moreDocuments()) {
                    throw XProcException.dynamicError(this.step, 8, "More than one document in context for parameter '" + var.getName() + "'");
                }
            }
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        for (NamespaceBinding nsbinding : var.getNamespaceBindings()) {
            Hashtable<Object, Object> localBindings = new Hashtable();
            if (nsbinding.getBinding() != null) {
                QName binding = new QName(nsbinding.getBinding(), nsbinding.getNode());
                RuntimeValue nsv = (RuntimeValue)globals.get(binding);
                if (nsv == null) {
                    throw new XProcException(var.getNode(), "No in-scope option or variable named: " + binding);
                }
                localBindings = nsv.getNamespaceBindings();
            } else if (nsbinding.getXPath() != null) {
                try {
                    XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
                    xcomp.setBaseURI(this.step.getNode().getBaseURI());
                    for (QName varname : globals.keySet()) {
                        xcomp.declareVariable(varname);
                    }
                    Hashtable<String, Object> lclnsBindings = new Hashtable<String, Object>();
                    NodeInfo inode = nsbinding.getNode().getUnderlyingNode();
                    NamePool namePool = inode.getNamePool();
                    InscopeNamespaceResolver inscopeNS = new InscopeNamespaceResolver(inode);
                    Iterator<String> pfxiter = inscopeNS.iteratePrefixes();
                    while (pfxiter.hasNext()) {
                        String nspfx = pfxiter.next();
                        String nsuri = inscopeNS.getURIForPrefix(nspfx, "".equals(nspfx));
                        lclnsBindings.put(nspfx, nsuri);
                    }
                    for (String prefix : lclnsBindings.keySet()) {
                        xcomp.declareNamespace(prefix, (String)lclnsBindings.get(prefix));
                    }
                    XPathExecutable xexec = xcomp.compile(nsbinding.getXPath());
                    XPathSelector selector = xexec.load();
                    for (QName varname : globals.keySet()) {
                        XdmAtomicValue avalue = new XdmAtomicValue(((RuntimeValue)globals.get(varname)).getString());
                        selector.setVariable(varname, avalue);
                    }
                    if (doc != null) {
                        selector.setContextItem(doc);
                    }
                    XdmNode element = null;
                    for (XdmItem item : selector) {
                        if (element != null || item.isAtomicValue()) {
                            throw XProcException.dynamicError(9);
                        }
                        element = (XdmNode)item;
                        if (element.getNodeKind() == XdmNodeKind.ELEMENT) continue;
                        throw XProcException.dynamicError(9);
                    }
                    if (element == null) {
                        throw XProcException.dynamicError(9);
                    }
                    XdmSequenceIterator nsIter = element.axisIterator(Axis.NAMESPACE);
                    while (nsIter.hasNext()) {
                        XdmNode ns = (XdmNode)nsIter.next();
                        QName prefix = ns.getNodeName();
                        localBindings.put(prefix == null ? "" : prefix.getLocalName(), ns.getStringValue());
                    }
                }
                catch (SaxonApiException sae) {
                    throw new XProcException(sae);
                }
            } else if (nsbinding.getNamespaceBindings() != null) {
                localBindings = nsbinding.getNamespaceBindings();
            }
            HashSet<String> prefixes = new HashSet<String>();
            for (String uri : nsbinding.getExcludedNamespaces()) {
                for (String string : localBindings.keySet()) {
                    if (!uri.equals(localBindings.get(string))) continue;
                    prefixes.add(string);
                }
            }
            for (String prefix : prefixes) {
                localBindings.remove(prefix);
            }
            for (Object pfx : localBindings.keySet()) {
                if (nsBindings.containsKey(pfx) && !nsBindings.get(pfx).equals(localBindings.get(pfx))) {
                    throw XProcException.dynamicError(13);
                }
                nsBindings.put((String)pfx, (String)localBindings.get(pfx));
            }
        }
        String select = var.getSelect();
        Vector<XdmItem> results = this.evaluateXPath(doc, nsBindings, select, globals);
        String value = "";
        try {
            for (XdmItem item : results) {
                if (item.isAtomicValue()) {
                    value = String.valueOf(value) + item.getStringValue();
                    continue;
                }
                node = (XdmNode)item;
                if (node.getNodeKind() == XdmNodeKind.ATTRIBUTE || node.getNodeKind() == XdmNodeKind.NAMESPACE) {
                    value = String.valueOf(value) + node.getStringValue();
                    continue;
                }
                XdmDestination xdmDestination = new XdmDestination();
                S9apiUtils.writeXdmValue(this.runtime, item, (Destination)xdmDestination, null);
                value = String.valueOf(value) + xdmDestination.getXdmNode().getStringValue();
            }
        }
        catch (SaxonApiUncheckedException saue) {
            Throwable sae = saue.getCause();
            if (sae instanceof XPathException) {
                XPathException xe = (XPathException)sae;
                if ("http://www.w3.org/2005/xqt-errors".equals(xe.getErrorCodeNamespace()) && "XPDY0002".equals(xe.getErrorCodeLocalPart())) {
                    throw XProcException.dynamicError(26, this.step.getNode(), "The expression for $" + var.getName() + " refers to the context item.");
                }
                throw saue;
            }
            throw saue;
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        if (var.getType() != null) {
            String type = var.getType();
            if (type.contains("|")) {
                TypeUtils.checkLiteral(value, type);
            } else if (type.contains(":")) {
                TypeUtils.checkType(this.runtime, value, var.getTypeAsQName(), var.getNode());
            }
        }
        if ((varref = (varrefpat = Pattern.compile("^\\s*\\$([^\\s=]+)\\s*$")).matcher(select)).matches()) {
            void var11_23;
            String varrefstr = varref.group(1);
            Object var11_20 = null;
            if (varrefstr.contains(":")) {
                String vpfx = varrefstr.substring(0, varrefstr.indexOf(":"));
                String vlocal = varrefstr.substring(varrefstr.indexOf(":") + 1);
                String vns = nsBindings.get(vpfx);
                QName qName = new QName(vpfx, vns, vlocal);
            } else {
                QName qName = new QName("", varrefstr);
            }
            RuntimeValue val = (RuntimeValue)globals.get(var11_23);
            nsBindings = val.getNamespaceBindings();
        }
        if (results.size() > 0 && results.get(0) instanceof XdmNode) {
            node = (XdmNode)results.get(0);
            nsBindings.clear();
            XdmSequenceIterator xdmSequenceIterator = node.axisIterator(Axis.NAMESPACE);
            while (xdmSequenceIterator.hasNext()) {
                XdmNode ns = (XdmNode)xdmSequenceIterator.next();
                nsBindings.put(ns.getNodeName() == null ? "" : ns.getNodeName().getLocalName(), ns.getStringValue());
            }
        }
        if (this.runtime.getAllowGeneralExpressions()) {
            return new RuntimeValue(value, results, var.getNode(), nsBindings);
        }
        return new RuntimeValue(value, var.getNode(), nsBindings);
    }

    protected Vector<XdmItem> evaluateXPath(XdmNode doc, Hashtable<String, String> nsBindings, String xpath, Hashtable<QName, RuntimeValue> globals) {
        Vector<XdmItem> results = new Vector<XdmItem>();
        Hashtable<QName, RuntimeValue> boundOpts = new Hashtable<QName, RuntimeValue>();
        for (QName name : globals.keySet()) {
            RuntimeValue v = globals.get(name);
            if (!v.initialized()) continue;
            boundOpts.put(name, v);
        }
        try {
            XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
            xcomp.setBaseURI(this.step.getNode().getBaseURI());
            for (QName varname : boundOpts.keySet()) {
                xcomp.declareVariable(varname);
            }
            for (String prefix : nsBindings.keySet()) {
                xcomp.declareNamespace(prefix, nsBindings.get(prefix));
            }
            XPathExecutable xexec = null;
            try {
                xexec = xcomp.compile(xpath);
            }
            catch (SaxonApiException sae) {
                XPathException xe;
                Throwable t = sae.getCause();
                if (t instanceof XPathException && (xe = (XPathException)t).getMessage().contains("Undeclared (or unbound?) variable")) {
                    throw XProcException.dynamicError(26, this.step.getNode(), xe.getMessage());
                }
                throw sae;
            }
            XPathSelector selector = xexec.load();
            for (QName varname : boundOpts.keySet()) {
                XdmValue value = null;
                RuntimeValue rval = (RuntimeValue)boundOpts.get(varname);
                value = this.runtime.getAllowGeneralExpressions() && rval.hasGeneralValue() ? rval.getValue() : rval.getUntypedAtomic(this.runtime);
                selector.setVariable(varname, value);
            }
            if (doc != null) {
                selector.setContextItem(doc);
            }
            try {
                Iterator<XdmItem> values = selector.iterator();
                while (values.hasNext()) {
                    results.add(values.next());
                }
            }
            catch (SaxonApiUncheckedException saue) {
                Throwable sae = saue.getCause();
                if (sae instanceof XPathException) {
                    XPathException xe = (XPathException)sae;
                    if ("http://www.w3.org/2005/xqt-errors".equals(xe.getErrorCodeNamespace()) && "XPDY0002".equals(xe.getErrorCodeLocalPart())) {
                        throw XProcException.dynamicError(26, this.step.getNode(), "Expression refers to context when none is available: " + xpath);
                    }
                    throw saue;
                }
                throw saue;
            }
        }
        catch (SaxonApiException sae) {
            if (S9apiUtils.xpathSyntaxError(sae)) {
                throw XProcException.dynamicError(23, this.step.getNode(), sae.getCause().getMessage());
            }
            throw new XProcException(sae);
        }
        return results;
    }
}

